/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.whiteboard.internal.manager;

import javax.servlet.Filter;
import org.apache.felix.http.api.ExtHttpService;
import org.apache.felix.http.base.internal.logger.SystemLogger;
import org.apache.felix.http.whiteboard.internal.manager.AbstractMapping;
import org.osgi.framework.Bundle;
import org.osgi.service.http.HttpService;

public final class FilterMapping
extends AbstractMapping {
    private final Filter filter;
    private final int ranking;
    private final String pattern;

    public FilterMapping(Bundle bundle, Filter filter, String pattern, int ranking) {
        super(bundle);
        this.filter = filter;
        this.pattern = pattern;
        this.ranking = ranking;
    }

    @Override
    public void register(HttpService httpService) {
        if (httpService instanceof ExtHttpService) {
            this.register((ExtHttpService)httpService);
        } else {
            SystemLogger.warning("Unable to register filter for " + this.pattern + ", as no ExtHttpService seems to be present!", null);
        }
    }

    @Override
    public void unregister(HttpService httpService) {
        if (httpService instanceof ExtHttpService) {
            this.unregister((ExtHttpService)httpService);
        } else {
            SystemLogger.warning("Unable to unregister filter for " + this.pattern + ", as no ExtHttpService seems to be present!", null);
        }
    }

    Filter getFilter() {
        return this.filter;
    }

    String getPattern() {
        return this.pattern;
    }

    int getRanking() {
        return this.ranking;
    }

    private void register(ExtHttpService httpService) {
        if (!this.isRegistered() && this.getContext() != null) {
            try {
                httpService.registerFilter(this.filter, this.pattern, this.getInitParams(), this.ranking, this.getContext());
                this.setRegistered(true);
            }
            catch (Exception e) {
                SystemLogger.warning("Failed to register filter for " + this.pattern, null);
                SystemLogger.debug("Failed to register filter for " + this.pattern + "; details:", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregister(ExtHttpService httpService) {
        if (this.isRegistered()) {
            try {
                httpService.unregisterFilter(this.filter);
            }
            catch (Exception e) {
                SystemLogger.debug("Failed to unregister filter for " + this.pattern, e);
            }
            finally {
                this.setRegistered(false);
            }
        }
    }
}

