/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.whiteboard.internal;

import java.util.ArrayList;
import org.apache.felix.http.base.internal.AbstractActivator;
import org.apache.felix.http.base.internal.logger.SystemLogger;
import org.apache.felix.http.whiteboard.internal.manager.ExtenderManager;
import org.apache.felix.http.whiteboard.internal.manager.ExtenderManagerImpl;
import org.apache.felix.http.whiteboard.internal.tracker.FilterTracker;
import org.apache.felix.http.whiteboard.internal.tracker.HttpContextTracker;
import org.apache.felix.http.whiteboard.internal.tracker.HttpServiceTracker;
import org.apache.felix.http.whiteboard.internal.tracker.ServletTracker;
import org.osgi.util.tracker.ServiceTracker;

public final class WhiteboardActivator
extends AbstractActivator {
    private final ArrayList<ServiceTracker> trackers = new ArrayList();
    private ExtenderManager manager;

    protected void doStart() throws Exception {
        this.manager = new ExtenderManagerImpl();
        this.addTracker(new HttpContextTracker(this.getBundleContext(), this.manager));
        this.addTracker(new FilterTracker(this.getBundleContext(), this.manager));
        this.addTracker(new ServletTracker(this.getBundleContext(), this.manager));
        this.addTracker(new HttpServiceTracker(this.getBundleContext(), this.manager));
        SystemLogger.info("Http service whiteboard started");
    }

    private void addTracker(ServiceTracker tracker) {
        this.trackers.add(tracker);
        tracker.open();
    }

    protected void doStop() throws Exception {
        for (ServiceTracker tracker : this.trackers) {
            tracker.close();
        }
        this.trackers.clear();
        this.manager.unregisterAll();
    }
}

