/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.handler;

import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.http.base.internal.context.ExtServletContext;
import org.apache.felix.http.base.internal.handler.AbstractHandler;
import org.apache.felix.http.base.internal.handler.ServletConfigImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ServletHandler
extends AbstractHandler
implements Comparable<ServletHandler> {
    private final String alias;
    private final Servlet servlet;

    public ServletHandler(ExtServletContext context, Servlet servlet, String alias) {
        super(context);
        this.alias = alias;
        this.servlet = servlet;
    }

    public String getAlias() {
        return this.alias;
    }

    public Servlet getServlet() {
        return this.servlet;
    }

    @Override
    public void init() throws ServletException {
        String name = "servlet_" + this.getId();
        ServletConfigImpl config = new ServletConfigImpl(name, this.getContext(), this.getInitParams());
        this.servlet.init((ServletConfig)config);
    }

    @Override
    public void destroy() {
        this.servlet.destroy();
    }

    public boolean matches(String uri) {
        if (this.alias.equals("/")) {
            return uri.startsWith(this.alias);
        }
        return uri.equals(this.alias) || uri.startsWith(this.alias + "/");
    }

    public boolean handle(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        boolean matches = this.matches(req.getPathInfo());
        if (matches) {
            this.doHandle(req, res);
        }
        return matches;
    }

    private void doHandle(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        if (!this.getContext().handleSecurity(req, res)) {
            if (!res.isCommitted()) {
                res.sendError(403);
            }
        } else {
            this.servlet.service((ServletRequest)new RequestWrapper(req), (ServletResponse)res);
        }
    }

    @Override
    public int compareTo(ServletHandler other) {
        return other.alias.length() - this.alias.length();
    }

    private final class RequestWrapper
    extends HttpServletRequestWrapper {
        private String pathInfo;
        private boolean pathInfoComputed;

        public RequestWrapper(HttpServletRequest req) {
            super(req);
            this.pathInfoComputed = false;
        }

        public String getPathInfo() {
            if (!this.pathInfoComputed) {
                int servletPathLength = this.getServletPath().length();
                this.pathInfo = this.getRequestURI().substring(this.getContextPath().length()).replaceAll("[/]{2,}", "/").substring(servletPathLength);
                if ("".equals(this.pathInfo) && servletPathLength != 0) {
                    this.pathInfo = null;
                }
                this.pathInfoComputed = true;
            }
            return this.pathInfo;
        }

        public String getPathTranslated() {
            String info = this.getPathInfo();
            return null == info ? null : this.getRealPath(info);
        }

        public String getServletPath() {
            return ServletHandler.this.alias;
        }
    }
}

