/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.javaxwrappers;

import jakarta.servlet.http.Cookie;
import org.jetbrains.annotations.NotNull;

public class CookieWrapper
extends javax.servlet.http.Cookie {
    private static final long serialVersionUID = -6762987885237379239L;
    private final Cookie cookie;

    public static javax.servlet.http.Cookie[] wrap(Cookie[] array) {
        if (array == null) {
            return null;
        }
        javax.servlet.http.Cookie[] result = new javax.servlet.http.Cookie[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = new CookieWrapper(array[i]);
        }
        return result;
    }

    public CookieWrapper(@NotNull Cookie c) {
        super(c.getName(), c.getValue());
        this.cookie = c;
        super.setComment(c.getComment());
        if (c.getDomain() != null) {
            super.setDomain(c.getDomain());
        }
        super.setHttpOnly(c.isHttpOnly());
        super.setMaxAge(c.getMaxAge());
        super.setPath(c.getPath());
        super.setSecure(c.getSecure());
        super.setVersion(c.getVersion());
    }

    public void setComment(String purpose) {
        this.cookie.setComment(purpose);
        super.setComment(purpose);
    }

    public void setDomain(String domain) {
        this.cookie.setDomain(domain);
        super.setDomain(domain);
    }

    public void setMaxAge(int expiry) {
        this.cookie.setMaxAge(expiry);
        super.setMaxAge(expiry);
    }

    public void setPath(String uri) {
        this.cookie.setPath(uri);
        super.setPath(uri);
    }

    public void setSecure(boolean flag) {
        this.cookie.setSecure(flag);
        super.setSecure(flag);
    }

    public void setValue(String newValue) {
        this.cookie.setValue(newValue);
        super.setValue(newValue);
    }

    public void setVersion(int v) {
        this.cookie.setVersion(v);
        super.setVersion(v);
    }

    public void setHttpOnly(boolean isHttpOnly) {
        this.cookie.setHttpOnly(isHttpOnly);
        super.setHttpOnly(isHttpOnly);
    }
}

