/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.handler;

import javax.servlet.Filter;
import org.apache.felix.http.base.internal.context.ExtServletContext;
import org.apache.felix.http.base.internal.handler.FilterHandler;
import org.apache.felix.http.base.internal.runtime.FilterInfo;
import org.apache.felix.http.base.internal.util.ServiceUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public final class WhiteboardFilterHandler
extends FilterHandler {
    private final BundleContext bundleContext;

    public WhiteboardFilterHandler(long contextServiceId, ExtServletContext context, FilterInfo filterInfo, BundleContext bundleContext) {
        super(contextServiceId, context, filterInfo);
        this.bundleContext = bundleContext;
    }

    @Override
    public int init() {
        if (this.useCount > 0) {
            ++this.useCount;
            return -1;
        }
        ServiceReference serviceReference = this.getFilterInfo().getServiceReference();
        this.setFilter((Filter)ServiceUtils.safeGetServiceObjects(this.bundleContext, serviceReference));
        int reason = super.init();
        if (reason != -1) {
            ServiceUtils.safeUngetServiceObjects(this.bundleContext, serviceReference, this.getFilter());
            this.setFilter(null);
        }
        return reason;
    }

    @Override
    public boolean destroy() {
        Filter f = this.getFilter();
        if (f != null && super.destroy()) {
            ServiceUtils.safeUngetServiceObjects(this.bundleContext, this.getFilterInfo().getServiceReference(), f);
            return true;
        }
        return false;
    }
}

