/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.whiteboard;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Map;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestListener;
import javax.servlet.SessionCookieConfig;
import javax.servlet.SessionTrackingMode;
import javax.servlet.descriptor.JspConfigDescriptor;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionListener;
import org.apache.felix.http.base.internal.context.ExtServletContext;
import org.apache.felix.http.base.internal.registry.EventListenerRegistry;
import org.apache.felix.http.base.internal.util.MimeTypes;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.http.context.ServletContextHelper;

public class PerBundleServletContextImpl
implements ExtServletContext {
    private final Bundle bundle;
    private final ServletContext delegatee;
    private final ServletContextHelper contextHelper;
    private final EventListenerRegistry eventListenerRegistry;

    public PerBundleServletContextImpl(Bundle bundle, ServletContext sharedContext, ServletContextHelper delegatee, EventListenerRegistry eventListenerRegistry) {
        this.bundle = bundle;
        this.delegatee = sharedContext;
        this.contextHelper = delegatee;
        this.eventListenerRegistry = eventListenerRegistry;
    }

    @Override
    public boolean handleSecurity(HttpServletRequest req, HttpServletResponse res) throws IOException {
        return this.contextHelper.handleSecurity(req, res);
    }

    @Override
    public void finishSecurity(HttpServletRequest req, HttpServletResponse res) {
        this.contextHelper.finishSecurity(req, res);
    }

    @Override
    public HttpSessionListener getHttpSessionListener() {
        return this.eventListenerRegistry;
    }

    @Override
    public HttpSessionAttributeListener getHttpSessionAttributeListener() {
        return this.eventListenerRegistry;
    }

    @Override
    public ServletRequestListener getServletRequestListener() {
        return this.eventListenerRegistry;
    }

    @Override
    public ServletRequestAttributeListener getServletRequestAttributeListener() {
        return this.eventListenerRegistry;
    }

    public ClassLoader getClassLoader() {
        return ((BundleWiring)this.bundle.adapt(BundleWiring.class)).getClassLoader();
    }

    public URL getResource(String path) {
        return this.contextHelper.getResource(path);
    }

    public String getMimeType(String name) {
        String type = this.contextHelper.getMimeType(name);
        if (type != null) {
            return type;
        }
        return MimeTypes.get().getByFile(name);
    }

    public String getRealPath(String path) {
        return this.contextHelper.getRealPath(path);
    }

    public Set<String> getResourcePaths(String path) {
        return this.contextHelper.getResourcePaths(path);
    }

    public String getContextPath() {
        return this.delegatee.getContextPath();
    }

    public ServletContext getContext(String uripath) {
        return this.delegatee.getContext(uripath);
    }

    public int getMajorVersion() {
        return this.delegatee.getMajorVersion();
    }

    public int getMinorVersion() {
        return this.delegatee.getMinorVersion();
    }

    public int getEffectiveMajorVersion() {
        return this.delegatee.getEffectiveMajorVersion();
    }

    public int getEffectiveMinorVersion() {
        return this.delegatee.getEffectiveMinorVersion();
    }

    public InputStream getResourceAsStream(String path) {
        URL res = this.getResource(path);
        if (res != null) {
            try {
                return res.openStream();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return this.delegatee.getRequestDispatcher(path);
    }

    public RequestDispatcher getNamedDispatcher(String name) {
        return this.delegatee.getNamedDispatcher(name);
    }

    public Servlet getServlet(String name) throws ServletException {
        return this.delegatee.getServlet(name);
    }

    public Enumeration<Servlet> getServlets() {
        return this.delegatee.getServlets();
    }

    public Enumeration<String> getServletNames() {
        return this.delegatee.getServletNames();
    }

    public void log(String msg) {
        this.delegatee.log(msg);
    }

    public void log(Exception exception, String msg) {
        this.delegatee.log(exception, msg);
    }

    public void log(String message, Throwable throwable) {
        this.delegatee.log(message, throwable);
    }

    public String getServerInfo() {
        return this.delegatee.getServerInfo();
    }

    public String getInitParameter(String name) {
        return this.delegatee.getInitParameter(name);
    }

    public Enumeration<String> getInitParameterNames() {
        return this.delegatee.getInitParameterNames();
    }

    public boolean setInitParameter(String name, String value) {
        return this.delegatee.setInitParameter(name, value);
    }

    public Object getAttribute(String name) {
        return this.delegatee.getAttribute(name);
    }

    public Enumeration<String> getAttributeNames() {
        return this.delegatee.getAttributeNames();
    }

    public void setAttribute(String name, Object object) {
        this.delegatee.setAttribute(name, object);
    }

    public void removeAttribute(String name) {
        this.delegatee.removeAttribute(name);
    }

    public String getServletContextName() {
        return this.delegatee.getServletContextName();
    }

    public ServletRegistration.Dynamic addServlet(String servletName, String className) {
        return this.delegatee.addServlet(servletName, className);
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Servlet servlet) {
        return this.delegatee.addServlet(servletName, servlet);
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Class<? extends Servlet> servletClass) {
        return this.delegatee.addServlet(servletName, servletClass);
    }

    public <T extends Servlet> T createServlet(Class<T> clazz) throws ServletException {
        return (T)this.delegatee.createServlet(clazz);
    }

    public ServletRegistration getServletRegistration(String servletName) {
        return this.delegatee.getServletRegistration(servletName);
    }

    public Map<String, ? extends ServletRegistration> getServletRegistrations() {
        return this.delegatee.getServletRegistrations();
    }

    public FilterRegistration.Dynamic addFilter(String filterName, String className) {
        return this.delegatee.addFilter(filterName, className);
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Filter filter) {
        return this.delegatee.addFilter(filterName, filter);
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Class<? extends Filter> filterClass) {
        return this.delegatee.addFilter(filterName, filterClass);
    }

    public <T extends Filter> T createFilter(Class<T> clazz) throws ServletException {
        return (T)this.delegatee.createFilter(clazz);
    }

    public FilterRegistration getFilterRegistration(String filterName) {
        return this.delegatee.getFilterRegistration(filterName);
    }

    public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
        return this.delegatee.getFilterRegistrations();
    }

    public SessionCookieConfig getSessionCookieConfig() {
        return this.delegatee.getSessionCookieConfig();
    }

    public void setSessionTrackingModes(Set<SessionTrackingMode> sessionTrackingModes) {
        this.delegatee.setSessionTrackingModes(sessionTrackingModes);
    }

    public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
        return this.delegatee.getDefaultSessionTrackingModes();
    }

    public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
        return this.delegatee.getEffectiveSessionTrackingModes();
    }

    public void addListener(String className) {
        this.delegatee.addListener(className);
    }

    public <T extends EventListener> void addListener(T t) {
        this.delegatee.addListener(t);
    }

    public void addListener(Class<? extends EventListener> listenerClass) {
        this.delegatee.addListener(listenerClass);
    }

    public <T extends EventListener> T createListener(Class<T> clazz) throws ServletException {
        return (T)this.delegatee.createListener(clazz);
    }

    public JspConfigDescriptor getJspConfigDescriptor() {
        return this.delegatee.getJspConfigDescriptor();
    }

    public void declareRoles(String ... roleNames) {
        this.delegatee.declareRoles(roleNames);
    }

    public String getVirtualServerName() {
        return this.delegatee.getVirtualServerName();
    }
}

