/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.jetty.internal;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.felix.http.base.internal.logger.SystemLogger;
import org.apache.felix.http.jetty.internal.JettyServiceStarter;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;

public class JettyManagedServiceFactory
implements ManagedServiceFactory {
    private final Map<String, JettyServiceStarter> services = new HashMap<String, JettyServiceStarter>();
    private final BundleContext context;

    JettyManagedServiceFactory(BundleContext context) {
        this.context = context;
    }

    public synchronized void stop() {
        HashSet<String> pids = new HashSet<String>(this.services.keySet());
        for (String pid : pids) {
            this.deleted(pid);
        }
    }

    public String getName() {
        return "Apache Felix Http Jetty";
    }

    public synchronized void updated(String pid, Dictionary<String, ?> properties) throws ConfigurationException {
        JettyServiceStarter jetty = this.services.get(pid);
        try {
            if (jetty == null) {
                jetty = new JettyServiceStarter(this.context, properties);
                this.services.put(pid, jetty);
            } else {
                jetty.updated(properties);
            }
        }
        catch (Exception e) {
            SystemLogger.error("Failed to start Http Jetty pid=" + pid, e);
        }
    }

    public synchronized void deleted(String pid) {
        JettyServiceStarter jetty = this.services.remove(pid);
        if (jetty != null) {
            try {
                jetty.stop();
            }
            catch (Exception e) {
                SystemLogger.error("Faiiled to stop Http Jetty pid=" + pid, e);
            }
        }
    }
}

