/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.service;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.felix.http.base.internal.context.ExtServletContext;
import org.apache.felix.http.base.internal.handler.FilterHandler;
import org.apache.felix.http.base.internal.handler.HttpServiceServletHandler;
import org.apache.felix.http.base.internal.handler.ServletHandler;
import org.apache.felix.http.base.internal.registry.HandlerRegistry;
import org.apache.felix.http.base.internal.runtime.ServletInfo;
import org.osgi.service.http.NamespaceException;

public final class SharedHttpServiceImpl {
    private final HandlerRegistry handlerRegistry;
    private final Map<String, ServletHandler> aliasMap = new HashMap<String, ServletHandler>();

    public SharedHttpServiceImpl(HandlerRegistry handlerRegistry) {
        if (handlerRegistry == null) {
            throw new IllegalArgumentException("HandlerRegistry cannot be null!");
        }
        this.handlerRegistry = handlerRegistry;
    }

    public boolean registerFilter(@Nonnull FilterHandler handler) {
        this.handlerRegistry.getRegistry(handler.getContextServiceId()).registerFilter(handler);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerServlet(@Nonnull String alias, @Nonnull ExtServletContext httpContext, @Nonnull Servlet servlet, @Nonnull ServletInfo servletInfo) throws ServletException, NamespaceException {
        HttpServiceServletHandler handler = new HttpServiceServletHandler(httpContext, servletInfo, servlet);
        Map<String, ServletHandler> map = this.aliasMap;
        synchronized (map) {
            if (this.aliasMap.containsKey(alias)) {
                throw new NamespaceException("Alias " + alias + " is already in use.");
            }
            this.handlerRegistry.getRegistry(handler.getContextServiceId()).registerServlet(handler);
            this.aliasMap.put(alias, handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Servlet unregister(String alias) {
        Map<String, ServletHandler> map = this.aliasMap;
        synchronized (map) {
            ServletHandler handler = this.aliasMap.remove(alias);
            if (handler == null) {
                throw new IllegalArgumentException("Nothing registered at " + alias);
            }
            Servlet s = handler.getServlet();
            this.handlerRegistry.getRegistry(handler.getContextServiceId()).unregisterServlet(handler.getServletInfo(), true);
            return s;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterServlet(Servlet servlet) {
        if (servlet != null) {
            Map<String, ServletHandler> map = this.aliasMap;
            synchronized (map) {
                Iterator<Map.Entry<String, ServletHandler>> i = this.aliasMap.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry<String, ServletHandler> entry = i.next();
                    if (entry.getValue().getServlet() != servlet) continue;
                    this.handlerRegistry.getRegistry(entry.getValue().getContextServiceId()).unregisterServlet(entry.getValue().getServletInfo(), false);
                    i.remove();
                    break;
                }
            }
        }
    }

    public HandlerRegistry getHandlerRegistry() {
        return this.handlerRegistry;
    }
}

