/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.jetty.internal;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletContext;
import javax.servlet.SessionCookieConfig;
import javax.servlet.SessionTrackingMode;
import org.apache.felix.http.base.internal.HttpServiceController;
import org.apache.felix.http.base.internal.logger.SystemLogger;
import org.apache.felix.http.jetty.internal.ConnectorFactoryTracker;
import org.apache.felix.http.jetty.internal.CustomizerWrapper;
import org.apache.felix.http.jetty.internal.FileRequestLog;
import org.apache.felix.http.jetty.internal.JettyConfig;
import org.apache.felix.http.jetty.internal.JettyManagedService;
import org.apache.felix.http.jetty.internal.LoadBalancerCustomizerFactoryTracker;
import org.apache.felix.http.jetty.internal.LogServiceRequestLog;
import org.apache.felix.http.jetty.internal.MBeanServerTracker;
import org.apache.felix.http.jetty.internal.RequestLogTracker;
import org.apache.felix.http.jetty.internal.WebAppBundleContext;
import org.apache.felix.http.jetty.internal.WebEvent;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.io.ConnectionStatistics;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SessionManager;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.StatisticsHandler;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public final class JettyService
extends AbstractLifeCycle.AbstractLifeCycleListener {
    public static final String PID = "org.apache.felix.http";
    private static final String HEADER_WEB_CONTEXT_PATH = "Web-ContextPath";
    private static final String HEADER_ACTIVATION_POLICY = "Bundle-ActivationPolicy";
    private static final String WEB_SYMBOLIC_NAME = "osgi.web.symbolicname";
    private static final String WEB_VERSION = "osgi.web.version";
    private static final String WEB_CONTEXT_PATH = "osgi.web.contextpath";
    private static final String OSGI_BUNDLE_CONTEXT = "osgi-bundlecontext";
    private final JettyConfig config;
    private final BundleContext context;
    private final HttpServiceController controller;
    private final Map<String, Deployment> deployments;
    private final ExecutorService executor;
    private volatile ServiceRegistration<?> configServiceReg;
    private volatile Server server;
    private volatile ContextHandlerCollection parent;
    private volatile MBeanServerTracker mbeanServerTracker;
    private volatile BundleTracker<Deployment> bundleTracker;
    private volatile ServiceTracker<EventAdmin, EventAdmin> eventAdmintTracker;
    private volatile ConnectorFactoryTracker connectorTracker;
    private volatile RequestLogTracker requestLogTracker;
    private volatile LogServiceRequestLog osgiRequestLog;
    private volatile FileRequestLog fileRequestLog;
    private volatile LoadBalancerCustomizerFactoryTracker loadBalancerCustomizerTracker;
    private volatile CustomizerWrapper customizerWrapper;
    private volatile EventAdmin eventAdmin;
    private boolean registerManagedService = true;

    public JettyService(BundleContext context, HttpServiceController controller) {
        this.context = context;
        this.config = new JettyConfig(this.context);
        this.controller = controller;
        this.deployments = new LinkedHashMap<String, Deployment>();
        this.executor = Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread t = new Thread(runnable);
                t.setName("Jetty HTTP Service");
                return t;
            }
        });
    }

    public JettyService(BundleContext context, HttpServiceController controller, Dictionary<String, ?> props) {
        this(context, controller);
        this.config.update(props);
        this.registerManagedService = false;
    }

    public void start() throws Exception {
        this.startJetty();
        if (this.registerManagedService) {
            Hashtable<String, String> props = new Hashtable<String, String>();
            ((Dictionary)props).put("service.pid", PID);
            this.configServiceReg = this.context.registerService("org.osgi.service.cm.ManagedService", (Object)new JettyManagedService(this), props);
        }
        this.eventAdmintTracker = new ServiceTracker(this.context, EventAdmin.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<EventAdmin, EventAdmin>(){

            public EventAdmin addingService(ServiceReference<EventAdmin> reference) {
                EventAdmin service = (EventAdmin)JettyService.this.context.getService(reference);
                this.modifiedService(reference, service);
                return service;
            }

            public void modifiedService(ServiceReference<EventAdmin> reference, EventAdmin service) {
                JettyService.this.eventAdmin = service;
            }

            public void removedService(ServiceReference<EventAdmin> reference, EventAdmin service) {
                JettyService.this.context.ungetService(reference);
                JettyService.this.eventAdmin = null;
            }
        });
        this.eventAdmintTracker.open();
        this.bundleTracker = new BundleTracker(this.context, 40, (BundleTrackerCustomizer)new BundleTrackerCustomizer<Deployment>(){

            public Deployment addingBundle(Bundle bundle, BundleEvent event) {
                return this.detectWebAppBundle(bundle);
            }

            public void modifiedBundle(Bundle bundle, BundleEvent event, Deployment object) {
                this.detectWebAppBundle(bundle);
            }

            private Deployment detectWebAppBundle(Bundle bundle) {
                String contextPath;
                if ((bundle.getState() == 32 || bundle.getState() == 8 && "Lazy".equals(bundle.getHeaders().get(JettyService.HEADER_ACTIVATION_POLICY))) && (contextPath = (String)bundle.getHeaders().get(JettyService.HEADER_WEB_CONTEXT_PATH)) != null) {
                    return JettyService.this.startWebAppBundle(bundle, contextPath);
                }
                return null;
            }

            public void removedBundle(Bundle bundle, BundleEvent event, Deployment object) {
                String contextPath = (String)bundle.getHeaders().get(JettyService.HEADER_WEB_CONTEXT_PATH);
                if (contextPath == null) {
                    return;
                }
                Deployment deployment = (Deployment)JettyService.this.deployments.remove(contextPath);
                if (deployment != null && deployment.getContext() != null) {
                    deployment.setRegistration(null);
                    JettyService.this.undeploy(deployment, deployment.getContext());
                }
            }
        });
        this.bundleTracker.open();
    }

    public void stop() throws Exception {
        if (this.configServiceReg != null) {
            this.configServiceReg.unregister();
            this.configServiceReg = null;
        }
        if (this.bundleTracker != null) {
            this.bundleTracker.close();
            this.bundleTracker = null;
        }
        if (this.eventAdmintTracker != null) {
            this.eventAdmintTracker.close();
            this.eventAdmintTracker = null;
        }
        this.stopJetty();
        if (this.isExecutorServiceAvailable()) {
            this.executor.shutdown();
            this.executor.awaitTermination(5L, TimeUnit.SECONDS);
        }
    }

    private Hashtable<String, Object> getServiceProperties() {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        this.config.setServiceProperties(props);
        this.addEndpointProperties(props, null);
        return props;
    }

    public void updated(Dictionary<String, ?> props) {
        if (this.config.update(props)) {
            this.stopJetty();
            this.startJetty();
        }
    }

    private void startJetty() {
        try {
            this.initializeJetty();
        }
        catch (Exception e) {
            SystemLogger.error("Exception while initializing Jetty.", e);
        }
    }

    private void stopJetty() {
        if (this.server != null) {
            this.controller.getEventDispatcher().setActive(false);
            this.controller.unregister();
            if (this.fileRequestLog != null) {
                this.fileRequestLog.stop();
                this.fileRequestLog = null;
            }
            if (this.osgiRequestLog != null) {
                this.osgiRequestLog.unregister();
                this.osgiRequestLog = null;
            }
            if (this.requestLogTracker != null) {
                this.requestLogTracker.close();
                this.requestLogTracker = null;
            }
            if (this.connectorTracker != null) {
                this.connectorTracker.close();
                this.connectorTracker = null;
            }
            if (this.loadBalancerCustomizerTracker != null) {
                this.loadBalancerCustomizerTracker.close();
                this.loadBalancerCustomizerTracker = null;
            }
            try {
                this.server.stop();
                this.server = null;
                SystemLogger.info("Stopped Jetty.");
            }
            catch (Exception e) {
                SystemLogger.error("Exception while stopping Jetty.", e);
            }
            if (this.mbeanServerTracker != null) {
                this.mbeanServerTracker.close();
                this.mbeanServerTracker = null;
            }
        }
    }

    private void initializeJetty() throws Exception {
        if (this.config.isUseHttp() || this.config.isUseHttps()) {
            String version = this.fixJettyVersion();
            int threadPoolMax = this.config.getThreadPoolMax();
            this.server = threadPoolMax >= 0 ? new Server(new QueuedThreadPool(threadPoolMax)) : new Server();
            this.server.addLifeCycleListener(this);
            this.server.addBean(new HashLoginService("OSGi HTTP Service Realm"));
            this.parent = new ContextHandlerCollection();
            ServletContextHandler context = new ServletContextHandler(this.parent, this.config.getContextPath(), 1);
            this.configureSessionManager(context);
            this.controller.getEventDispatcher().setActive(true);
            context.addEventListener((EventListener)((Object)this.controller.getEventDispatcher()));
            context.getSessionHandler().addEventListener((EventListener)((Object)this.controller.getEventDispatcher()));
            ServletHolder holder = new ServletHolder(this.controller.createDispatcherServlet());
            holder.setAsyncSupported(true);
            context.addServlet(holder, "/*");
            context.setMaxFormContentSize(this.config.getMaxFormSize());
            if (this.config.isRegisterMBeans()) {
                this.mbeanServerTracker = new MBeanServerTracker(this.context, this.server);
                this.mbeanServerTracker.open();
                context.addBean(new StatisticsHandler());
            }
            this.server.setHandler(this.parent);
            this.server.start();
            if (this.config.isProxyLoadBalancerConnection()) {
                this.customizerWrapper = new CustomizerWrapper();
                this.loadBalancerCustomizerTracker = new LoadBalancerCustomizerFactoryTracker(this.context, this.customizerWrapper);
                this.loadBalancerCustomizerTracker.open();
            }
            StringBuilder message = new StringBuilder("Started Jetty ").append(version).append(" at port(s)");
            if (this.config.isUseHttp() && this.initializeHttp()) {
                message.append(" HTTP:").append(this.config.getHttpPort());
            }
            if (this.config.isUseHttps() && this.initializeHttps()) {
                message.append(" HTTPS:").append(this.config.getHttpsPort());
            }
            this.connectorTracker = new ConnectorFactoryTracker(this.context, this.server);
            this.connectorTracker.open();
            if (this.server.getConnectors() != null && this.server.getConnectors().length > 0) {
                Connector connector;
                message.append(" on context path ").append(this.config.getContextPath());
                message.append(" [");
                ThreadPool threadPool = this.server.getThreadPool();
                if (threadPool instanceof ThreadPool.SizedThreadPool) {
                    ThreadPool.SizedThreadPool sizedThreadPool = (ThreadPool.SizedThreadPool)threadPool;
                    message.append("minThreads=").append(sizedThreadPool.getMinThreads()).append(",");
                    message.append("maxThreads=").append(sizedThreadPool.getMaxThreads()).append(",");
                }
                if ((connector = this.server.getConnectors()[0]) instanceof ServerConnector) {
                    ServerConnector serverConnector = (ServerConnector)connector;
                    message.append("acceptors=").append(serverConnector.getAcceptors()).append(",");
                    message.append("selectors=").append(serverConnector.getSelectorManager().getSelectorCount());
                }
                message.append("]");
                SystemLogger.info(message.toString());
                this.controller.register(context.getServletContext(), this.getServiceProperties());
            } else {
                this.stopJetty();
                SystemLogger.error("Jetty stopped (no connectors available)", null);
            }
            try {
                this.requestLogTracker = new RequestLogTracker(this.context, this.config.getRequestLogFilter());
                this.requestLogTracker.open();
                this.server.setRequestLog(this.requestLogTracker);
            }
            catch (InvalidSyntaxException e) {
                SystemLogger.error("Invalid filter syntax in request log tracker", e);
            }
            if (this.config.isRequestLogOSGiEnabled()) {
                this.osgiRequestLog = new LogServiceRequestLog(this.config);
                this.osgiRequestLog.register(this.context);
                SystemLogger.info("Directing Jetty request logs to the OSGi Log Service");
            }
            if (this.config.getRequestLogFilePath() != null && !this.config.getRequestLogFilePath().isEmpty()) {
                this.fileRequestLog = new FileRequestLog(this.config);
                this.fileRequestLog.start(this.context);
                SystemLogger.info("Directing Jetty request logs to " + this.config.getRequestLogFilePath());
            }
        } else {
            SystemLogger.warning("Jetty not started (HTTP and HTTPS disabled)", null);
        }
    }

    private String fixJettyVersion() {
        Dictionary headers = this.context.getBundle().getHeaders();
        String version = (String)headers.get("X-Jetty-Version");
        if (version != null) {
            System.setProperty("jetty.version", version);
        } else {
            version = Server.getVersion();
        }
        return version;
    }

    private boolean initializeHttp() {
        HttpConnectionFactory connFactory = new HttpConnectionFactory();
        this.configureHttpConnectionFactory(connFactory);
        ServerConnector connector = new ServerConnector(this.server, this.config.getAcceptors(), this.config.getSelectors(), connFactory);
        this.configureConnector(connector, this.config.getHttpPort());
        if (this.config.isProxyLoadBalancerConnection()) {
            connFactory.getHttpConfiguration().addCustomizer(this.customizerWrapper);
        }
        return this.startConnector(connector);
    }

    private boolean initializeHttps() {
        HttpConnectionFactory connFactory = new HttpConnectionFactory();
        this.configureHttpConnectionFactory(connFactory);
        SslContextFactory sslContextFactory = new SslContextFactory();
        this.configureSslContextFactory(sslContextFactory);
        ServerConnector connector = new ServerConnector(this.server, this.config.getAcceptors(), this.config.getSelectors(), new SslConnectionFactory(sslContextFactory, HttpVersion.HTTP_1_1.toString()), connFactory);
        HttpConfiguration httpConfiguration = connFactory.getHttpConfiguration();
        httpConfiguration.addCustomizer(new SecureRequestCustomizer());
        if (this.config.isProxyLoadBalancerConnection()) {
            httpConfiguration.addCustomizer(this.customizerWrapper);
        }
        this.configureConnector(connector, this.config.getHttpsPort());
        return this.startConnector(connector);
    }

    private void configureSslContextFactory(SslContextFactory connector) {
        if (this.config.getKeystoreType() != null) {
            connector.setKeyStoreType(this.config.getKeystoreType());
        }
        if (this.config.getKeystore() != null) {
            connector.setKeyStorePath(this.config.getKeystore());
        }
        if (this.config.getPassword() != null) {
            connector.setKeyStorePassword(this.config.getPassword());
        }
        if (this.config.getKeyPassword() != null) {
            connector.setKeyManagerPassword(this.config.getKeyPassword());
        }
        if (this.config.getTruststoreType() != null) {
            connector.setTrustStoreType(this.config.getTruststoreType());
        }
        if (this.config.getTruststore() != null) {
            connector.setTrustStorePath(this.config.getTruststore());
        }
        if (this.config.getTrustPassword() != null) {
            connector.setTrustStorePassword(this.config.getTrustPassword());
        }
        if ("wants".equalsIgnoreCase(this.config.getClientcert())) {
            connector.setWantClientAuth(true);
        } else if ("needs".equalsIgnoreCase(this.config.getClientcert())) {
            connector.setNeedClientAuth(true);
        }
        if (this.config.getExcludedCipherSuites() != null) {
            connector.setExcludeCipherSuites(this.config.getExcludedCipherSuites());
        }
        if (this.config.getIncludedCipherSuites() != null) {
            connector.setIncludeCipherSuites(this.config.getIncludedCipherSuites());
        }
        if (this.config.getIncludedProtocols() != null) {
            connector.setIncludeProtocols(this.config.getIncludedProtocols());
        }
        if (this.config.getExcludedProtocols() != null) {
            connector.setExcludeProtocols(this.config.getExcludedProtocols());
        }
        connector.setRenegotiationAllowed(this.config.isRenegotiationAllowed());
    }

    private void configureConnector(ServerConnector connector, int port) {
        connector.setPort(port);
        connector.setHost(this.config.getHost());
        connector.setIdleTimeout(this.config.getHttpTimeout());
        if (this.config.isRegisterMBeans()) {
            connector.addBean(new ConnectionStatistics());
        }
    }

    private void configureHttpConnectionFactory(HttpConnectionFactory connFactory) {
        HttpConfiguration config = connFactory.getHttpConfiguration();
        config.setRequestHeaderSize(this.config.getHeaderSize());
        config.setResponseHeaderSize(this.config.getHeaderSize());
        config.setOutputBufferSize(this.config.getResponseBufferSize());
        config.setSendDateHeader(true);
        config.setSendServerVersion(this.config.isSendServerHeader());
        config.setSendXPoweredBy(this.config.isSendServerHeader());
        connFactory.setInputBufferSize(this.config.getRequestBufferSize());
    }

    private void configureSessionManager(ServletContextHandler context) {
        SessionHandler sessionHandler = context.getSessionHandler();
        sessionHandler.getSessionManager().setMaxInactiveInterval(this.config.getSessionTimeout() * 60);
        sessionHandler.getSessionManager().setSessionIdPathParameterName(this.config.getProperty("org.eclipse.jetty.servlet.SessionIdPathParameterName", "jsessionid"));
        sessionHandler.getSessionManager().setCheckingRemoteSessionIdEncoding(this.config.getBooleanProperty("org.eclipse.jetty.servlet.CheckingRemoteSessionIdEncoding", true));
        sessionHandler.getSessionManager().setSessionTrackingModes(Collections.singleton(SessionTrackingMode.COOKIE));
        SessionCookieConfig cookieConfig = sessionHandler.getSessionManager().getSessionCookieConfig();
        cookieConfig.setName(this.config.getProperty("org.eclipse.jetty.servlet.SessionCookie", "JSESSIONID"));
        cookieConfig.setDomain(this.config.getProperty("org.eclipse.jetty.servlet.SessionDomain", SessionManager.__DefaultSessionDomain));
        cookieConfig.setPath(this.config.getProperty("org.eclipse.jetty.servlet.SessionPath", context.getContextPath()));
        cookieConfig.setMaxAge(this.config.getIntProperty("org.eclipse.jetty.servlet.MaxAge", -1));
        cookieConfig.setHttpOnly(this.config.getBooleanProperty("org.apache.felix.https.jetty.session.cookie.httpOnly", true));
        cookieConfig.setSecure(this.config.getBooleanProperty("org.apache.felix.https.jetty.session.cookie.secure", false));
    }

    private boolean startConnector(Connector connector) {
        this.server.addConnector(connector);
        try {
            connector.start();
            return true;
        }
        catch (Exception e) {
            this.server.removeConnector(connector);
            SystemLogger.error("Failed to start Connector: " + connector, e);
            return false;
        }
    }

    private String getEndpoint(Connector listener, InetAddress ia) {
        if (ia.isLoopbackAddress()) {
            return null;
        }
        String address = ia.getHostAddress().trim().toLowerCase();
        if (ia instanceof Inet6Address) {
            if (address.startsWith("fe80:0:0:0:")) {
                return null;
            }
            address = "[" + address + "]";
        } else if (!(ia instanceof Inet4Address)) {
            return null;
        }
        return this.getEndpoint(listener, address);
    }

    private ServerConnector getServerConnector(Connector connector) {
        if (connector instanceof ServerConnector) {
            return (ServerConnector)connector;
        }
        throw new IllegalArgumentException("Connection instance not of type ServerConnector " + connector);
    }

    private String getEndpoint(Connector listener, String hostname) {
        StringBuilder sb = new StringBuilder();
        sb.append("http");
        int defaultPort = 80;
        if (this.getServerConnector(listener).getDefaultProtocol().startsWith("SSL")) {
            sb.append('s');
            defaultPort = 443;
        }
        sb.append("://");
        sb.append(hostname);
        if (this.getServerConnector(listener).getPort() != defaultPort) {
            sb.append(':');
            sb.append(String.valueOf(this.getServerConnector(listener).getPort()));
        }
        sb.append(this.config.getContextPath());
        return sb.toString();
    }

    private List<String> getEndpoints(Connector connector, List<NetworkInterface> interfaces) {
        ArrayList<String> endpoints = new ArrayList<String>();
        for (NetworkInterface ni : interfaces) {
            Enumeration<InetAddress> ias = ni.getInetAddresses();
            while (ias.hasMoreElements()) {
                InetAddress ia = ias.nextElement();
                String endpoint = this.getEndpoint(connector, ia);
                if (endpoint == null) continue;
                endpoints.add(endpoint);
            }
        }
        return endpoints;
    }

    private void addEndpointProperties(Hashtable<String, Object> props, Object container) {
        ArrayList<String> endpoints = new ArrayList<String>();
        Connector[] connectors = this.server.getConnectors();
        if (connectors != null) {
            for (int i = 0; i < connectors.length; ++i) {
                Connector connector = connectors[i];
                if (this.getServerConnector(connector).getHost() == null) {
                    try {
                        ArrayList<NetworkInterface> interfaces = new ArrayList<NetworkInterface>();
                        ArrayList<NetworkInterface> loopBackInterfaces = new ArrayList<NetworkInterface>();
                        Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
                        while (nis.hasMoreElements()) {
                            NetworkInterface ni = nis.nextElement();
                            if (ni.isLoopback()) {
                                loopBackInterfaces.add(ni);
                                continue;
                            }
                            interfaces.add(ni);
                        }
                        if (!interfaces.isEmpty()) {
                            endpoints.addAll(this.getEndpoints(connector, interfaces));
                            continue;
                        }
                        endpoints.addAll(this.getEndpoints(connector, loopBackInterfaces));
                    }
                    catch (SocketException interfaces) {}
                    continue;
                }
                String endpoint = this.getEndpoint(connector, this.getServerConnector(connector).getHost());
                if (endpoint == null) continue;
                endpoints.add(endpoint);
            }
        }
        props.put("osgi.http.endpoint", endpoints.toArray(new String[endpoints.size()]));
    }

    private Deployment startWebAppBundle(Bundle bundle, String contextPath) {
        this.postEvent(WebEvent.DEPLOYING(bundle, this.context.getBundle()));
        Deployment deployment = this.deployments.get(contextPath);
        if (deployment != null) {
            SystemLogger.warning(String.format("Web application bundle %s has context path %s which is already registered", bundle.getSymbolicName(), contextPath), null);
            this.postEvent(WebEvent.FAILED(bundle, this.context.getBundle(), null, contextPath, deployment.getBundle().getBundleId()));
            return null;
        }
        if (contextPath.equals("/")) {
            SystemLogger.warning(String.format("Web application bundle %s has context path %s which is reserved", bundle.getSymbolicName(), contextPath), null);
            this.postEvent(WebEvent.FAILED(bundle, this.context.getBundle(), null, contextPath, this.context.getBundle().getBundleId()));
            return null;
        }
        for (String path : this.config.getPathExclusions()) {
            if (!contextPath.startsWith(path)) continue;
            SystemLogger.warning(String.format("Web application bundle %s has context path %s which clashes with excluded path prefix %s", bundle.getSymbolicName(), contextPath, path), null);
            this.postEvent(WebEvent.FAILED(bundle, this.context.getBundle(), null, path, null));
            return null;
        }
        deployment = new Deployment(contextPath, bundle);
        this.deployments.put(contextPath, deployment);
        WebAppBundleContext context = new WebAppBundleContext(contextPath, bundle, this.getClass().getClassLoader());
        this.deploy(deployment, context);
        return deployment;
    }

    public void deploy(final Deployment deployment, final WebAppBundleContext context) {
        if (!this.isExecutorServiceAvailable()) {
            return;
        }
        this.executor.submit(new JettyOperation(){

            @Override
            protected void doExecute() {
                Bundle webAppBundle = deployment.getBundle();
                Bundle extenderBundle = JettyService.this.context.getBundle();
                try {
                    context.getServletContext().setAttribute(JettyService.OSGI_BUNDLE_CONTEXT, webAppBundle.getBundleContext());
                    JettyService.this.parent.addHandler(context);
                    context.start();
                    Hashtable<String, String> props = new Hashtable<String, String>();
                    ((Dictionary)props).put(JettyService.WEB_SYMBOLIC_NAME, webAppBundle.getSymbolicName());
                    ((Dictionary)props).put(JettyService.WEB_VERSION, (String)webAppBundle.getVersion());
                    ((Dictionary)props).put(JettyService.WEB_CONTEXT_PATH, deployment.getContextPath());
                    deployment.setRegistration((ServiceRegistration<ServletContext>)webAppBundle.getBundleContext().registerService(ServletContext.class, (Object)context.getServletContext(), props));
                    JettyService.this.postEvent(WebEvent.DEPLOYED(webAppBundle, extenderBundle));
                }
                catch (Exception e) {
                    SystemLogger.error(String.format("Deploying web application bundle %s failed.", webAppBundle.getSymbolicName()), e);
                    JettyService.this.postEvent(WebEvent.FAILED(webAppBundle, extenderBundle, e, null, null));
                    deployment.setContext(null);
                }
            }
        });
        deployment.setContext(context);
    }

    public void undeploy(final Deployment deployment, final WebAppBundleContext context) {
        if (!this.isExecutorServiceAvailable()) {
            return;
        }
        this.executor.submit(new JettyOperation(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void doExecute() {
                Bundle webAppBundle = deployment.getBundle();
                Bundle extenderBundle = JettyService.this.context.getBundle();
                try {
                    JettyService.this.postEvent(WebEvent.UNDEPLOYING(webAppBundle, extenderBundle));
                    context.getServletContext().removeAttribute(JettyService.OSGI_BUNDLE_CONTEXT);
                    ServiceRegistration<ServletContext> registration = deployment.getRegistration();
                    if (registration != null) {
                        registration.unregister();
                    }
                    deployment.setRegistration(null);
                    deployment.setContext(null);
                    context.stop();
                }
                catch (Exception e) {
                    SystemLogger.error(String.format("Undeploying web application bundle %s failed.", webAppBundle.getSymbolicName()), e);
                }
                finally {
                    JettyService.this.postEvent(WebEvent.UNDEPLOYED(webAppBundle, extenderBundle));
                }
            }
        });
    }

    private void postEvent(Event event) {
        if (this.eventAdmin != null) {
            this.eventAdmin.postEvent(event);
        }
    }

    @Override
    public void lifeCycleStarted(LifeCycle event) {
        for (Deployment deployment : this.deployments.values()) {
            if (deployment.getContext() != null) continue;
            this.postEvent(WebEvent.DEPLOYING(deployment.getBundle(), this.context.getBundle()));
            WebAppBundleContext context = new WebAppBundleContext(deployment.getContextPath(), deployment.getBundle(), this.getClass().getClassLoader());
            this.deploy(deployment, context);
        }
    }

    @Override
    public void lifeCycleStopping(LifeCycle event) {
        for (Deployment deployment : this.deployments.values()) {
            if (deployment.getContext() == null) continue;
            this.undeploy(deployment, deployment.getContext());
        }
    }

    private boolean isExecutorServiceAvailable() {
        return this.executor != null && !this.executor.isShutdown();
    }

    static abstract class JettyOperation
    implements Callable<Void> {
        JettyOperation() {
        }

        @Override
        public Void call() throws Exception {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                this.doExecute();
                Void void_ = null;
                return void_;
            }
            finally {
                Thread.currentThread().setContextClassLoader(cl);
            }
        }

        protected abstract void doExecute() throws Exception;
    }

    static class Deployment {
        private String contextPath;
        private Bundle bundle;
        private WebAppBundleContext context;
        private ServiceRegistration<ServletContext> registration;

        public Deployment(String contextPath, Bundle bundle) {
            this.contextPath = contextPath;
            this.bundle = bundle;
        }

        public Bundle getBundle() {
            return this.bundle;
        }

        public String getContextPath() {
            return this.contextPath;
        }

        public WebAppBundleContext getContext() {
            return this.context;
        }

        public void setContext(WebAppBundleContext context) {
            this.context = context;
        }

        public ServiceRegistration<ServletContext> getRegistration() {
            return this.registration;
        }

        public void setRegistration(ServiceRegistration<ServletContext> registration) {
            this.registration = registration;
        }
    }
}

