/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.jetty.internal;

import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.felix.http.jetty.LoadBalancerCustomizerFactory;
import org.apache.felix.http.jetty.internal.CustomizerWrapper;
import org.eclipse.jetty.server.HttpConfiguration;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class LoadBalancerCustomizerFactoryTracker
extends ServiceTracker<LoadBalancerCustomizerFactory, ServiceReference<LoadBalancerCustomizerFactory>> {
    private final CustomizerWrapper customizerWrapper;
    private final BundleContext bundleContext;
    private final SortedSet<ServiceReference<LoadBalancerCustomizerFactory>> set = new TreeSet<ServiceReference<LoadBalancerCustomizerFactory>>();

    public LoadBalancerCustomizerFactoryTracker(BundleContext context, CustomizerWrapper customizerWrapper) {
        super(context, LoadBalancerCustomizerFactory.class.getName(), null);
        this.bundleContext = context;
        this.customizerWrapper = customizerWrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceReference<LoadBalancerCustomizerFactory> addingService(ServiceReference<LoadBalancerCustomizerFactory> reference) {
        LoadBalancerCustomizerFactory factory;
        ServiceReference<LoadBalancerCustomizerFactory> highestReference;
        super.addingService(reference);
        SortedSet<ServiceReference<LoadBalancerCustomizerFactory>> sortedSet = this.set;
        synchronized (sortedSet) {
            this.set.add(reference);
            highestReference = this.set.last();
        }
        boolean updated = false;
        if (highestReference != null && (factory = (LoadBalancerCustomizerFactory)this.bundleContext.getService(highestReference)) != null) {
            HttpConfiguration.Customizer customizer = factory.createCustomizer();
            this.customizerWrapper.setCustomizer(customizer);
            updated = true;
        }
        if (!updated) {
            this.customizerWrapper.setCustomizer(null);
        }
        return reference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removedService(ServiceReference<LoadBalancerCustomizerFactory> reference, ServiceReference<LoadBalancerCustomizerFactory> service) {
        LoadBalancerCustomizerFactory factory;
        ServiceReference<LoadBalancerCustomizerFactory> highestReference;
        super.removedService(reference, service);
        SortedSet<ServiceReference<LoadBalancerCustomizerFactory>> sortedSet = this.set;
        synchronized (sortedSet) {
            this.set.remove(reference);
            highestReference = this.set.last();
        }
        boolean updated = false;
        if (highestReference != null && (factory = (LoadBalancerCustomizerFactory)this.bundleContext.getService(highestReference)) != null) {
            HttpConfiguration.Customizer customizer = factory.createCustomizer();
            this.customizerWrapper.setCustomizer(customizer);
            updated = true;
        }
        if (!updated) {
            this.customizerWrapper.setCustomizer(null);
        }
    }
}

