/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.handler;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.ServletException;
import org.apache.felix.http.base.internal.context.ExtServletContext;

public abstract class AbstractHandler {
    private static final AtomicInteger ID = new AtomicInteger();
    private final int id;
    private final String baseName;
    private final ExtServletContext context;
    private final Map<String, String> initParams;

    public AbstractHandler(ExtServletContext context, String baseName) {
        this.context = context;
        this.baseName = baseName;
        this.id = ID.incrementAndGet();
        this.initParams = new HashMap<String, String>();
    }

    public abstract void destroy();

    public final Map<String, String> getInitParams() {
        return this.initParams;
    }

    public final String getName() {
        String name = this.baseName;
        if (name == null) {
            name = String.format("%s_%d", this.getSubject().getClass(), this.id);
        }
        return name;
    }

    public abstract void init() throws ServletException;

    public final void setInitParams(Dictionary map) {
        this.initParams.clear();
        if (map == null) {
            return;
        }
        Enumeration e = map.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            Object value = map.get(key);
            if (!(key instanceof String) || !(value instanceof String)) continue;
            this.initParams.put((String)key, (String)value);
        }
    }

    protected final ExtServletContext getContext() {
        return this.context;
    }

    protected final int getId() {
        return this.id;
    }

    protected abstract Object getSubject();
}

