/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.jetty.internal;

import java.util.Dictionary;
import java.util.Properties;
import org.apache.felix.http.base.internal.DispatcherServlet;
import org.apache.felix.http.base.internal.logger.SystemLogger;
import org.apache.felix.http.jetty.internal.JettyConfig;
import org.apache.felix.http.jetty.internal.JettyLogger;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.mortbay.jetty.security.HashUserRealm;
import org.mortbay.jetty.security.SslSelectChannelConnector;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.ServletHolder;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;

public final class JettyService
implements ManagedService,
Runnable {
    private static final String PID = "org.apache.felix.http";
    private final JettyConfig config;
    private final BundleContext context;
    private boolean running;
    private Thread thread;
    private ServiceRegistration configServiceReg;
    private Server server;
    private DispatcherServlet dispatcher;

    public JettyService(BundleContext context, DispatcherServlet dispatcher) {
        this.context = context;
        this.config = new JettyConfig(this.context);
        this.dispatcher = dispatcher;
    }

    public void start() throws Exception {
        JettyLogger.init();
        Properties props = new Properties();
        props.put("service.pid", PID);
        this.configServiceReg = this.context.registerService(ManagedService.class.getName(), (Object)this, (Dictionary)props);
        this.thread = new Thread((Runnable)this, "Jetty HTTP Service");
        this.thread.start();
    }

    public void stop() throws Exception {
        if (this.configServiceReg != null) {
            this.configServiceReg.unregister();
        }
        this.running = false;
        this.thread.interrupt();
        try {
            this.thread.join(3000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void updated(Dictionary props) throws ConfigurationException {
        this.config.update(props);
        if (this.running && this.thread != null) {
            this.thread.interrupt();
        }
    }

    private void startJetty() {
        try {
            this.initializeJetty();
        }
        catch (Exception e) {
            SystemLogger.error("Exception while initializing Jetty.", e);
        }
    }

    private void stopJetty() {
        try {
            this.server.stop();
        }
        catch (Exception e) {
            SystemLogger.error("Exception while stopping Jetty.", e);
        }
    }

    private void initializeJetty() throws Exception {
        HashUserRealm realm = new HashUserRealm("OSGi HTTP Service Realm");
        this.server = new Server();
        this.server.addUserRealm(realm);
        if (this.config.isUseHttp()) {
            this.initializeHttp();
        }
        if (this.config.isUseHttps()) {
            this.initializeHttps();
        }
        Context context = new Context(this.server, "/", 1);
        context.addServlet(new ServletHolder(this.dispatcher), "/*");
        this.server.start();
        SystemLogger.info("Started jetty " + Server.getVersion() + " at port " + this.config.getHttpPort());
    }

    private void initializeHttp() throws Exception {
        SelectChannelConnector connector = new SelectChannelConnector();
        connector.setPort(this.config.getHttpPort());
        connector.setMaxIdleTime(60000);
        this.server.addConnector(connector);
    }

    private void initializeHttps() throws Exception {
        SslSelectChannelConnector connector = new SslSelectChannelConnector();
        connector.setPort(this.config.getHttpsPort());
        connector.setMaxIdleTime(60000);
        if (this.config.getKeystore() != null) {
            connector.setKeystore(this.config.getKeystore());
        }
        if (this.config.getPassword() != null) {
            System.setProperty("jetty.ssl.password", this.config.getPassword());
            connector.setPassword(this.config.getPassword());
        }
        if (this.config.getKeyPassword() != null) {
            System.setProperty("jetty.ssl.keypassword", this.config.getKeyPassword());
            connector.setKeyPassword(this.config.getKeyPassword());
        }
        if (this.config.getTruststore() != null) {
            connector.setTruststore(this.config.getTruststore());
        }
        if (this.config.getTrustPassword() != null) {
            connector.setTrustPassword(this.config.getTrustPassword());
        }
        if ("wants".equals(this.config.getClientcert())) {
            connector.setWantClientAuth(true);
        } else if ("needs".equals(this.config.getClientcert())) {
            connector.setNeedClientAuth(true);
        }
        this.server.addConnector(connector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.running = true;
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        while (this.running) {
            this.startJetty();
            JettyService jettyService = this;
            synchronized (jettyService) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.stopJetty();
        }
    }
}

