/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.service;

import java.util.Dictionary;
import java.util.HashSet;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.felix.http.api.ExtHttpService;
import org.apache.felix.http.base.internal.context.ExtServletContext;
import org.apache.felix.http.base.internal.context.ServletContextManager;
import org.apache.felix.http.base.internal.handler.FilterHandler;
import org.apache.felix.http.base.internal.handler.HandlerRegistry;
import org.apache.felix.http.base.internal.handler.ServletHandler;
import org.apache.felix.http.base.internal.logger.SystemLogger;
import org.apache.felix.http.base.internal.service.DefaultHttpContext;
import org.apache.felix.http.base.internal.service.ResourceServlet;
import org.osgi.framework.Bundle;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.NamespaceException;

public final class HttpServiceImpl
implements ExtHttpService {
    private final Bundle bundle;
    private final HandlerRegistry handlerRegistry;
    private final HashSet<Servlet> localServlets;
    private final HashSet<Filter> localFilters;
    private final ServletContextManager contextManager;

    public HttpServiceImpl(Bundle bundle, ServletContext context, HandlerRegistry handlerRegistry) {
        this.bundle = bundle;
        this.handlerRegistry = handlerRegistry;
        this.localServlets = new HashSet();
        this.localFilters = new HashSet();
        this.contextManager = new ServletContextManager(this.bundle, context);
    }

    private ExtServletContext getServletContext(HttpContext context) {
        if (context == null) {
            context = this.createDefaultHttpContext();
        }
        return this.contextManager.getServletContext(context);
    }

    public void registerFilter(Filter filter, String pattern, Dictionary initParams, int ranking, HttpContext context) throws ServletException {
        FilterHandler handler = new FilterHandler(this.getServletContext(context), filter, pattern, ranking);
        handler.setInitParams(initParams);
        this.handlerRegistry.addFilter(handler);
        this.localFilters.add(filter);
    }

    public void unregisterFilter(Filter filter) {
        if (filter != null) {
            this.handlerRegistry.removeFilter(filter);
            this.localFilters.remove(filter);
        }
    }

    public void unregisterServlet(Servlet servlet) {
        if (servlet != null) {
            this.handlerRegistry.removeServlet(servlet);
            this.localServlets.remove(servlet);
        }
    }

    public void registerServlet(String alias, Servlet servlet, Dictionary initParams, HttpContext context) throws ServletException, NamespaceException {
        if (!this.isAliasValid(alias)) {
            throw new IllegalArgumentException("Malformed servlet alias [" + alias + "]");
        }
        ServletHandler handler = new ServletHandler(this.getServletContext(context), servlet, alias);
        handler.setInitParams(initParams);
        this.handlerRegistry.addServlet(handler);
        this.localServlets.add(servlet);
    }

    public void registerResources(String alias, String name, HttpContext context) throws NamespaceException {
        if (!this.isNameValid(name)) {
            throw new IllegalArgumentException("Malformed resource name [" + name + "]");
        }
        try {
            ResourceServlet servlet = new ResourceServlet(name);
            this.registerServlet(alias, servlet, null, context);
        }
        catch (ServletException e) {
            SystemLogger.error("Failed to register resources", e);
        }
    }

    public void unregister(String alias) {
        this.unregisterServlet(this.handlerRegistry.getServletByAlias(alias));
    }

    public HttpContext createDefaultHttpContext() {
        return new DefaultHttpContext(this.bundle);
    }

    public void unregisterAll() {
        HashSet<Servlet> servlets = new HashSet<Servlet>(this.localServlets);
        for (Servlet servlet : servlets) {
            this.unregisterServlet(servlet);
        }
        HashSet<Filter> filters = new HashSet<Filter>(this.localFilters);
        for (Filter fiter : filters) {
            this.unregisterFilter(fiter);
        }
    }

    private boolean isNameValid(String name) {
        if (name == null) {
            return false;
        }
        return !name.endsWith("/");
    }

    private boolean isAliasValid(String alias) {
        if (alias == null) {
            return false;
        }
        return alias.equals("/") || alias.startsWith("/") && !alias.endsWith("/");
    }
}

