/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import java.io.IOException;
import java.net.URL;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.http.jetty.Activator;
import org.mortbay.component.AbstractLifeCycle;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.jetty.servlet.ServletMapping;
import org.mortbay.util.LazyList;

public class OsgiServletHandler
extends ServletHandler {
    public void addOsgiServletHolder(String pathSpec, ServletHolder holder) {
        super.addServletWithMapping(holder, pathSpec);
    }

    public ServletHolder removeOsgiServletHolder(String pathSpec) {
        ServletMapping oldMapping = null;
        Object[] mappings = this.getServletMappings();
        for (int i = 0; i < mappings.length && oldMapping == null; ++i) {
            String[] pathSpecs = mappings[i].getPathSpecs();
            for (int j = 0; j < pathSpecs.length && oldMapping == null; ++j) {
                if (!pathSpec.equals(pathSpecs[j])) continue;
                oldMapping = mappings[i];
            }
        }
        if (oldMapping == null) {
            return null;
        }
        Object[] holders = this.getServlets();
        if (holders != null) {
            holders = (ServletHolder[])holders.clone();
        }
        Object oldHolder = null;
        for (int i = 0; i < holders.length; ++i) {
            if (!oldMapping.getServletName().equals(holders[i].getName())) continue;
            oldHolder = holders[i];
        }
        if (oldHolder == null) {
            return null;
        }
        try {
            this.setServlets((ServletHolder[])LazyList.removeFromArray(holders, oldHolder));
            this.setServletMappings((ServletMapping[])LazyList.removeFromArray(mappings, oldMapping));
            if (((AbstractLifeCycle)oldHolder).isStarted() && this.isStopped()) {
                ((AbstractLifeCycle)oldHolder).stop();
            }
            return oldHolder;
        }
        catch (Exception e) {
            this.setServlets((ServletHolder[])holders);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public URL getResource(String uriInContext) {
        Activator.debug("OSGI ServletHandler getResource:" + uriInContext);
        return null;
    }

    public void handle(String target, HttpServletRequest request, HttpServletResponse response, int type) throws IOException, ServletException {
        Activator.debug("dispatch path = " + target);
        super.handle(target, request, response, type);
    }
}

