/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.jetty;

import java.util.Dictionary;
import java.util.Properties;
import org.apache.felix.http.jetty.HttpServiceImpl;
import org.apache.felix.http.jetty.LogServiceLog;
import org.mortbay.component.LifeCycle;
import org.mortbay.jetty.AbstractConnector;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.bio.SocketConnector;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.mortbay.jetty.security.HashUserRealm;
import org.mortbay.jetty.security.SslSocketConnector;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.OsgiServletHandler;
import org.mortbay.jetty.servlet.SessionHandler;
import org.mortbay.log.Log;
import org.mortbay.log.StdErrLog;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator,
ManagedService,
Runnable {
    private static final Properties EMPTY_PROPS = new Properties();
    public static final boolean DEFAULT_HTTP_ENABLE = true;
    public static final boolean DEFAULT_HTTPS_ENABLE = false;
    public static final boolean DEFAULT_USE_NIO = true;
    public static final int DEFAULT_HTTPS_PORT = 443;
    public static final int DEFAULT_HTTP_PORT = 80;
    public static final String DEFAULT_SSL_PROVIDER = "org.mortbay.http.SunJsseListener";
    public static final String DEFAULT_HTTPS_CLIENT_CERT = "none";
    public static final String FELIX_SSL_PROVIDER = "org.apache.felix.https.provider";
    public static final String OSCAR_SSL_PROVIDER = "org.ungoverned.osgi.bundle.https.provider";
    public static final String FELIX_KEYSTORE_KEY_PASSWORD = "org.apache.felix.https.keystore.key.password";
    public static final String OSCAR_KEYSTORE_KEY_PASSWORD = "org.ungoverned.osgi.bundle.https.key.password";
    public static final String FELIX_KEYSTORE = "org.apache.felix.https.keystore";
    public static final String OSCAR_KEYSTORE = "org.ungoverned.osgi.bundle.https.keystore";
    public static final String FELIX_KEYSTORE_PASSWORD = "org.apache.felix.https.keystore.password";
    public static final String OSCAR_KEYSTORE_PASSWORD = "org.ungoverned.osgi.bundle.https.password";
    public static final String HTTP_PORT = "org.osgi.service.http.port";
    public static final String HTTPS_PORT = "org.osgi.service.http.port.secure";
    public static final String FELIX_HTTP_DEBUG = "org.apache.felix.http.debug";
    public static final String HTTP_DEBUG = "org.apache.felix.http.jetty.debug";
    public static final String HTTP_SVCPROP_PORT = "org.apache.felix.http.svcprop.port";
    public static final String HTTPS_SVCPROP_PORT = "org.apache.felix.http.svcprop.port.secure";
    public static final String HTTP_NIO = "org.apache.felix.http.nio";
    public static final String FELIX_HTTPS_ENABLE = "org.apache.felix.https.enable";
    public static final String OSCAR_HTTPS_ENABLE = "org.ungoverned.osgi.bundle.https.enable";
    public static final String FELIX_HTTP_ENABLE = "org.apache.felix.http.enable";
    public static final String FELIX_HTTPS_CLIENT_CERT = "org.apache.felix.https.clientcertificate";
    public static final String FELIX_TRUSTSTORE = "org.apache.felix.https.truststore";
    public static final String FELIX_TRUSTSTORE_PASSWORD = "org.apache.felix.https.truststore.password";
    protected static final String PID = "org.apache.felix.http";
    protected static boolean debug = false;
    private static ServiceTracker m_logTracker = null;
    private BundleContext m_bundleContext = null;
    private ServiceRegistration m_svcReg = null;
    private HttpServiceFactory m_httpServ = null;
    private Server m_server = null;
    private OsgiServletHandler m_hdlr = null;
    private int m_httpPort;
    private int m_httpsPort;
    private boolean m_useNIO;
    private String m_sslProvider;
    private String m_httpsPortProperty;
    private String m_keystore;
    private String m_passwd;
    private String m_keyPasswd;
    private boolean m_useHttps;
    private String m_httpPortProperty;
    private String m_truststore;
    private String m_trustpasswd;
    private Properties m_svcProperties = new Properties();
    private boolean m_useHttp;
    private String m_clientcert;
    private ServiceRegistration m_configSvcReg;
    private volatile boolean m_running;
    private volatile Thread m_thread;
    static /* synthetic */ Class class$org$osgi$service$log$LogService;
    static /* synthetic */ Class class$org$osgi$service$cm$ManagedService;
    static /* synthetic */ Class class$org$osgi$service$http$HttpService;
    static /* synthetic */ Class class$org$apache$felix$http$jetty$LogServiceLog;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;

    public void start(BundleContext bundleContext) throws BundleException {
        this.m_bundleContext = bundleContext;
        m_logTracker = new ServiceTracker(bundleContext, (class$org$osgi$service$log$LogService == null ? (class$org$osgi$service$log$LogService = Activator.class$("org.osgi.service.log.LogService")) : class$org$osgi$service$log$LogService).getName(), null);
        m_logTracker.open();
        this.setConfiguration(EMPTY_PROPS);
        this.m_running = true;
        this.m_thread = new Thread((Runnable)this, "Jetty HTTP Service Launcher");
        this.m_thread.start();
        this.m_configSvcReg = this.m_bundleContext.registerService((class$org$osgi$service$cm$ManagedService == null ? (class$org$osgi$service$cm$ManagedService = Activator.class$("org.osgi.service.cm.ManagedService")) : class$org$osgi$service$cm$ManagedService).getName(), (Object)this, (Dictionary)new Properties(){
            {
                this.put("service.pid", Activator.PID);
            }
        });
    }

    public void stop(BundleContext bundleContext) throws BundleException {
        if (this.m_configSvcReg != null) {
            this.m_configSvcReg.unregister();
        }
        this.m_running = false;
        this.m_thread.interrupt();
        try {
            this.m_thread.join(3000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        m_logTracker.close();
    }

    private void startJetty() {
        try {
            this.initializeJetty();
        }
        catch (Exception ex) {
            Activator.log(1, "Exception while initializing Jetty.", ex);
            return;
        }
        this.m_httpServ = new HttpServiceFactory();
        this.m_svcReg = this.m_bundleContext.registerService((class$org$osgi$service$http$HttpService == null ? (class$org$osgi$service$http$HttpService = Activator.class$("org.osgi.service.http.HttpService")) : class$org$osgi$service$http$HttpService).getName(), (Object)this.m_httpServ, (Dictionary)this.m_svcProperties);
        this.m_svcProperties = new Properties(this.m_svcProperties);
    }

    private void stopJetty() {
        if (this.m_svcReg != null) {
            this.m_svcReg.unregister();
            this.m_svcReg = null;
        }
        try {
            this.m_server.stop();
        }
        catch (Exception e) {
            Activator.log(1, "Exception while stopping Jetty.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        while (this.m_running) {
            this.initializeJettyLogger();
            this.startJetty();
            Activator activator = this;
            synchronized (activator) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.stopJetty();
            this.destroyJettyLogger();
        }
    }

    public void updated(Dictionary props) throws ConfigurationException {
        if (props == null) {
            this.setConfiguration(EMPTY_PROPS);
        } else {
            this.setConfiguration(props);
        }
        if (this.m_thread != null) {
            this.m_thread.interrupt();
        }
    }

    private void setConfiguration(Dictionary props) {
        debug = this.getBooleanProperty(props, FELIX_HTTP_DEBUG, this.getBooleanProperty(props, HTTP_DEBUG, false));
        this.m_httpPort = this.getIntProperty(props, HTTP_PORT, 80);
        this.m_httpsPort = this.getIntProperty(props, HTTPS_PORT, 443);
        this.m_useNIO = this.getBooleanProperty(props, HTTP_NIO, true);
        this.m_sslProvider = this.getStringProperty(props, FELIX_SSL_PROVIDER, this.getStringProperty(props, OSCAR_SSL_PROVIDER, DEFAULT_SSL_PROVIDER));
        this.m_httpsPortProperty = this.getStringProperty(props, HTTPS_SVCPROP_PORT, HTTPS_PORT);
        this.m_keystore = this.getStringProperty(props, FELIX_KEYSTORE, this.m_bundleContext.getProperty(OSCAR_KEYSTORE));
        this.m_passwd = this.getStringProperty(props, FELIX_KEYSTORE_PASSWORD, this.m_bundleContext.getProperty(OSCAR_KEYSTORE_PASSWORD));
        this.m_keyPasswd = this.getStringProperty(props, FELIX_KEYSTORE_KEY_PASSWORD, this.m_bundleContext.getProperty(OSCAR_KEYSTORE_KEY_PASSWORD));
        this.m_useHttps = this.getBooleanProperty(props, FELIX_HTTPS_ENABLE, this.getBooleanProperty(props, OSCAR_HTTPS_ENABLE, false));
        this.m_httpPortProperty = this.getStringProperty(props, HTTP_SVCPROP_PORT, HTTP_PORT);
        this.m_useHttp = this.getBooleanProperty(props, FELIX_HTTP_ENABLE, true);
        this.m_truststore = this.getStringProperty(props, FELIX_TRUSTSTORE, null);
        this.m_trustpasswd = this.getStringProperty(props, FELIX_TRUSTSTORE_PASSWORD, null);
        this.m_clientcert = this.getStringProperty(props, FELIX_HTTPS_CLIENT_CERT, DEFAULT_HTTPS_CLIENT_CERT);
    }

    private String getProperty(Dictionary props, String name) {
        String result = (String)props.get(name);
        if (result == null) {
            result = this.m_bundleContext.getProperty(name);
        }
        return result;
    }

    private int getIntProperty(Dictionary props, String name, int dflt_val) {
        int retval = dflt_val;
        try {
            retval = Integer.parseInt(this.getProperty(props, name));
        }
        catch (Exception e) {
            retval = dflt_val;
        }
        return retval;
    }

    private boolean getBooleanProperty(Dictionary props, String name, boolean dflt_val) {
        boolean retval = dflt_val;
        String strval = this.getProperty(props, name);
        if (strval != null) {
            retval = strval.toLowerCase().equals("true") || strval.toLowerCase().equals("yes");
        }
        return retval;
    }

    private String getStringProperty(Dictionary props, String name, String dflt_val) {
        String retval = dflt_val;
        String strval = this.getProperty(props, name);
        if (strval != null) {
            retval = strval;
        }
        return retval;
    }

    protected void initializeJettyLogger() {
        String oldProperty = System.getProperty("org.mortbay.log.class");
        System.setProperty("org.mortbay.log.class", (class$org$apache$felix$http$jetty$LogServiceLog == null ? (class$org$apache$felix$http$jetty$LogServiceLog = Activator.class$("org.apache.felix.http.jetty.LogServiceLog")) : class$org$apache$felix$http$jetty$LogServiceLog).getName());
        if (!(Log.getLog() instanceof LogServiceLog)) {
            Log.setLog(new LogServiceLog());
        }
        Log.getLog().setDebugEnabled(debug);
        if (oldProperty != null) {
            System.setProperty("org.mortbay.log.class", oldProperty);
        }
    }

    private void destroyJettyLogger() {
        Log.setLog(new StdErrLog());
    }

    protected void initializeJetty() throws Exception {
        HashUserRealm realm = new HashUserRealm("OSGi HTTP Service Realm");
        this.m_server = new Server();
        this.m_server.addUserRealm(realm);
        if (this.m_useHttp) {
            this.initializeHTTP();
        }
        if (this.m_useHttps) {
            this.initializeHTTPS();
        }
        this.m_hdlr = new OsgiServletHandler();
        Context hdlrContext = new Context(this.m_server, new SessionHandler(), null, this.m_hdlr, null);
        hdlrContext.setClassLoader(this.getClass().getClassLoader());
        hdlrContext.setContextPath("/");
        Activator.debug(" adding handler context : " + hdlrContext);
        try {
            hdlrContext.start();
        }
        catch (Exception e) {
            Activator.log(1, "Exception Starting Jetty Handler Context", e);
        }
        this.m_server.start();
    }

    private void initializeHTTP() {
        AbstractConnector connector = this.m_useNIO ? new SelectChannelConnector() : new SocketConnector();
        connector.addLifeCycleListener(new ConnectorListener(this.m_httpPortProperty));
        connector.setPort(this.m_httpPort);
        connector.setMaxIdleTime(60000);
        this.m_server.addConnector(connector);
    }

    protected void initializeHTTPS() throws Exception {
        if (this.m_useNIO) {
            SelectChannelConnector s_listener = (SelectChannelConnector)Class.forName("org.mortbay.jetty.security.SslSelectChannelConnector").newInstance();
            s_listener.addLifeCycleListener(new ConnectorListener(this.m_httpsPortProperty));
            s_listener.setPort(this.m_httpsPort);
            s_listener.setMaxIdleTime(60000);
            if (this.m_keystore != null) {
                s_listener.getClass().getMethod("setKeystore", class$java$lang$String == null ? (class$java$lang$String = Activator.class$("java.lang.String")) : class$java$lang$String).invoke((Object)s_listener, this.m_keystore);
            }
            if (this.m_passwd != null) {
                System.setProperty("jetty.ssl.password", this.m_passwd);
                s_listener.getClass().getMethod("setPassword", class$java$lang$String == null ? (class$java$lang$String = Activator.class$("java.lang.String")) : class$java$lang$String).invoke((Object)s_listener, this.m_passwd);
            }
            if (this.m_keyPasswd != null) {
                System.setProperty("jetty.ssl.keypassword", this.m_keyPasswd);
                s_listener.getClass().getMethod("setKeyPassword", class$java$lang$String == null ? (class$java$lang$String = Activator.class$("java.lang.String")) : class$java$lang$String).invoke((Object)s_listener, this.m_keyPasswd);
            }
            if (this.m_truststore != null) {
                s_listener.getClass().getMethod("setTruststore", class$java$lang$String == null ? (class$java$lang$String = Activator.class$("java.lang.String")) : class$java$lang$String).invoke((Object)s_listener, this.m_truststore);
            }
            if (this.m_trustpasswd != null) {
                s_listener.getClass().getMethod("setTrustPassword", class$java$lang$String == null ? (class$java$lang$String = Activator.class$("java.lang.String")) : class$java$lang$String).invoke((Object)s_listener, this.m_trustpasswd);
            }
            if ("wants".equals(this.m_clientcert)) {
                s_listener.getClass().getMethod("setWantClientAuth", Boolean.TYPE).invoke((Object)s_listener, Boolean.TRUE);
            } else if ("needs".equals(this.m_clientcert)) {
                s_listener.getClass().getMethod("setNeedClientAuth", Boolean.TYPE).invoke((Object)s_listener, Boolean.TRUE);
            }
            this.m_server.addConnector(s_listener);
        } else {
            SslSocketConnector s_listener = new SslSocketConnector();
            s_listener.addLifeCycleListener(new ConnectorListener(this.m_httpsPortProperty));
            s_listener.setPort(this.m_httpsPort);
            s_listener.setMaxIdleTime(60000);
            if (this.m_keystore != null) {
                s_listener.setKeystore(this.m_keystore);
            }
            if (this.m_passwd != null) {
                System.setProperty("jetty.ssl.password", this.m_passwd);
                s_listener.setPassword(this.m_passwd);
            }
            if (this.m_keyPasswd != null) {
                System.setProperty("jetty.ssl.keypassword", this.m_keyPasswd);
                s_listener.setKeyPassword(this.m_keyPasswd);
            }
            if (this.m_truststore != null) {
                s_listener.setTruststore(this.m_truststore);
            }
            if (this.m_trustpasswd != null) {
                s_listener.setTrustPassword(this.m_trustpasswd);
            }
            if ("wants".equals(this.m_clientcert)) {
                s_listener.setWantClientAuth(true);
                s_listener.getClass().getMethod("setWantClientAuth", class$java$lang$Boolean == null ? (class$java$lang$Boolean = Activator.class$("java.lang.Boolean")) : class$java$lang$Boolean).invoke((Object)s_listener, Boolean.TRUE);
            } else if ("needs".equals(this.m_clientcert)) {
                s_listener.setNeedClientAuth(true);
            }
            this.m_server.addConnector(s_listener);
        }
    }

    public static void debug(String txt) {
        if (debug) {
            Activator.log(4, ">>Felix HTTP: " + txt, null);
        }
    }

    public static void log(int level, String message, Throwable throwable) {
        LogService log = (LogService)m_logTracker.getService();
        if (log != null) {
            log.log(level, message, throwable);
        } else {
            System.out.println(message);
            if (throwable != null) {
                throwable.printStackTrace(System.out);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class ConnectorListener
    implements LifeCycle.Listener {
        String m_svcPropName;

        public ConnectorListener(String svcPropName) {
            this.m_svcPropName = svcPropName;
        }

        public void lifeCycleFailure(LifeCycle event, Throwable cause) {
        }

        public void lifeCycleStarted(LifeCycle event) {
            Connector conn = (Connector)event;
            int actualPort = conn.getLocalPort();
            Activator.debug("** http set service prop:" + this.m_svcPropName + ", value: " + actualPort);
            Activator.this.m_svcProperties.setProperty(this.m_svcPropName, String.valueOf(actualPort));
            if (Activator.this.m_svcReg != null) {
                Activator.this.m_svcReg.setProperties((Dictionary)Activator.this.m_svcProperties);
                Activator.this.m_svcProperties = new Properties(Activator.this.m_svcProperties);
            }
        }

        public void lifeCycleStarting(LifeCycle event) {
        }

        public void lifeCycleStopped(LifeCycle event) {
        }

        public void lifeCycleStopping(LifeCycle event) {
        }
    }

    public class HttpServiceFactory
    implements ServiceFactory {
        public HttpServiceFactory() {
            HttpServiceImpl.initializeStatics();
        }

        public Object getService(Bundle bundle, ServiceRegistration registration) {
            HttpServiceImpl srv = new HttpServiceImpl(bundle, Activator.this.m_server, Activator.this.m_hdlr);
            Activator.debug("** http service get:" + bundle + ", service: " + srv);
            return srv;
        }

        public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
            Activator.debug("** http service unget:" + bundle + ", service: " + service);
            ((HttpServiceImpl)service).unregisterAll();
        }
    }
}

