/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.whiteboard;

import jakarta.servlet.FilterChain;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpSessionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.felix.http.base.internal.context.ExtServletContext;
import org.apache.felix.http.base.internal.handler.FilterHandler;
import org.apache.felix.http.base.internal.handler.HttpServiceServletHandler;
import org.apache.felix.http.base.internal.handler.HttpSessionWrapper;
import org.apache.felix.http.base.internal.handler.ListenerHandler;
import org.apache.felix.http.base.internal.handler.PreprocessorHandler;
import org.apache.felix.http.base.internal.handler.WhiteboardServletHandler;
import org.apache.felix.http.base.internal.logger.SystemLogger;
import org.apache.felix.http.base.internal.registry.EventListenerRegistry;
import org.apache.felix.http.base.internal.registry.HandlerRegistry;
import org.apache.felix.http.base.internal.runtime.AbstractInfo;
import org.apache.felix.http.base.internal.runtime.DefaultServletContextHelperInfo;
import org.apache.felix.http.base.internal.runtime.FilterInfo;
import org.apache.felix.http.base.internal.runtime.ListenerInfo;
import org.apache.felix.http.base.internal.runtime.PreprocessorInfo;
import org.apache.felix.http.base.internal.runtime.ResourceInfo;
import org.apache.felix.http.base.internal.runtime.ServletContextHelperInfo;
import org.apache.felix.http.base.internal.runtime.ServletInfo;
import org.apache.felix.http.base.internal.runtime.WhiteboardServiceInfo;
import org.apache.felix.http.base.internal.runtime.dto.FailedDTOHolder;
import org.apache.felix.http.base.internal.runtime.dto.PreprocessorDTOBuilder;
import org.apache.felix.http.base.internal.runtime.dto.RegistryRuntime;
import org.apache.felix.http.base.internal.runtime.dto.ServletContextDTOBuilder;
import org.apache.felix.http.base.internal.service.HttpServiceFactory;
import org.apache.felix.http.base.internal.service.HttpServiceRuntimeImpl;
import org.apache.felix.http.base.internal.whiteboard.FailureStateHandler;
import org.apache.felix.http.base.internal.whiteboard.HttpServiceContextHandler;
import org.apache.felix.http.base.internal.whiteboard.ResourceServlet;
import org.apache.felix.http.base.internal.whiteboard.WhiteboardContextHandler;
import org.apache.felix.http.base.internal.whiteboard.tracker.FilterTracker;
import org.apache.felix.http.base.internal.whiteboard.tracker.JavaxFilterTracker;
import org.apache.felix.http.base.internal.whiteboard.tracker.JavaxListenersTracker;
import org.apache.felix.http.base.internal.whiteboard.tracker.JavaxPreprocessorTracker;
import org.apache.felix.http.base.internal.whiteboard.tracker.JavaxServletContextHelperTracker;
import org.apache.felix.http.base.internal.whiteboard.tracker.JavaxServletTracker;
import org.apache.felix.http.base.internal.whiteboard.tracker.ListenersTracker;
import org.apache.felix.http.base.internal.whiteboard.tracker.PreprocessorTracker;
import org.apache.felix.http.base.internal.whiteboard.tracker.ResourceTracker;
import org.apache.felix.http.base.internal.whiteboard.tracker.ServletContextHelperTracker;
import org.apache.felix.http.base.internal.whiteboard.tracker.ServletTracker;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.servlet.runtime.dto.PreprocessorDTO;
import org.osgi.service.servlet.runtime.dto.ServletContextDTO;
import org.osgi.service.servlet.whiteboard.Preprocessor;
import org.osgi.util.tracker.ServiceTracker;

public final class WhiteboardManager {
    private final BundleContext httpBundleContext;
    private final HttpServiceFactory httpServiceFactory;
    private final HttpServiceRuntimeImpl serviceRuntime;
    private final List<ServiceTracker<?, ?>> trackers = new ArrayList();
    private final Map<String, List<WhiteboardContextHandler>> contextMap = new HashMap<String, List<WhiteboardContextHandler>>();
    private final Map<WhiteboardServiceInfo<?>, List<WhiteboardContextHandler>> servicesMap = new HashMap();
    private volatile List<PreprocessorHandler> preprocessorHandlers = Collections.emptyList();
    private final HandlerRegistry registry;
    private final FailureStateHandler failureStateHandler = new FailureStateHandler();
    private volatile ServletContext webContext;

    public WhiteboardManager(BundleContext bundleContext, HttpServiceFactory httpServiceFactory, HandlerRegistry registry) {
        this.httpBundleContext = bundleContext;
        this.httpServiceFactory = httpServiceFactory;
        this.registry = registry;
        this.serviceRuntime = new HttpServiceRuntimeImpl(registry, this, bundleContext);
    }

    public void start(ServletContext containerContext, @NotNull Dictionary<String, Object> httpServiceProps) {
        this.serviceRuntime.setAllAttributes(httpServiceProps);
        this.serviceRuntime.setAttribute("osgi.http.service.id", Collections.singletonList(this.httpServiceFactory.getHttpServiceServiceId()));
        this.serviceRuntime.register(this.httpBundleContext);
        this.webContext = containerContext;
        ArrayList<HttpServiceContextHandler> httpContextList = new ArrayList<HttpServiceContextHandler>();
        ServletContextHelperInfo httpInfo = new ServletContextHelperInfo(Integer.MAX_VALUE, -1L, "org.osgi.service.http", "/", null);
        httpContextList.add(new HttpServiceContextHandler(httpInfo, this.registry.getRegistry(-1L), this.httpServiceFactory, this.webContext, this.httpBundleContext.getBundle()));
        this.contextMap.put("org.osgi.service.http", httpContextList);
        this.addContextHelper(new DefaultServletContextHelperInfo());
        this.addTracker(new PreprocessorTracker(this.httpBundleContext, this));
        this.addTracker(new JavaxPreprocessorTracker(this.httpBundleContext, this));
        this.addTracker(new ListenersTracker(this.httpBundleContext, this));
        this.addTracker(new JavaxListenersTracker(this.httpBundleContext, this));
        this.addTracker(new ServletContextHelperTracker(this.httpBundleContext, this));
        this.addTracker(new JavaxServletContextHelperTracker(this.httpBundleContext, this));
        this.addTracker(new FilterTracker(this.httpBundleContext, this));
        this.addTracker(new ServletTracker(this.httpBundleContext, this));
        this.addTracker(new ResourceTracker(this.httpBundleContext, this));
        this.addTracker(new JavaxFilterTracker(this.httpBundleContext, this));
        this.addTracker(new JavaxServletTracker(this.httpBundleContext, this));
    }

    private void addTracker(ServiceTracker<?, ?> tracker) {
        this.trackers.add(tracker);
        tracker.open();
    }

    public void stop() {
        this.webContext = null;
        this.serviceRuntime.unregister();
        for (ServiceTracker<?, ?> t : this.trackers) {
            t.close();
        }
        this.trackers.clear();
        this.preprocessorHandlers = Collections.emptyList();
        this.contextMap.clear();
        this.servicesMap.clear();
        this.failureStateHandler.clear();
        this.registry.reset();
    }

    public void sessionDestroyed(@NotNull HttpSession session, Set<String> contextNames) {
        for (String contextName : contextNames) {
            WhiteboardContextHandler handler = this.getContextHandler(contextName);
            if (handler == null) continue;
            ExtServletContext context = handler.getServletContext(this.httpBundleContext.getBundle());
            new HttpSessionWrapper(session, context, this.registry.getConfig(), true).invalidate();
            handler.ungetServletContext(this.httpBundleContext.getBundle());
        }
    }

    public void sessionIdChanged(@NotNull HttpSessionEvent event, String oldSessionId, Set<String> contextNames) {
        for (String contextName : contextNames) {
            WhiteboardContextHandler handler = this.getContextHandler(contextName);
            if (handler == null) continue;
            handler.getRegistry().getEventListenerRegistry().sessionIdChanged(event, oldSessionId);
        }
    }

    private boolean activate(WhiteboardContextHandler handler) {
        if (!handler.activate(this.registry)) {
            return false;
        }
        ArrayList services = new ArrayList();
        for (Map.Entry<WhiteboardServiceInfo<?>, List<WhiteboardContextHandler>> entry : this.servicesMap.entrySet()) {
            int reason;
            WhiteboardServiceInfo<?> info = entry.getKey();
            if (!info.getContextSelectionFilter().match(handler.getContextInfo().getServiceReference()) || (reason = this.checkForServletRegistrationInHttpServiceContext(handler, info)) != -1) continue;
            entry.getValue().add(handler);
            if (entry.getValue().size() == 1) {
                this.failureStateHandler.remove(info);
            }
            if (info instanceof ListenerInfo && ((ListenerInfo)info).isListenerType(ServletContextListener.class.getName())) {
                this.registerWhiteboardService(handler, info);
                continue;
            }
            services.add(info);
        }
        handler.getRegistry().getEventListenerRegistry().contextInitialized();
        for (WhiteboardServiceInfo whiteboardServiceInfo : services) {
            this.registerWhiteboardService(handler, whiteboardServiceInfo);
        }
        return true;
    }

    private void deactivate(WhiteboardContextHandler handler) {
        ArrayList listeners = new ArrayList();
        for (Map.Entry<WhiteboardServiceInfo<?>, List<WhiteboardContextHandler>> entry : this.servicesMap.entrySet()) {
            if (!entry.getValue().remove(handler)) continue;
            if (!this.failureStateHandler.remove((AbstractInfo)entry.getKey(), handler.getContextInfo().getServiceId())) {
                if (entry.getKey() instanceof ListenerInfo && ((ListenerInfo)entry.getKey()).isListenerType(ServletContextListener.class.getName())) {
                    listeners.add(entry.getKey());
                } else {
                    this.unregisterWhiteboardService(handler, entry.getKey());
                }
            }
            if (!entry.getValue().isEmpty()) continue;
            this.failureStateHandler.addFailure((AbstractInfo)entry.getKey(), 1);
        }
        handler.getRegistry().getEventListenerRegistry().contextDestroyed();
        for (WhiteboardServiceInfo whiteboardServiceInfo : listeners) {
            this.unregisterWhiteboardService(handler, whiteboardServiceInfo);
        }
        handler.deactivate(this.registry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addContextHelper(ServletContextHelperInfo info) {
        if (this.isMatchingService(info)) {
            if (info.isValid()) {
                Map<String, List<WhiteboardContextHandler>> map = this.contextMap;
                synchronized (map) {
                    boolean activate;
                    WhiteboardContextHandler handler = new WhiteboardContextHandler(info, this.webContext, this.httpBundleContext.getBundle());
                    List<WhiteboardContextHandler> handlerList = this.contextMap.get(info.getName());
                    if (handlerList == null) {
                        handlerList = new ArrayList<WhiteboardContextHandler>();
                    }
                    boolean bl = activate = handlerList.isEmpty() || handlerList.get(0).compareTo(handler) > 0;
                    if (activate) {
                        if (this.activate(handler)) {
                            handlerList.add(handler);
                            Collections.sort(handlerList);
                            this.contextMap.put(info.getName(), handlerList);
                            if (handlerList.size() > 1) {
                                WhiteboardContextHandler oldHead = handlerList.get(1);
                                this.deactivate(oldHead);
                                this.failureStateHandler.addFailure(oldHead.getContextInfo(), 3);
                            }
                        } else {
                            this.failureStateHandler.addFailure(info, 5);
                        }
                    } else {
                        handlerList.add(handler);
                        Collections.sort(handlerList);
                        this.contextMap.put(info.getName(), handlerList);
                        this.failureStateHandler.addFailure(info, 3);
                    }
                }
            } else {
                this.failureStateHandler.addFailure(info, 6);
            }
            this.updateRuntimeChangeCount();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeContextHelper(ServletContextHelperInfo info) {
        if (info.isValid()) {
            Map<String, List<WhiteboardContextHandler>> map = this.contextMap;
            synchronized (map) {
                List<WhiteboardContextHandler> handlerList = this.contextMap.get(info.getName());
                if (handlerList != null) {
                    Iterator<WhiteboardContextHandler> i = handlerList.iterator();
                    boolean first = true;
                    boolean activateNext = false;
                    while (i.hasNext()) {
                        WhiteboardContextHandler handler = i.next();
                        if (handler.getContextInfo().equals(info)) {
                            i.remove();
                            if (!first) break;
                            this.deactivate(handler);
                            activateNext = this.webContext != null;
                            break;
                        }
                        first = false;
                    }
                    if (handlerList.isEmpty()) {
                        this.contextMap.remove(info.getName());
                    } else if (activateNext) {
                        boolean done = false;
                        while (!handlerList.isEmpty() && !done) {
                            WhiteboardContextHandler newHead = handlerList.get(0);
                            this.failureStateHandler.removeAll(newHead.getContextInfo());
                            if (this.activate(newHead)) {
                                done = true;
                                continue;
                            }
                            handlerList.remove(0);
                            this.failureStateHandler.addFailure(newHead.getContextInfo(), 5);
                        }
                    }
                }
            }
        }
        this.failureStateHandler.removeAll(info);
        this.updateRuntimeChangeCount();
    }

    private List<WhiteboardContextHandler> getMatchingContexts(WhiteboardServiceInfo<?> info) {
        ArrayList<WhiteboardContextHandler> result = new ArrayList<WhiteboardContextHandler>();
        for (List<WhiteboardContextHandler> handlerList : this.contextMap.values()) {
            boolean visible;
            WhiteboardContextHandler h = handlerList.get(0);
            boolean matches = h.getContextInfo().match(info);
            if (!matches) continue;
            boolean bl = visible = h.getContextInfo().getServiceId() < 0L;
            if (!visible) {
                String filterString = "(service.id=" + String.valueOf(h.getContextInfo().getServiceId()) + ")";
                try {
                    ServiceReference[] col = info.getServiceReference().getBundle().getBundleContext().getServiceReferences(h.getContextInfo().getServiceType(), filterString);
                    if (col != null && col.length > 0) {
                        visible = true;
                    }
                }
                catch (InvalidSyntaxException invalidSyntaxException) {
                    // empty catch block
                }
            }
            if (!visible) continue;
            result.add(h);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addWhiteboardService(@NotNull WhiteboardServiceInfo<?> info) {
        if (this.isMatchingService(info)) {
            if (info.isValid()) {
                if (info instanceof PreprocessorInfo) {
                    PreprocessorHandler handler = new PreprocessorHandler(this.httpBundleContext, this.webContext, (PreprocessorInfo)info);
                    int result = handler.init();
                    if (result == -1) {
                        List<PreprocessorHandler> list = this.preprocessorHandlers;
                        synchronized (list) {
                            ArrayList<PreprocessorHandler> newList = new ArrayList<PreprocessorHandler>(this.preprocessorHandlers);
                            newList.add(handler);
                            Collections.sort(newList);
                            this.preprocessorHandlers = newList;
                        }
                    } else {
                        this.failureStateHandler.addFailure(info, 6);
                    }
                    this.updateRuntimeChangeCount();
                    return true;
                }
                Map<String, List<WhiteboardContextHandler>> map = this.contextMap;
                synchronized (map) {
                    List<WhiteboardContextHandler> handlerList = this.getMatchingContexts(info);
                    this.servicesMap.put(info, handlerList);
                    if (handlerList.isEmpty()) {
                        this.failureStateHandler.addFailure(info, 1);
                    } else {
                        for (WhiteboardContextHandler h : handlerList) {
                            ServletContextListener listener;
                            ListenerHandler handler;
                            int result = this.checkForServletRegistrationInHttpServiceContext(h, info);
                            if (result != -1) continue;
                            this.registerWhiteboardService(h, info);
                            if (!(info instanceof ListenerInfo) || !((ListenerInfo)info).isListenerType(ServletContextListener.class.getName()) || (handler = h.getRegistry().getEventListenerRegistry().getServletContextListener((ListenerInfo)info)) == null || (listener = (ServletContextListener)handler.getListener()) == null) continue;
                            EventListenerRegistry.contextInitialized(handler.getListenerInfo(), listener, new ServletContextEvent((ServletContext)handler.getContext()));
                        }
                    }
                }
            } else {
                this.failureStateHandler.addFailure(info, 6);
            }
            this.updateRuntimeChangeCount();
            return true;
        }
        return false;
    }

    private int checkForServletRegistrationInHttpServiceContext(WhiteboardContextHandler h, WhiteboardServiceInfo<?> info) {
        if (h.getContextInfo().getServiceId() == -1L) {
            if (info instanceof ResourceInfo && info.getContextSelection().contains("osgi.http.whiteboard.context.httpservice")) {
                this.failureStateHandler.addFailure(info, -1L, 6);
                return 6;
            }
            if (info instanceof ServletInfo && info.getContextSelection().contains("osgi.http.whiteboard.context.httpservice")) {
                boolean patternIsEmpty;
                ServletInfo servletInfo = (ServletInfo)info;
                boolean nameIsEmpty = servletInfo.getName() == null || servletInfo.getName().isEmpty();
                boolean errorPageIsEmpty = servletInfo.getErrorPage() == null || servletInfo.getErrorPage().length == 0;
                boolean bl = patternIsEmpty = servletInfo.getPatterns() == null || servletInfo.getPatterns().length == 0;
                if (!(nameIsEmpty && errorPageIsEmpty || !patternIsEmpty)) {
                    return -1;
                }
                this.failureStateHandler.addFailure(info, -1L, 6);
                return 6;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWhiteboardService(WhiteboardServiceInfo<?> info) {
        Map<String, List<WhiteboardContextHandler>> map = this.contextMap;
        synchronized (map) {
            if (!this.failureStateHandler.remove(info)) {
                if (info instanceof PreprocessorInfo) {
                    List<PreprocessorHandler> list = this.preprocessorHandlers;
                    synchronized (list) {
                        ArrayList<PreprocessorHandler> newList = new ArrayList<PreprocessorHandler>(this.preprocessorHandlers);
                        Iterator iter = newList.iterator();
                        while (iter.hasNext()) {
                            PreprocessorHandler handler = (PreprocessorHandler)iter.next();
                            if (handler.getPreprocessorInfo().compareTo((PreprocessorInfo)info) != 0) continue;
                            iter.remove();
                            this.preprocessorHandlers = newList;
                            this.updateRuntimeChangeCount();
                            return;
                        }
                    }
                    return;
                }
                List<WhiteboardContextHandler> handlerList = this.servicesMap.remove(info);
                if (handlerList != null) {
                    for (WhiteboardContextHandler h : handlerList) {
                        ServletContextListener listener;
                        ListenerHandler handler;
                        if (this.failureStateHandler.remove(info, h.getContextInfo().getServiceId())) continue;
                        if (info instanceof ListenerInfo && ((ListenerInfo)info).isListenerType(ServletContextListener.class.getName()) && (handler = h.getRegistry().getEventListenerRegistry().getServletContextListener((ListenerInfo)info)) != null && (listener = (ServletContextListener)handler.getListener()) != null) {
                            EventListenerRegistry.contextDestroyed(handler.getListenerInfo(), listener, new ServletContextEvent((ServletContext)handler.getContext()));
                        }
                        this.unregisterWhiteboardService(h, info);
                    }
                }
            }
            this.failureStateHandler.removeAll(info);
        }
        this.updateRuntimeChangeCount();
    }

    private void registerWhiteboardService(WhiteboardContextHandler handler, WhiteboardServiceInfo<?> info) {
        try {
            int failureCode = -1;
            if (info instanceof ServletInfo) {
                ExtServletContext servletContext = handler.getServletContext(info.getServiceReference().getBundle());
                if (servletContext == null) {
                    failureCode = 2;
                } else {
                    WhiteboardServletHandler servletHandler = new WhiteboardServletHandler(handler.getContextInfo().getServiceId(), servletContext, (ServletInfo)info, handler.getBundleContext(), info.getServiceReference().getBundle(), this.httpBundleContext.getBundle());
                    handler.getRegistry().registerServlet(servletHandler);
                }
            } else if (info instanceof FilterInfo) {
                ExtServletContext servletContext = handler.getServletContext(info.getServiceReference().getBundle());
                if (servletContext == null) {
                    failureCode = 2;
                } else {
                    FilterHandler filterHandler = new FilterHandler(handler.getContextInfo().getServiceId(), servletContext, (FilterInfo)info, handler.getBundleContext());
                    handler.getRegistry().registerFilter(filterHandler);
                }
            } else if (info instanceof ResourceInfo) {
                ServletInfo servletInfo = ((ResourceInfo)info).getServletInfo();
                ExtServletContext servletContext = handler.getServletContext(info.getServiceReference().getBundle());
                if (servletContext == null) {
                    failureCode = 2;
                } else {
                    HttpServiceServletHandler servleHandler = new HttpServiceServletHandler(handler.getContextInfo().getServiceId(), servletContext, servletInfo, (Servlet)new ResourceServlet(servletInfo.getPrefix()));
                    handler.getRegistry().registerServlet(servleHandler);
                }
            } else if (info instanceof ListenerInfo) {
                ExtServletContext servletContext = handler.getServletContext(info.getServiceReference().getBundle());
                if (servletContext == null) {
                    failureCode = 2;
                } else {
                    ListenerHandler listenerHandler = new ListenerHandler(handler.getContextInfo().getServiceId(), servletContext, (ListenerInfo)info, handler.getBundleContext());
                    handler.getRegistry().registerListeners(listenerHandler);
                }
            } else {
                SystemLogger.LOGGER.error("Unknown whiteboard service {}", info.getServiceReference());
            }
            if (failureCode != -1) {
                this.failureStateHandler.addFailure(info, handler.getContextInfo().getServiceId(), failureCode);
            }
        }
        catch (Exception e) {
            this.failureStateHandler.addFailure(info, handler.getContextInfo().getServiceId(), 0, e);
        }
    }

    private void unregisterWhiteboardService(WhiteboardContextHandler handler, WhiteboardServiceInfo<?> info) {
        try {
            if (info instanceof ServletInfo) {
                handler.getRegistry().unregisterServlet((ServletInfo)info, true);
                handler.ungetServletContext(info.getServiceReference().getBundle());
            } else if (info instanceof FilterInfo) {
                handler.getRegistry().unregisterFilter((FilterInfo)info, true);
                handler.ungetServletContext(info.getServiceReference().getBundle());
            } else if (info instanceof ResourceInfo) {
                handler.getRegistry().unregisterServlet(((ResourceInfo)info).getServletInfo(), true);
                handler.ungetServletContext(info.getServiceReference().getBundle());
            } else if (info instanceof ListenerInfo) {
                handler.getRegistry().unregisterListeners((ListenerInfo)info);
                handler.ungetServletContext(info.getServiceReference().getBundle());
            }
        }
        catch (Exception e) {
            SystemLogger.LOGGER.error("Exception while unregistering whiteboard service {}", info.getServiceReference(), (Object)e);
        }
    }

    private boolean isMatchingService(AbstractInfo<?> info) {
        String target = info.getTarget();
        if (target != null) {
            try {
                Filter f = this.httpBundleContext.createFilter(target);
                return f.match(this.serviceRuntime.getServiceReference());
            }
            catch (InvalidSyntaxException ise) {
                SystemLogger.LOGGER.error("Invalid target filter expression for {} : {}", new Object[]{info.getServiceReference(), target, ise});
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WhiteboardContextHandler getContextHandler(String name) {
        Map<String, List<WhiteboardContextHandler>> map = this.contextMap;
        synchronized (map) {
            for (List<WhiteboardContextHandler> handlerList : this.contextMap.values()) {
                WhiteboardContextHandler h = handlerList.get(0);
                if (!h.getContextInfo().getName().equals(name)) continue;
                return h;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegistryRuntime getRuntimeInfo() {
        FailedDTOHolder failedDTOHolder = new FailedDTOHolder();
        ArrayList<ServletContextDTO> contextDTOs = new ArrayList<ServletContextDTO>();
        ArrayList<WhiteboardContextHandler> contextHandlerList = new ArrayList<WhiteboardContextHandler>();
        Map<String, List<WhiteboardContextHandler>> map = this.contextMap;
        synchronized (map) {
            for (List<WhiteboardContextHandler> list : this.contextMap.values()) {
                if (list.isEmpty()) continue;
                contextHandlerList.add(list.get(0));
            }
            this.failureStateHandler.getRuntimeInfo(failedDTOHolder);
        }
        Collections.sort(contextHandlerList);
        for (WhiteboardContextHandler handler : contextHandlerList) {
            ServletContextDTO scDTO = ServletContextDTOBuilder.build(handler.getContextInfo(), handler.getSharedContext(), -1);
            if (!this.registry.getRuntimeInfo(scDTO, failedDTOHolder)) continue;
            contextDTOs.add(scDTO);
        }
        ArrayList<PreprocessorDTO> preprocessorDTOs = new ArrayList<PreprocessorDTO>();
        List<PreprocessorHandler> localHandlers = this.preprocessorHandlers;
        for (PreprocessorHandler handler : localHandlers) {
            preprocessorDTOs.add(PreprocessorDTOBuilder.build(handler.getPreprocessorInfo(), -1));
        }
        return new RegistryRuntime(failedDTOHolder, contextDTOs, preprocessorDTOs);
    }

    public void invokePreprocessors(HttpServletRequest req, HttpServletResponse res, final Preprocessor dispatcher) throws ServletException, IOException {
        final List<PreprocessorHandler> localHandlers = this.preprocessorHandlers;
        if (localHandlers.isEmpty()) {
            dispatcher.doFilter((ServletRequest)req, (ServletResponse)res, null);
        } else {
            FilterChain chain = new FilterChain(){
                private int index = 0;

                public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
                    if (this.index == localHandlers.size()) {
                        dispatcher.doFilter(request, response, null);
                    } else {
                        PreprocessorHandler handler = (PreprocessorHandler)localHandlers.get(this.index);
                        ++this.index;
                        handler.handle(request, response, this);
                    }
                }
            };
            chain.doFilter((ServletRequest)req, (ServletResponse)res);
        }
    }

    private void updateRuntimeChangeCount() {
        this.serviceRuntime.updateChangeCount();
    }
}

