/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.jakartawrappers;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletMapping;
import javax.servlet.http.HttpServletRequest;
import org.apache.felix.http.jakartawrappers.AsyncContextWrapper;
import org.apache.felix.http.jakartawrappers.HttpServletMappingWrapper;
import org.apache.felix.http.jakartawrappers.HttpServletRequestWrapper;
import org.apache.felix.http.jakartawrappers.RequestDispatcherWrapper;
import org.apache.felix.http.jakartawrappers.ServletContextWrapper;
import org.apache.felix.http.jakartawrappers.ServletInputStreamWrapper;
import org.apache.felix.http.javaxwrappers.ServletResponseWrapper;
import org.jetbrains.annotations.NotNull;

public class ServletRequestWrapper
implements jakarta.servlet.ServletRequest {
    private final ServletRequest request;

    public static jakarta.servlet.ServletRequest getWrapper(ServletRequest r) {
        if (r instanceof org.apache.felix.http.javaxwrappers.ServletRequestWrapper) {
            return ((org.apache.felix.http.javaxwrappers.ServletRequestWrapper)r).getRequest();
        }
        if (r instanceof HttpServletRequest) {
            return new HttpServletRequestWrapper((HttpServletRequest)r);
        }
        return new ServletRequestWrapper(r);
    }

    public ServletRequestWrapper(@NotNull ServletRequest r) {
        this.request = r;
    }

    public ServletRequest getRequest() {
        return this.request;
    }

    private Object wrapHttpServletMapping(Object value) {
        if (value instanceof org.apache.felix.http.javaxwrappers.HttpServletMappingWrapper) {
            return ((org.apache.felix.http.javaxwrappers.HttpServletMappingWrapper)value).getMapping();
        }
        if (value instanceof HttpServletMapping) {
            return new HttpServletMappingWrapper((HttpServletMapping)value);
        }
        return value;
    }

    public Object getAttribute(String name) {
        if ("jakarta.servlet.forward.context_path".equals(name)) {
            return this.request.getAttribute("javax.servlet.forward.context_path");
        }
        if ("jakarta.servlet.forward.mapping".equals(name)) {
            return this.wrapHttpServletMapping(this.request.getAttribute("javax.servlet.forward.mapping"));
        }
        if ("jakarta.servlet.forward.path_info".equals(name)) {
            return this.request.getAttribute("javax.servlet.forward.path_info");
        }
        if ("jakarta.servlet.forward.query_string".equals(name)) {
            return this.request.getAttribute("javax.servlet.forward.query_string");
        }
        if ("jakarta.servlet.forward.request_uri".equals(name)) {
            return this.request.getAttribute("javax.servlet.forward.request_uri");
        }
        if ("jakarta.servlet.forward.servlet_path".equals(name)) {
            return this.request.getAttribute("javax.servlet.forward.servlet_path");
        }
        if ("jakarta.servlet.include.context_path".equals(name)) {
            return this.request.getAttribute("javax.servlet.include.context_path");
        }
        if ("jakarta.servlet.include.mapping".equals(name)) {
            return this.wrapHttpServletMapping(this.request.getAttribute("javax.servlet.include.mapping"));
        }
        if ("jakarta.servlet.include.path_info".equals(name)) {
            return this.request.getAttribute("javax.servlet.include.path_info");
        }
        if ("jakarta.servlet.include.query_string".equals(name)) {
            return this.request.getAttribute("javax.servlet.include.query_string");
        }
        if ("jakarta.servlet.include.request_uri".equals(name)) {
            return this.request.getAttribute("javax.servlet.include.request_uri");
        }
        if ("jakarta.servlet.include.servlet_path".equals(name)) {
            return this.request.getAttribute("javax.servlet.include.servlet_path");
        }
        if ("jakarta.servlet.error.exception".equals(name)) {
            return this.request.getAttribute("javax.servlet.error.exception");
        }
        if ("jakarta.servlet.error.exception_type".equals(name)) {
            return this.request.getAttribute("javax.servlet.error.exception_type");
        }
        if ("jakarta.servlet.error.message".equals(name)) {
            return this.request.getAttribute("javax.servlet.error.message");
        }
        if ("jakarta.servlet.error.request_uri".equals(name)) {
            return this.request.getAttribute("javax.servlet.error.request_uri");
        }
        if ("jakarta.servlet.error.servlet_name".equals(name)) {
            return this.request.getAttribute("javax.servlet.error.servlet_name");
        }
        if ("jakarta.servlet.error.status_code".equals(name)) {
            return this.request.getAttribute("javax.servlet.error.status_code");
        }
        if ("jakarta.servlet.async.context_path".equals(name)) {
            return this.request.getAttribute("javax.servlet.async.context_path");
        }
        if ("jakarta.servlet.async.mapping".equals(name)) {
            return this.wrapHttpServletMapping(this.request.getAttribute("javax.servlet.async.mapping"));
        }
        if ("jakarta.servlet.async.path_info".equals(name)) {
            return this.request.getAttribute("javax.servlet.async.path_info");
        }
        if ("jakarta.servlet.async.query_string".equals(name)) {
            return this.request.getAttribute("javax.servlet.async.query_string");
        }
        if ("jakarta.servlet.async.request_uri".equals(name)) {
            return this.request.getAttribute("javax.servlet.async.request_uri");
        }
        if ("jakarta.servlet.async.servlet_path".equals(name)) {
            return this.request.getAttribute("javax.servlet.async.servlet_path");
        }
        return this.request.getAttribute(name);
    }

    public Enumeration<String> getAttributeNames() {
        return this.request.getAttributeNames();
    }

    public String getCharacterEncoding() {
        return this.request.getCharacterEncoding();
    }

    public void setCharacterEncoding(String env) throws UnsupportedEncodingException {
        this.request.setCharacterEncoding(env);
    }

    public int getContentLength() {
        return this.request.getContentLength();
    }

    public long getContentLengthLong() {
        return this.request.getContentLengthLong();
    }

    public String getContentType() {
        return this.request.getContentType();
    }

    public ServletInputStream getInputStream() throws IOException {
        return new ServletInputStreamWrapper(this.request.getInputStream());
    }

    public String getParameter(String name) {
        return this.request.getParameter(name);
    }

    public Enumeration<String> getParameterNames() {
        return this.request.getParameterNames();
    }

    public String[] getParameterValues(String name) {
        return this.request.getParameterValues(name);
    }

    public Map<String, String[]> getParameterMap() {
        return this.request.getParameterMap();
    }

    public String getProtocol() {
        return this.request.getProtocol();
    }

    public String getScheme() {
        return this.request.getScheme();
    }

    public String getServerName() {
        return this.request.getServerName();
    }

    public int getServerPort() {
        return this.request.getServerPort();
    }

    public BufferedReader getReader() throws IOException {
        return this.request.getReader();
    }

    public String getRemoteAddr() {
        return this.request.getRemoteAddr();
    }

    public String getRemoteHost() {
        return this.request.getRemoteHost();
    }

    public void setAttribute(String name, Object o) {
        this.request.setAttribute(name, o);
    }

    public void removeAttribute(String name) {
        this.request.removeAttribute(name);
    }

    public Locale getLocale() {
        return this.request.getLocale();
    }

    public Enumeration<Locale> getLocales() {
        return this.request.getLocales();
    }

    public boolean isSecure() {
        return this.request.isSecure();
    }

    public jakarta.servlet.RequestDispatcher getRequestDispatcher(String path) {
        RequestDispatcher dispatcher = this.request.getRequestDispatcher(path);
        if (dispatcher != null) {
            return new RequestDispatcherWrapper(dispatcher);
        }
        return null;
    }

    public String getRealPath(String path) {
        return this.request.getRealPath(path);
    }

    public int getRemotePort() {
        return this.request.getRemotePort();
    }

    public String getLocalName() {
        return this.request.getLocalName();
    }

    public String getLocalAddr() {
        return this.request.getLocalAddr();
    }

    public int getLocalPort() {
        return this.request.getLocalPort();
    }

    public ServletContext getServletContext() {
        return new ServletContextWrapper(this.request.getServletContext());
    }

    public AsyncContext startAsync() throws IllegalStateException {
        return new AsyncContextWrapper(this.request.startAsync());
    }

    public AsyncContext startAsync(jakarta.servlet.ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
        return new AsyncContextWrapper(this.request.startAsync(org.apache.felix.http.javaxwrappers.ServletRequestWrapper.getWrapper(servletRequest), ServletResponseWrapper.getWrapper(servletResponse)));
    }

    public boolean isAsyncStarted() {
        return this.request.isAsyncStarted();
    }

    public boolean isAsyncSupported() {
        return this.request.isAsyncSupported();
    }

    public AsyncContext getAsyncContext() {
        return new AsyncContextWrapper(this.request.getAsyncContext());
    }

    public DispatcherType getDispatcherType() {
        switch (this.request.getDispatcherType()) {
            case ASYNC: {
                return DispatcherType.ASYNC;
            }
            case ERROR: {
                return DispatcherType.ERROR;
            }
            case FORWARD: {
                return DispatcherType.FORWARD;
            }
            case INCLUDE: {
                return DispatcherType.INCLUDE;
            }
            case REQUEST: {
                return DispatcherType.REQUEST;
            }
        }
        return null;
    }
}

