/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.whiteboard.tracker;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.felix.http.base.internal.jakartawrappers.ServletContextHelperWrapper;
import org.apache.felix.http.base.internal.runtime.ServletContextHelperInfo;
import org.apache.felix.http.base.internal.util.ServiceUtils;
import org.apache.felix.http.base.internal.whiteboard.WhiteboardManager;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.servlet.context.ServletContextHelper;
import org.osgi.util.tracker.ServiceTracker;

public final class JavaxServletContextHelperTracker
extends ServiceTracker<ServletContextHelper, ServiceReference<ServletContextHelper>> {
    private final WhiteboardManager contextManager;
    private final long selfBundleId;
    private final Map<Long, ServletContextHelperInfo> allInfos = new ConcurrentHashMap<Long, ServletContextHelperInfo>();

    private static Filter createFilter(BundleContext btx) {
        try {
            return btx.createFilter(String.format("(objectClass=%s)", org.osgi.service.http.context.ServletContextHelper.class.getName()));
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            return null;
        }
    }

    public JavaxServletContextHelperTracker(@NotNull BundleContext context, @NotNull WhiteboardManager manager) {
        super(context, JavaxServletContextHelperTracker.createFilter(context), null);
        this.contextManager = manager;
        this.selfBundleId = context.getBundle().getBundleId();
    }

    public void close() {
        super.close();
        this.allInfos.clear();
    }

    public final ServiceReference<ServletContextHelper> addingService(@NotNull ServiceReference<ServletContextHelper> ref) {
        this.added(ref);
        return ref;
    }

    public final void modifiedService(@NotNull ServiceReference<ServletContextHelper> ref, @NotNull ServiceReference<ServletContextHelper> service) {
        ServletContextHelperInfo newInfo = new ServletContextHelperInfo(ref);
        ServletContextHelperInfo oldInfo = this.allInfos.get(ref.getProperty("service.id"));
        if (oldInfo == null || !newInfo.isSame(oldInfo)) {
            this.removed(ref);
            this.added(ref);
        }
    }

    public final void removedService(@NotNull ServiceReference<ServletContextHelper> ref, @NotNull ServiceReference<ServletContextHelper> service) {
        this.removed(ref);
    }

    private void added(@NotNull ServiceReference<ServletContextHelper> ref) {
        JavaxServletContextHelperInfo info;
        if (ref.getBundle().getBundleId() != this.selfBundleId && this.contextManager.addContextHelper(info = new JavaxServletContextHelperInfo(ref))) {
            this.allInfos.put((Long)ref.getProperty("service.id"), info);
        }
    }

    private void removed(@NotNull ServiceReference<ServletContextHelper> ref) {
        ServletContextHelperInfo info = this.allInfos.get(ref.getProperty("service.id"));
        if (info != null) {
            this.contextManager.removeContextHelper(info);
        }
    }

    private static final class JavaxServletContextHelperInfo
    extends ServletContextHelperInfo {
        private final ServiceReference<org.osgi.service.http.context.ServletContextHelper> reference;

        public JavaxServletContextHelperInfo(ServiceReference<ServletContextHelper> ref) {
            super(ref);
            this.reference = ref;
        }

        @Override
        public ServletContextHelper getService(BundleContext bundleContext) {
            org.osgi.service.http.context.ServletContextHelper helper = ServiceUtils.safeGetServiceObjects(bundleContext, this.reference);
            if (helper == null) {
                return null;
            }
            return new ServletContextHelperWrapper(helper);
        }

        @Override
        public void ungetService(BundleContext bundleContext, ServletContextHelper service) {
            if (service instanceof ServletContextHelperWrapper) {
                org.osgi.service.http.context.ServletContextHelper helper = ((ServletContextHelperWrapper)service).getHelper();
                ServiceUtils.safeUngetServiceObjects(bundleContext, this.reference, helper);
            }
        }

        @Override
        @NotNull
        public String getServiceType() {
            return org.osgi.service.http.context.ServletContextHelper.class.getName();
        }
    }
}

