/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.registry;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import org.apache.felix.http.base.internal.handler.ServletHandler;
import org.apache.felix.http.base.internal.registry.PathResolution;
import org.apache.felix.http.base.internal.registry.PathResolver;
import org.apache.felix.http.base.internal.registry.PathResolverFactory;
import org.apache.felix.http.base.internal.runtime.ServletInfo;
import org.apache.felix.http.base.internal.runtime.dto.BuilderConstants;
import org.apache.felix.http.base.internal.runtime.dto.ResourceDTOBuilder;
import org.apache.felix.http.base.internal.runtime.dto.ServletDTOBuilder;
import org.osgi.dto.DTO;
import org.osgi.service.http.runtime.dto.FailedResourceDTO;
import org.osgi.service.http.runtime.dto.FailedServletDTO;
import org.osgi.service.http.runtime.dto.ResourceDTO;
import org.osgi.service.http.runtime.dto.ServletContextDTO;
import org.osgi.service.http.runtime.dto.ServletDTO;

public final class ServletRegistry {
    private static final String NAMED_SERVLET_PATTERN = ":::";
    private volatile List<PathResolver> activeResolvers = Collections.emptyList();
    private final Map<String, List<ServletHandler>> inactiveServletMappings = new HashMap<String, List<ServletHandler>>();
    private final Map<String, List<ServletHandler>> servletsByName = new ConcurrentHashMap<String, List<ServletHandler>>();
    private volatile Map<ServletInfo, RegistrationStatus> mapping = Collections.emptyMap();

    public PathResolution resolve(@Nonnull String relativeRequestURI) {
        List<PathResolver> resolvers = this.activeResolvers;
        for (PathResolver entry : resolvers) {
            PathResolution pr = entry.resolve(relativeRequestURI);
            if (pr == null) continue;
            pr.patterns = new String[]{entry.getPattern()};
            return pr;
        }
        return null;
    }

    private PathResolver findResolver(List<PathResolver> resolvers, String pattern) {
        for (PathResolver pr : resolvers) {
            if (!pr.getPattern().equals(pattern)) continue;
            return pr;
        }
        return null;
    }

    public synchronized void addServlet(@Nonnull ServletHandler handler) {
        if (handler.getServletInfo().getPatterns() != null) {
            TreeMap<ServletInfo, RegistrationStatus> newMap = new TreeMap<ServletInfo, RegistrationStatus>(this.mapping);
            ArrayList<PathResolver> resolvers = new ArrayList<PathResolver>(this.activeResolvers);
            RegistrationStatus status = new RegistrationStatus();
            status.handler = handler;
            boolean isActive = false;
            HashSet<String> patterns = new HashSet<String>();
            for (String pattern : handler.getServletInfo().getPatterns()) {
                if (patterns.contains(pattern)) continue;
                patterns.add(pattern);
                PathResolver regHandler = this.findResolver(resolvers, pattern);
                if (regHandler != null) {
                    if (regHandler.getServletHandler().getServletInfo().compareTo(handler.getServletInfo()) > 0) {
                        if (!this.tryToActivate(resolvers, pattern, handler, status, regHandler)) continue;
                        isActive = true;
                        String oldName = regHandler.getServletHandler().getName();
                        regHandler.getServletHandler().destroy();
                        RegistrationStatus oldStatus = (RegistrationStatus)newMap.get(regHandler.getServletHandler().getServletInfo());
                        RegistrationStatus newOldStatus = new RegistrationStatus();
                        newOldStatus.handler = oldStatus.handler;
                        newOldStatus.statusToPath = new HashMap<Integer, String[]>(oldStatus.statusToPath);
                        newMap.put(regHandler.getServletHandler().getServletInfo(), newOldStatus);
                        this.addToInactiveList(pattern, regHandler.getServletHandler(), newOldStatus);
                        if (regHandler.getServletHandler().getServlet() != null) continue;
                        this.removeFromNameMapping(oldName, regHandler.getServletHandler());
                        continue;
                    }
                    this.addToInactiveList(pattern, handler, status);
                    continue;
                }
                if (!this.tryToActivate(resolvers, pattern, handler, status, null)) continue;
                isActive = true;
            }
            newMap.put(handler.getServletInfo(), status);
            if (isActive) {
                this.addToNameMapping(handler);
            }
            Collections.sort(resolvers);
            this.activeResolvers = resolvers;
            this.mapping = newMap;
        } else if (!handler.getServletInfo().isResource() && handler.getServletInfo().getName() != null) {
            TreeMap<ServletInfo, RegistrationStatus> newMap = new TreeMap<ServletInfo, RegistrationStatus>(this.mapping);
            RegistrationStatus status = new RegistrationStatus();
            status.handler = handler;
            int result = handler.init();
            if (result == -1) {
                this.addToNameMapping(handler);
            }
            this.addPattern(status, result, NAMED_SERVLET_PATTERN);
            newMap.put(handler.getServletInfo(), status);
            this.mapping = newMap;
        }
    }

    private void addToNameMapping(ServletHandler handler) {
        if (!handler.getServletInfo().isResource()) {
            String servletName = handler.getName();
            List<ServletHandler> list = this.servletsByName.get(servletName);
            if (list == null) {
                list = new ArrayList<ServletHandler>();
                list.add(handler);
            } else {
                list = new ArrayList<ServletHandler>(list);
                list.add(handler);
                Collections.sort(list);
            }
            this.servletsByName.put(servletName, list);
        }
    }

    private void removeFromNameMapping(String servletName, ServletHandler handler) {
        List<ServletHandler> list;
        if (!handler.getServletInfo().isResource() && (list = this.servletsByName.get(servletName)) != null) {
            ArrayList<ServletHandler> newList = new ArrayList<ServletHandler>(list);
            Iterator i = newList.iterator();
            while (i.hasNext()) {
                ServletHandler s = (ServletHandler)i.next();
                if (s != handler) continue;
                i.remove();
                break;
            }
            if (newList.isEmpty()) {
                this.servletsByName.remove(servletName);
            } else {
                this.servletsByName.put(servletName, newList);
            }
        }
    }

    public synchronized void removeServlet(@Nonnull ServletInfo info, boolean destroy) {
        TreeMap<ServletInfo, RegistrationStatus> newMap;
        RegistrationStatus status;
        if (info.getPatterns() != null) {
            ArrayList<PathResolver> resolvers = new ArrayList<PathResolver>(this.activeResolvers);
            TreeMap<ServletInfo, RegistrationStatus> newMap2 = new TreeMap<ServletInfo, RegistrationStatus>(this.mapping);
            newMap2.remove(info);
            ServletHandler cleanupHandler = null;
            HashSet<String> patterns = new HashSet<String>();
            for (String pattern : info.getPatterns()) {
                ServletHandler h;
                List<ServletHandler> inactiveList;
                if (patterns.contains(pattern)) continue;
                patterns.add(pattern);
                PathResolver regHandler = this.findResolver(resolvers, pattern);
                if (regHandler != null && regHandler.getServletHandler().getServletInfo().equals(info)) {
                    cleanupHandler = regHandler.getServletHandler();
                    this.removeFromNameMapping(cleanupHandler.getName(), cleanupHandler);
                    inactiveList = this.inactiveServletMappings.get(pattern);
                    if (inactiveList == null) {
                        resolvers.remove(regHandler);
                        continue;
                    }
                    boolean done = false;
                    while (!done) {
                        h = inactiveList.remove(0);
                        boolean activate = h.getServlet() == null;
                        RegistrationStatus oldStatus = (RegistrationStatus)newMap2.get(h.getServletInfo());
                        if (oldStatus != null) {
                            RegistrationStatus newOldStatus = new RegistrationStatus();
                            newOldStatus.handler = oldStatus.handler;
                            newOldStatus.statusToPath = new HashMap<Integer, String[]>(oldStatus.statusToPath);
                            this.removePattern(newOldStatus, 3, pattern);
                            newMap2.put(h.getServletInfo(), newOldStatus);
                            done = this.tryToActivate(resolvers, pattern, h, newOldStatus, regHandler);
                            if (done && activate) {
                                this.addToNameMapping(h);
                            }
                        }
                        if (done) continue;
                        done = inactiveList.isEmpty();
                    }
                    if (!inactiveList.isEmpty()) continue;
                    this.inactiveServletMappings.remove(pattern);
                    continue;
                }
                inactiveList = this.inactiveServletMappings.get(pattern);
                if (inactiveList == null) continue;
                Iterator<ServletHandler> i = inactiveList.iterator();
                while (i.hasNext()) {
                    h = i.next();
                    if (!h.getServletInfo().equals(info)) continue;
                    i.remove();
                    cleanupHandler = h;
                    break;
                }
                if (!inactiveList.isEmpty()) continue;
                this.inactiveServletMappings.remove(pattern);
            }
            Collections.sort(resolvers);
            this.activeResolvers = resolvers;
            this.mapping = newMap2;
            if (cleanupHandler != null) {
                cleanupHandler.dispose();
            }
        } else if (!info.isResource() && info.getName() != null && (status = (RegistrationStatus)(newMap = new TreeMap<ServletInfo, RegistrationStatus>(this.mapping)).remove(info)) != null) {
            this.removeFromNameMapping(info.getName(), status.handler);
            this.mapping = newMap;
            status.handler.dispose();
        }
    }

    public synchronized void cleanup() {
        this.activeResolvers = Collections.emptyList();
        this.inactiveServletMappings.clear();
        this.servletsByName.clear();
        this.mapping = Collections.emptyMap();
    }

    private void addToInactiveList(String pattern, ServletHandler handler, RegistrationStatus status) {
        List<ServletHandler> inactiveList = this.inactiveServletMappings.get(pattern);
        if (inactiveList == null) {
            inactiveList = new ArrayList<ServletHandler>();
            this.inactiveServletMappings.put(pattern, inactiveList);
        }
        inactiveList.add(handler);
        Collections.sort(inactiveList);
        this.removePattern(status, -1, pattern);
        this.addPattern(status, 3, pattern);
    }

    private boolean tryToActivate(List<PathResolver> resolvers, String pattern, ServletHandler handler, RegistrationStatus status, PathResolver oldResolver) {
        int result = handler.init();
        if (result == -1) {
            if (oldResolver != null) {
                resolvers.remove(oldResolver);
            }
            PathResolver resolver = PathResolverFactory.createPatternMatcher(handler, pattern);
            resolvers.add(resolver);
        }
        this.addPattern(status, result, pattern);
        return result == -1;
    }

    private void addPattern(RegistrationStatus status, int failureCode, String pattern) {
        String[] paths = status.statusToPath.get(failureCode);
        if (paths == null) {
            status.statusToPath.put(failureCode, new String[]{pattern});
        } else {
            String[] newPaths = new String[paths.length + 1];
            System.arraycopy(paths, 0, newPaths, 0, paths.length);
            newPaths[paths.length] = pattern;
            status.statusToPath.put(failureCode, newPaths);
        }
    }

    private void removePattern(RegistrationStatus status, int failureCode, String pattern) {
        ArrayList<String> array;
        String[] paths = status.statusToPath.get(failureCode);
        if (paths != null && (array = new ArrayList<String>(Arrays.asList(paths))).remove(pattern)) {
            if (array.isEmpty()) {
                status.statusToPath.remove(failureCode);
            } else {
                status.statusToPath.put(failureCode, array.toArray(new String[array.size()]));
            }
        }
    }

    public ServletHandler resolveByName(@Nonnull String name) {
        List<ServletHandler> handlerList = this.servletsByName.get(name);
        if (handlerList != null) {
            return handlerList.get(0);
        }
        return null;
    }

    public void getRuntimeInfo(ServletContextDTO servletContextDTO, Collection<FailedServletDTO> allFailedServletDTOs, Collection<FailedResourceDTO> allFailedResourceDTOs) {
        Collection resourceDTOsArray;
        HashMap<Long, DTO> servletDTOs = new HashMap<Long, DTO>();
        HashMap<Long, DTO> resourceDTOs = new HashMap<Long, DTO>();
        HashMap<Long, FailedServletDTO> failedServletDTOs = new HashMap<Long, FailedServletDTO>();
        HashMap<Long, FailedResourceDTO> failedResourceDTOs = new HashMap<Long, FailedResourceDTO>();
        for (Map.Entry<ServletInfo, RegistrationStatus> entry : this.mapping.entrySet()) {
            long serviceId = entry.getKey().getServiceId();
            for (Map.Entry<Integer, String[]> map : entry.getValue().statusToPath.entrySet()) {
                DTO state;
                if (entry.getKey().isResource()) {
                    state = ResourceDTOBuilder.build(entry.getValue().handler, map.getKey());
                    state.patterns = map.getValue().length == 1 && NAMED_SERVLET_PATTERN == map.getValue()[0] ? BuilderConstants.EMPTY_STRING_ARRAY : (String[])Arrays.copyOf((Object[])map.getValue(), map.getValue().length);
                    if (map.getKey() == -1) {
                        resourceDTOs.put(serviceId, state);
                        continue;
                    }
                    failedResourceDTOs.put(serviceId, (FailedResourceDTO)state);
                    continue;
                }
                state = ServletDTOBuilder.build(entry.getValue().handler, (int)map.getKey());
                state.patterns = map.getValue().length == 1 && NAMED_SERVLET_PATTERN == map.getValue()[0] ? BuilderConstants.EMPTY_STRING_ARRAY : (String[])Arrays.copyOf((Object[])map.getValue(), map.getValue().length);
                if (map.getKey() == -1) {
                    servletDTOs.put(serviceId, state);
                    continue;
                }
                failedServletDTOs.put(serviceId, (FailedServletDTO)state);
            }
        }
        Collection servletDTOsArray = servletDTOs.values();
        if (!servletDTOsArray.isEmpty()) {
            servletContextDTO.servletDTOs = servletDTOsArray.toArray(new ServletDTO[servletDTOsArray.size()]);
        }
        if (!(resourceDTOsArray = resourceDTOs.values()).isEmpty()) {
            servletContextDTO.resourceDTOs = resourceDTOsArray.toArray(new ResourceDTO[resourceDTOsArray.size()]);
        }
        allFailedResourceDTOs.addAll(failedResourceDTOs.values());
        allFailedServletDTOs.addAll(failedServletDTOs.values());
    }

    private static final class RegistrationStatus {
        public ServletHandler handler;
        public Map<Integer, String[]> statusToPath = new HashMap<Integer, String[]>();

        private RegistrationStatus() {
        }
    }
}

