/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.dispatch;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.servlet.DispatcherType;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.felix.http.base.internal.dispatch.InvocationChain;
import org.apache.felix.http.base.internal.dispatch.RequestInfo;
import org.apache.felix.http.base.internal.dispatch.ServletRequestWrapper;
import org.apache.felix.http.base.internal.handler.FilterHandler;
import org.apache.felix.http.base.internal.handler.ServletHandler;
import org.apache.felix.http.base.internal.registry.PerContextHandlerRegistry;

final class ServletResponseWrapper
extends HttpServletResponseWrapper {
    private final HttpServletRequest request;
    private final AtomicInteger invocationCount = new AtomicInteger();
    private final PerContextHandlerRegistry errorRegistry;
    private final String servletName;

    public ServletResponseWrapper(@Nonnull HttpServletRequest req, @Nonnull HttpServletResponse res, @CheckForNull String servletName, @CheckForNull PerContextHandlerRegistry errorRegistry) {
        super(res);
        this.request = req;
        this.servletName = servletName;
        this.errorRegistry = errorRegistry;
    }

    public void sendError(int sc) throws IOException {
        this.sendError(sc, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendError(int code, String message) throws IOException {
        this.resetBuffer();
        this.setStatus(code);
        boolean invokeSuper = true;
        if (this.invocationCount.incrementAndGet() == 1 && code != 204 && code != 304 && code != 206 && code >= 200) {
            ServletHandler errorResolution;
            Throwable exception = (Throwable)this.request.getAttribute("javax.servlet.error.exception");
            ServletHandler servletHandler = errorResolution = this.errorRegistry == null ? null : this.errorRegistry.getErrorHandler(code, exception);
            if (errorResolution != null) {
                try {
                    this.request.setAttribute("javax.servlet.error.status_code", (Object)new Integer(code));
                    if (message != null) {
                        this.request.setAttribute("javax.servlet.error.message", (Object)message);
                    }
                    this.request.setAttribute("javax.servlet.error.request_uri", (Object)this.request.getRequestURI());
                    if (this.servletName != null) {
                        this.request.setAttribute("javax.servlet.error.servlet_name", (Object)this.servletName);
                    }
                    String servletPath = null;
                    String pathInfo = this.request.getRequestURI();
                    String queryString = null;
                    RequestInfo requestInfo = new RequestInfo(servletPath, pathInfo, queryString, pathInfo);
                    FilterHandler[] filterHandlers = this.errorRegistry.getFilterHandlers(errorResolution, DispatcherType.ERROR, this.request.getRequestURI());
                    ServletRequestWrapper reqWrapper = new ServletRequestWrapper(this.request, errorResolution.getContext(), requestInfo, null, errorResolution.getContextServiceId(), false);
                    InvocationChain filterChain = new InvocationChain(errorResolution, filterHandlers);
                    filterChain.doFilter((ServletRequest)reqWrapper, (ServletResponse)this);
                    invokeSuper = false;
                }
                catch (ServletException e) {
                }
                finally {
                    this.request.removeAttribute("javax.servlet.error.status_code");
                    this.request.removeAttribute("javax.servlet.error.message");
                    this.request.removeAttribute("javax.servlet.error.request_uri");
                    this.request.removeAttribute("javax.servlet.error.servlet_name");
                    this.request.removeAttribute("javax.servlet.error.exception");
                    this.request.removeAttribute("javax.servlet.error.exception_type");
                }
            }
        }
        if (invokeSuper) {
            super.sendError(code, message);
        }
    }
}

