/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal;

import java.util.Hashtable;
import javax.annotation.Nonnull;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionIdListener;
import javax.servlet.http.HttpSessionListener;
import org.apache.felix.http.base.internal.EventDispatcher;
import org.apache.felix.http.base.internal.dispatch.Dispatcher;
import org.apache.felix.http.base.internal.dispatch.DispatcherServlet;
import org.apache.felix.http.base.internal.handler.HttpSessionWrapper;
import org.apache.felix.http.base.internal.registry.HandlerRegistry;
import org.apache.felix.http.base.internal.service.HttpServiceFactory;
import org.apache.felix.http.base.internal.whiteboard.WhiteboardManager;
import org.osgi.framework.BundleContext;

public final class HttpServiceController {
    private final BundleContext bundleContext;
    private final HandlerRegistry registry;
    private final Dispatcher dispatcher;
    private final EventDispatcher eventDispatcher;
    private final HttpServiceFactory httpServiceFactory;
    private final WhiteboardManager whiteboardManager;
    private volatile HttpSessionListener httpSessionListener;

    public HttpServiceController(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.registry = new HandlerRegistry();
        this.dispatcher = new Dispatcher(this.registry);
        this.eventDispatcher = new EventDispatcher(this);
        this.httpServiceFactory = new HttpServiceFactory(this.bundleContext, this.registry);
        this.whiteboardManager = new WhiteboardManager(bundleContext, this.httpServiceFactory, this.registry);
    }

    public void stop() {
        this.unregister();
    }

    @Nonnull
    public Servlet createDispatcherServlet() {
        return new DispatcherServlet(this.dispatcher);
    }

    public EventDispatcher getEventDispatcher() {
        return this.eventDispatcher;
    }

    HttpSessionListener getSessionListener() {
        if (this.httpSessionListener == null) {
            this.httpSessionListener = new HttpSessionListener(){

                public void sessionDestroyed(HttpSessionEvent se) {
                    HttpServiceController.this.httpServiceFactory.getSessionListener().sessionDestroyed(se);
                    HttpServiceController.this.whiteboardManager.sessionDestroyed(se.getSession(), HttpSessionWrapper.getSessionContextIds(se.getSession()));
                }

                public void sessionCreated(HttpSessionEvent se) {
                    HttpServiceController.this.httpServiceFactory.getSessionListener().sessionCreated(se);
                }
            };
        }
        return this.httpSessionListener;
    }

    HttpSessionAttributeListener getSessionAttributeListener() {
        return this.httpServiceFactory.getSessionAttributeListener();
    }

    HttpSessionIdListener getSessionIdListener() {
        return new HttpSessionIdListener(){

            public void sessionIdChanged(HttpSessionEvent event, String oldSessionId) {
                HttpServiceController.this.whiteboardManager.sessionIdChanged(event, oldSessionId, HttpSessionWrapper.getSessionContextIds(event.getSession()));
            }
        };
    }

    public void register(@Nonnull ServletContext containerContext, @Nonnull Hashtable<String, Object> props) {
        this.registry.init();
        this.httpServiceFactory.start(containerContext, props);
        this.whiteboardManager.start(containerContext, props);
        this.dispatcher.setWhiteboardManager(this.whiteboardManager);
    }

    public void unregister() {
        this.dispatcher.setWhiteboardManager(null);
        this.httpServiceFactory.stop();
        this.whiteboardManager.stop();
        this.registry.shutdown();
        this.httpSessionListener = null;
    }
}

