/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.hc.webconsole.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.hc.api.FormattingResultLog;
import org.apache.felix.hc.api.HealthCheck;
import org.apache.felix.hc.api.Result;
import org.apache.felix.hc.api.ResultLog;
import org.apache.felix.hc.api.execution.HealthCheckExecutionOptions;
import org.apache.felix.hc.api.execution.HealthCheckExecutionResult;
import org.apache.felix.hc.api.execution.HealthCheckExecutor;
import org.apache.felix.hc.api.execution.HealthCheckMetadata;
import org.apache.felix.hc.api.execution.HealthCheckSelector;
import org.apache.felix.hc.webconsole.impl.WebConsoleHelper;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={Servlet.class}, property={"service.description=Apache Felix Health Check Web Console Plugin", "felix.webconsole.label=healthcheck", "felix.webconsole.title=Health Check", "felix.webconsole.category=Main", "felix.webconsole.css=/healthcheck/res/ui/healthcheck.css"})
public class HealthCheckWebconsolePlugin
extends HttpServlet {
    public static final String TITLE = "Health Check";
    public static final String LABEL = "healthcheck";
    public static final String CATEGORY = "Main";
    public static final String PARAM_TAGS = "tags";
    public static final String PARAM_DEBUG = "debug";
    public static final String PARAM_QUIET = "quiet";
    public static final String PARAM_SHOWLIST = "showList";
    public static final String PARAM_FORCE_INSTANT_EXECUTION = "forceInstantExecution";
    public static final String PARAM_COMBINE_TAGS_WITH_OR = "combineTagsWithOr";
    public static final String PARAM_OVERRIDE_GLOBAL_TIMEOUT = "overrideGlobalTimeout";
    public static final String HC_FILTER_OBJECT_CLASS = "(|(objectClass=" + HealthCheck.class.getName() + ")(objectClass=org.apache.sling.hc.api.HealthCheck))";
    @Reference
    private HealthCheckExecutor healthCheckExecutor;
    private BundleContext bundleContext;

    @Activate
    protected void activate(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getStaticResource(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String pathInfo = req.getPathInfo();
        if (pathInfo != null && pathInfo.contains("res/ui")) {
            String prefix = "/healthcheck";
            InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream(pathInfo.substring("/healthcheck".length()));
            if (is == null) {
                resp.sendError(404, pathInfo);
            } else {
                ServletOutputStream os = resp.getOutputStream();
                try {
                    byte[] buffer = new byte[16384];
                    int n = 0;
                    while ((n = is.read(buffer, 0, buffer.length)) > 0) {
                        os.write(buffer, 0, n);
                    }
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return true;
        }
        return false;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.getStaticResource(req, resp)) {
            return;
        }
        String tags = this.getParam(req, PARAM_TAGS, null);
        boolean debug = Boolean.valueOf(this.getParam(req, PARAM_DEBUG, "false"));
        boolean quiet = Boolean.valueOf(this.getParam(req, PARAM_QUIET, "false"));
        boolean combineTagsWithOr = Boolean.valueOf(this.getParam(req, PARAM_COMBINE_TAGS_WITH_OR, "false"));
        boolean forceInstantExecution = Boolean.valueOf(this.getParam(req, PARAM_FORCE_INSTANT_EXECUTION, "false"));
        String overrideGlobalTimeoutStr = this.getParam(req, PARAM_OVERRIDE_GLOBAL_TIMEOUT, "");
        PrintWriter pw = resp.getWriter();
        if (Boolean.valueOf(req.getParameter(PARAM_SHOWLIST)).booleanValue()) {
            this.doHealthCheckList(pw);
            return;
        }
        this.doForm(pw, tags, debug, quiet, combineTagsWithOr, forceInstantExecution, overrideGlobalTimeoutStr);
        if (tags != null) {
            HealthCheckExecutionOptions options = new HealthCheckExecutionOptions();
            options.setCombineTagsWithOr(combineTagsWithOr);
            options.setForceInstantExecution(forceInstantExecution);
            try {
                options.setOverrideGlobalTimeout(Integer.valueOf(overrideGlobalTimeoutStr).intValue());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            HealthCheckSelector selector = !HealthCheckWebconsolePlugin.isBlank(tags) ? HealthCheckSelector.tags((String[])tags.split(",")) : HealthCheckSelector.empty();
            List results = this.healthCheckExecutor.execute(selector, options);
            pw.println("<table class='content healthcheck' cellpadding='0' cellspacing='0' width='100%'>");
            int total = 0;
            int failed = 0;
            for (HealthCheckExecutionResult exR : results) {
                Result r = exR.getHealthCheckResult();
                ++total;
                if (!r.isOk()) {
                    ++failed;
                }
                if (quiet && r.isOk()) continue;
                this.renderResult(pw, exR, debug);
            }
            WebConsoleHelper c = new WebConsoleHelper(resp.getWriter());
            c.titleHtml("Summary", total + " HealthCheck executed, " + failed + " failures");
            pw.println("</table>");
            pw.println("<br/><br/>");
        }
    }

    private static boolean isBlank(CharSequence cs) {
        return cs == null || cs.chars().allMatch(Character::isWhitespace);
    }

    void renderResult(PrintWriter pw, HealthCheckExecutionResult exResult, boolean debug) throws IOException {
        Result result = exResult.getHealthCheckResult();
        WebConsoleHelper c = new WebConsoleHelper(pw);
        StringBuilder status = new StringBuilder();
        status.append("Tags: ").append(exResult.getHealthCheckMetadata().getTags());
        status.append(" Finished: ").append(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(exResult.getFinishedAt()) + " after " + FormattingResultLog.msHumanReadable((long)exResult.getElapsedTimeInMs()));
        c.titleHtml(exResult.getHealthCheckMetadata().getTitle(), null);
        c.tr();
        c.tdContent();
        c.writer().print(c.escapeHtml(status.toString()));
        c.writer().print("<br/>Result: <span class='resultOk");
        c.writer().print(result.isOk());
        c.writer().print("'>");
        c.writer().print(result.getStatus().toString());
        c.writer().print("</span>");
        c.closeTd();
        c.closeTr();
        c.tr();
        c.tdContent();
        for (ResultLog.Entry e : result) {
            if (!debug && e.isDebug()) continue;
            c.writer().print("<div class='log");
            c.writer().print(e.isDebug() ? "DEBUG" : e.getStatus().toString());
            c.writer().print("'>");
            c.writer().print(e.getStatus().toString());
            c.writer().print(' ');
            c.writer().print(c.escapeHtml(e.getMessage()));
            if (e.getException() != null) {
                c.writer().print(" ");
                c.writer().print(c.escapeHtml(e.getException().toString()));
            }
            c.writer().println("</div>");
        }
        c.closeTd();
    }

    private void doHealthCheckList(PrintWriter pw) throws IOException {
        try {
            ServiceReference[] serviceReferences;
            pw.println("<br/>");
            pw.println("<table id=\"healthCheckList\" class=\"tablesorter nicetable\">");
            pw.println("<thead><tr><th>Name</th><th>Tags</th><th>Properties</th><th>Links</th><th>Bundle</th></thead><tbody>");
            for (ServiceReference serviceReference : serviceReferences = this.bundleContext.getServiceReferences((String)null, HC_FILTER_OBJECT_CLASS)) {
                HealthCheckMetadata metadata = new HealthCheckMetadata(serviceReference);
                pw.println("<tr>");
                pw.println("<td>" + metadata.getTitle() + "</td>");
                pw.println("<td>");
                for (String tag : metadata.getTags()) {
                    String[] link = "healthcheck?tags=" + tag;
                    pw.println("<a href=\"" + (String)link + "\">" + tag + "</a><br/>");
                }
                pw.println("</td>");
                ArrayList<String> links = new ArrayList<String>();
                pw.println("<td>");
                String[] propertyKeys = serviceReference.getPropertyKeys();
                if (propertyKeys != null) {
                    for (String propertyKey : propertyKeys) {
                        String link;
                        if (propertyKey.equals("hc.name") || propertyKey.equals("hc.tags") || propertyKey.equals("objectClass") || propertyKey.equals("component.id")) continue;
                        List<Object> value = serviceReference.getProperty(propertyKey);
                        if (value.getClass().isArray()) {
                            value = Arrays.asList((Object[])value);
                        }
                        if ("hc.mbean.name".equals(propertyKey)) {
                            link = "jmx/org.apache.felix.healthcheck%3Aname%3D" + value + "%2Ctype%3DHealthCheck";
                            links.add("<a href=\"" + link + "\">JMX Bean " + value + "</a>");
                            continue;
                        }
                        if ("component.name".equals(propertyKey)) {
                            link = "components/" + value;
                            links.add("<a href=\"" + link + "\">Component " + value + "</a>");
                            continue;
                        }
                        if ("service.id".equals(propertyKey)) {
                            link = "services/" + value;
                            links.add("<a href=\"" + link + "\">Service " + value + "</a>");
                            continue;
                        }
                        if (propertyKey.startsWith("service.")) continue;
                        pw.println(propertyKey + " = " + value + "<br/>");
                    }
                }
                pw.println("</td>");
                pw.println("<td>" + String.join((CharSequence)"<br/>", links) + "</td>");
                pw.println("<td>");
                String symbolicBundleName = serviceReference.getBundle().getSymbolicName();
                String link = "bundles/" + symbolicBundleName;
                pw.println("<a href=\"" + link + "\">" + symbolicBundleName + "</a><br/>");
                pw.println("</td>");
                pw.println("</tr>");
            }
            pw.println("</thead></table>");
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalStateException("Could not render list of health checks: " + (Object)((Object)e), e);
        }
    }

    private void doForm(PrintWriter pw, String tags, boolean debug, boolean quiet, boolean combineTagsWithOr, boolean forceInstantExecution, String overrideGlobalTimeoutStr) throws IOException {
        WebConsoleHelper c = new WebConsoleHelper(pw);
        pw.print("<form method='get'>");
        pw.println("<table class='content' cellpadding='0' cellspacing='0' width='100%'>");
        c.titleHtml(TITLE, "Enter tags to selected health checks to be executed. Leave empty to execute default checks or use '*' to execute all checks. Prefix a tag with a minus sign (-) to omit checks having that tag (can be also used in combination with '*', e.g. '*,-excludedtag').");
        c.tr();
        c.tdLabel("Health Check Tags (comma-separated)");
        c.tdContent();
        c.writer().print("<input type='text' name='tags' value='");
        if (tags != null) {
            c.writer().print(c.escapeHtml(tags));
        }
        c.writer().println("' class='input' size='80'> <a href='healthcheck?showList=true'>Show list</a>");
        c.closeTd();
        c.closeTr();
        c.tr();
        c.tdLabel("");
        c.tdContent();
        c.writer().print("<table id='settingsTable'>");
        c.writer().print("<tr>");
        c.writer().print("<td>");
        c.writer().print("<input type='checkbox' name='combineTagsWithOr' class='input' value='true'");
        if (combineTagsWithOr) {
            c.writer().print(" checked=true");
        }
        c.writer().println(">");
        c.writer().print("</td>");
        c.writer().print("<td>Combine tags with logical 'OR' instead of the default 'AND'</td>");
        c.writer().print("<td>");
        c.writer().print("<input type='checkbox' name='debug' class='input' value='true'");
        if (debug) {
            c.writer().print(" checked=true");
        }
        c.writer().println(">");
        c.writer().print("</td>");
        c.writer().print("<td>Show DEBUG logs</td>");
        c.writer().print("</tr>");
        c.writer().print("<tr>");
        c.writer().print("<td>");
        c.writer().print("<input type='checkbox' name='quiet' class='input' value='true'");
        if (quiet) {
            c.writer().print(" checked=true");
        }
        c.writer().println(">");
        c.writer().print("</td>");
        c.writer().print("<td>Show failed checks only</td>");
        c.writer().print("<td>");
        c.writer().print("<input type='checkbox' name='forceInstantExecution' class='input' value='true'");
        if (forceInstantExecution) {
            c.writer().print(" checked=true");
        }
        c.writer().println(">");
        c.writer().print("</td>");
        c.writer().print("<td>Force instant execution (no cache, async checks are executed)</td>");
        c.writer().print("</tr>");
        c.writer().print("<tr>");
        c.writer().print("<td colspan='4'>Override global timeout ");
        c.writer().print("<input type='text' name='overrideGlobalTimeout' value='");
        if (overrideGlobalTimeoutStr != null) {
            c.writer().print(c.escapeHtml(overrideGlobalTimeoutStr));
        }
        c.writer().println("' class='input' size='10'> ms");
        c.writer().print("</td>");
        c.writer().print("</tr>");
        c.writer().print("</table>");
        c.closeTd();
        c.closeTr();
        c.tr();
        c.tdLabel("");
        c.tdContent();
        c.writer().println("<input type='submit' value=' Execute '/>  <a href='configMgr/org.apache.felix.hc.core.impl.executor.HealthCheckExecutorImpl'>Configure executor</a>");
        c.closeTd();
        c.closeTr();
        c.writer().println("</table></form>");
    }

    private String getParam(HttpServletRequest req, String name, String defaultValue) {
        String result = req.getParameter(name);
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }
}

