/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.fileinstall.internal;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import org.osgi.framework.Bundle;

class Jar {
    private String path;
    private long lastModified = -1L;
    private long bundleId = -1L;

    Jar(File file) {
        this.path = file.toURI().normalize().getPath();
        this.lastModified = file.lastModified();
    }

    Jar(Bundle b) throws URISyntaxException {
        String location = b.getLocation();
        if (location != null && !location.equals("System Bundle")) {
            URI uri;
            try {
                uri = new URI(b.getLocation()).normalize();
            }
            catch (URISyntaxException e) {
                uri = new File(location).toURI().normalize();
            }
            this.path = uri.getPath();
        }
        this.lastModified = b.getLastModified();
        this.bundleId = b.getBundleId();
    }

    public String getPath() {
        return this.path;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public long getBundleId() {
        return this.bundleId;
    }

    public boolean isNewer(Jar other) {
        return this.getLastModified() > other.getLastModified();
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Jar) {
            return this.path.equals(((Jar)obj).path);
        }
        return false;
    }
}

