/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.fileinstall.internal;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.felix.fileinstall.ArtifactListener;
import org.apache.felix.fileinstall.internal.BundleTransformer;
import org.apache.felix.fileinstall.internal.ConfigInstaller;
import org.apache.felix.fileinstall.internal.DirectoryWatcher;
import org.apache.felix.fileinstall.internal.Util;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.startlevel.StartLevel;
import org.osgi.util.tracker.ServiceTracker;

public class FileInstall
implements BundleActivator,
ManagedServiceFactory {
    static ServiceTracker padmin;
    static ServiceTracker startLevel;
    static ServiceTracker cmTracker;
    static List listeners;
    BundleContext context;
    Map watchers = new HashMap();
    ConfigInstaller configInstaller;
    ServiceTracker listenersTracker;
    static /* synthetic */ Class class$org$osgi$service$cm$ManagedServiceFactory;
    static /* synthetic */ Class class$org$osgi$service$packageadmin$PackageAdmin;
    static /* synthetic */ Class class$org$osgi$service$startlevel$StartLevel;
    static /* synthetic */ Class class$org$osgi$service$cm$ConfigurationAdmin;
    static /* synthetic */ Class class$org$apache$felix$fileinstall$ArtifactInstaller;
    static /* synthetic */ Class class$org$apache$felix$fileinstall$ArtifactTransformer;

    public void start(BundleContext context) throws Exception {
        this.context = context;
        this.addListener(new BundleTransformer());
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("service.pid", this.getName());
        context.registerService((class$org$osgi$service$cm$ManagedServiceFactory == null ? (class$org$osgi$service$cm$ManagedServiceFactory = FileInstall.class$("org.osgi.service.cm.ManagedServiceFactory")) : class$org$osgi$service$cm$ManagedServiceFactory).getName(), (Object)this, props);
        padmin = new ServiceTracker(context, (class$org$osgi$service$packageadmin$PackageAdmin == null ? (class$org$osgi$service$packageadmin$PackageAdmin = FileInstall.class$("org.osgi.service.packageadmin.PackageAdmin")) : class$org$osgi$service$packageadmin$PackageAdmin).getName(), null);
        padmin.open();
        startLevel = new ServiceTracker(context, (class$org$osgi$service$startlevel$StartLevel == null ? (class$org$osgi$service$startlevel$StartLevel = FileInstall.class$("org.osgi.service.startlevel.StartLevel")) : class$org$osgi$service$startlevel$StartLevel).getName(), null);
        startLevel.open();
        cmTracker = new ServiceTracker(context, (class$org$osgi$service$cm$ConfigurationAdmin == null ? (class$org$osgi$service$cm$ConfigurationAdmin = FileInstall.class$("org.osgi.service.cm.ConfigurationAdmin")) : class$org$osgi$service$cm$ConfigurationAdmin).getName(), null){

            public Object addingService(ServiceReference serviceReference) {
                ConfigurationAdmin cm = (ConfigurationAdmin)super.addingService(serviceReference);
                FileInstall.this.configInstaller = new ConfigInstaller(this.context);
                FileInstall.this.addListener(FileInstall.this.configInstaller);
                return cm;
            }

            public void removedService(ServiceReference serviceReference, Object o) {
                FileInstall.this.configInstaller = null;
                FileInstall.this.removeListener(FileInstall.this.configInstaller);
                super.removedService(serviceReference, o);
            }
        };
        cmTracker.open();
        String flt = "(|(objectClass=" + (class$org$apache$felix$fileinstall$ArtifactInstaller == null ? (class$org$apache$felix$fileinstall$ArtifactInstaller = FileInstall.class$("org.apache.felix.fileinstall.ArtifactInstaller")) : class$org$apache$felix$fileinstall$ArtifactInstaller).getName() + ")" + "(" + "objectClass" + "=" + (class$org$apache$felix$fileinstall$ArtifactTransformer == null ? (class$org$apache$felix$fileinstall$ArtifactTransformer = FileInstall.class$("org.apache.felix.fileinstall.ArtifactTransformer")) : class$org$apache$felix$fileinstall$ArtifactTransformer).getName() + "))";
        this.listenersTracker = new ServiceTracker(context, FrameworkUtil.createFilter((String)flt), null){

            public Object addingService(ServiceReference serviceReference) {
                ArtifactListener listener = (ArtifactListener)super.addingService(serviceReference);
                FileInstall.this.addListener(listener);
                return listener;
            }

            public void removedService(ServiceReference serviceReference, Object o) {
                FileInstall.this.removeListener((ArtifactListener)o);
            }
        };
        this.listenersTracker.open();
        Hashtable ht = new Hashtable();
        this.set(ht, "felix.fileinstall.poll");
        this.set(ht, "felix.fileinstall.dir");
        this.set(ht, "felix.fileinstall.debug");
        this.set(ht, "felix.fileinstall.filter");
        this.set(ht, "felix.fileinstall.tmpdir");
        this.set(ht, "felix.fileinstall.bundles.new.start");
        this.updated("initial", ht);
    }

    private void set(Hashtable ht, String key) {
        String o = this.context.getProperty(key);
        if (o == null && (o = System.getProperty(key.toUpperCase().replace('.', '_'))) == null) {
            return;
        }
        ht.put(key, o);
    }

    public void stop(BundleContext context) throws Exception {
        Iterator w = this.watchers.values().iterator();
        while (w.hasNext()) {
            try {
                DirectoryWatcher dir = (DirectoryWatcher)w.next();
                w.remove();
                dir.close();
            }
            catch (Exception exception) {}
        }
        this.listenersTracker.close();
        cmTracker.close();
        padmin.close();
    }

    public void deleted(String pid) {
        DirectoryWatcher watcher = (DirectoryWatcher)this.watchers.remove(pid);
        if (watcher != null) {
            watcher.close();
        }
    }

    public String getName() {
        return "org.apache.felix.fileinstall";
    }

    public void updated(String pid, Dictionary properties) throws ConfigurationException {
        this.deleted(pid);
        Util.performSubstitution(properties);
        DirectoryWatcher watcher = new DirectoryWatcher(properties, this.context);
        this.watchers.put(pid, watcher);
        watcher.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addListener(ArtifactListener listener) {
        List list = listeners;
        synchronized (list) {
            listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeListener(ArtifactListener listener) {
        List list = listeners;
        synchronized (list) {
            listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List getListeners() {
        List list = listeners;
        synchronized (list) {
            return new ArrayList(listeners);
        }
    }

    static PackageAdmin getPackageAdmin() {
        return FileInstall.getPackageAdmin(10000L);
    }

    static PackageAdmin getPackageAdmin(long timeout) {
        try {
            return (PackageAdmin)padmin.waitForService(timeout);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    static StartLevel getStartLevel() {
        return FileInstall.getStartLevel(10000L);
    }

    static StartLevel getStartLevel(long timeout) {
        try {
            return (StartLevel)startLevel.waitForService(timeout);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    static ConfigurationAdmin getConfigurationAdmin() {
        return FileInstall.getConfigurationAdmin(10000L);
    }

    static ConfigurationAdmin getConfigurationAdmin(long timeout) {
        try {
            return (ConfigurationAdmin)cmTracker.waitForService(timeout);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        listeners = new ArrayList();
    }
}

