/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.eventadmin.impl.tasks;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.felix.eventadmin.impl.handler.EventHandlerProxy;
import org.apache.felix.eventadmin.impl.tasks.DefaultThreadPool;
import org.apache.felix.eventadmin.impl.tasks.SyncDeliverTasks;
import org.osgi.service.event.Event;

public class AsyncDeliverTasks {
    private final DefaultThreadPool m_pool;
    private final SyncDeliverTasks m_deliver_task;
    private final Map<Long, TaskExecuter> m_running_threads = new ConcurrentHashMap<Long, TaskExecuter>();

    public AsyncDeliverTasks(DefaultThreadPool pool, SyncDeliverTasks deliverTask) {
        this.m_pool = pool;
        this.m_deliver_task = deliverTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Collection<EventHandlerProxy> tasks, Event event) {
        TaskInfo info = new TaskInfo(tasks, event);
        Long currentThreadId = Thread.currentThread().getId();
        TaskExecuter executer = this.m_running_threads.get(currentThreadId);
        if (executer == null) {
            executer = new TaskExecuter(currentThreadId, this.m_running_threads);
        }
        TaskExecuter taskExecuter = executer;
        synchronized (taskExecuter) {
            executer.add(info);
            if (!executer.isActive()) {
                executer.setSyncDeliverTasks(this.m_deliver_task);
                if (!this.m_pool.executeTask(executer)) {
                    executer.run();
                }
                this.m_running_threads.put(currentThreadId, executer);
            }
        }
    }

    private static final class TaskInfo {
        public final Collection<EventHandlerProxy> tasks;
        public final Event event;
        public TaskInfo next;

        public TaskInfo(Collection<EventHandlerProxy> tasks, Event event) {
            this.tasks = tasks;
            this.event = event;
        }
    }

    private static final class TaskExecuter
    implements Runnable {
        private volatile TaskInfo first;
        private volatile TaskInfo last;
        private volatile SyncDeliverTasks m_deliver_task;
        private final Map<Long, TaskExecuter> m_running_threads;
        private final long threadId;

        public TaskExecuter(long threadId, Map<Long, TaskExecuter> runningThreads) {
            this.m_running_threads = runningThreads;
            this.threadId = threadId;
        }

        public boolean isActive() {
            return this.m_deliver_task != null;
        }

        public void setSyncDeliverTasks(SyncDeliverTasks syncDeliverTasks) {
            this.m_deliver_task = syncDeliverTasks;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean running;
            do {
                TaskInfo info = null;
                TaskExecuter taskExecuter = this;
                synchronized (taskExecuter) {
                    info = this.first;
                    this.first = info.next;
                    if (this.first == null) {
                        this.last = null;
                    }
                }
                this.m_deliver_task.execute(info.tasks, info.event, true);
                taskExecuter = this;
                synchronized (taskExecuter) {
                    boolean bl = running = this.first != null;
                    if (!running) {
                        this.m_deliver_task = null;
                        this.m_running_threads.remove(this.threadId);
                    }
                }
            } while (running);
        }

        public void add(TaskInfo info) {
            if (this.first == null) {
                this.first = info;
                this.last = info;
            } else {
                this.last.next = info;
                this.last = info;
            }
        }
    }
}

