/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.apache.felix.dm.Component;
import org.apache.felix.dm.ComponentDeclaration;
import org.apache.felix.dm.ServiceDependency;
import org.apache.felix.dm.context.AbstractDependency;
import org.apache.felix.dm.context.DependencyContext;
import org.apache.felix.dm.context.Event;
import org.apache.felix.dm.context.EventType;
import org.apache.felix.dm.impl.CallbackTypeDef;
import org.apache.felix.dm.impl.DefaultNullObject;
import org.apache.felix.dm.impl.InvocationUtil;
import org.apache.felix.dm.impl.ServiceEventImpl;
import org.apache.felix.dm.tracker.ServiceTracker;
import org.apache.felix.dm.tracker.ServiceTrackerCustomizer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class ServiceDependencyImpl
extends AbstractDependency<ServiceDependency>
implements ServiceDependency,
ServiceTrackerCustomizer {
    protected volatile ServiceTracker m_tracker;
    protected volatile String m_swap;
    protected volatile Class<?> m_trackedServiceName;
    private volatile String m_trackedServiceFilter;
    private volatile String m_trackedServiceFilterUnmodified;
    private volatile ServiceReference m_trackedServiceReference;
    private volatile Object m_defaultImplementation;
    private volatile Object m_defaultImplementationInstance;
    private volatile Object m_nullObject;
    private volatile boolean m_debug = false;
    private volatile String m_debugKey;
    private volatile long m_trackedServiceReferenceId;

    @Override
    public ServiceDependency setDebug(String debugKey) {
        this.m_debugKey = debugKey;
        this.m_debug = true;
        return this;
    }

    public ServiceDependencyImpl() {
    }

    public ServiceDependencyImpl(ServiceDependencyImpl prototype) {
        super(prototype);
        this.m_trackedServiceName = prototype.m_trackedServiceName;
        this.m_nullObject = prototype.m_nullObject;
        this.m_trackedServiceFilter = prototype.m_trackedServiceFilter;
        this.m_trackedServiceFilterUnmodified = prototype.m_trackedServiceFilterUnmodified;
        this.m_trackedServiceReference = prototype.m_trackedServiceReference;
        this.m_autoConfigInstance = prototype.m_autoConfigInstance;
        this.m_defaultImplementation = prototype.m_defaultImplementation;
        this.m_autoConfig = prototype.m_autoConfig;
    }

    @Override
    public ServiceDependency setCallbacks(Object instance, String added, String changed, String removed, String swapped) {
        this.setCallbacks(instance, added, changed, removed);
        this.m_swap = swapped;
        return this;
    }

    @Override
    public ServiceDependency setCallbacks(String added, String changed, String removed, String swapped) {
        this.setCallbacks(added, changed, removed);
        this.m_swap = swapped;
        return this;
    }

    @Override
    public ServiceDependency setDefaultImplementation(Object implementation) {
        this.ensureNotActive();
        this.m_defaultImplementation = implementation;
        return this;
    }

    @Override
    public ServiceDependency setService(Class<?> serviceName) {
        this.setService(serviceName, null, null);
        return this;
    }

    @Override
    public ServiceDependency setService(Class<?> serviceName, String serviceFilter) {
        this.setService(serviceName, null, serviceFilter);
        return this;
    }

    @Override
    public ServiceDependency setService(String serviceFilter) {
        if (serviceFilter == null) {
            throw new IllegalArgumentException("Service filter cannot be null.");
        }
        this.setService(null, null, serviceFilter);
        return this;
    }

    @Override
    public ServiceDependency setService(Class<?> serviceName, ServiceReference serviceReference) {
        this.setService(serviceName, serviceReference, null);
        return this;
    }

    @Override
    public void start() {
        if (this.m_trackedServiceName != null) {
            BundleContext ctx = this.m_component.getBundleContext();
            if (this.m_trackedServiceFilter != null) {
                try {
                    this.m_tracker = new ServiceTracker(ctx, ctx.createFilter(this.m_trackedServiceFilter), (ServiceTrackerCustomizer)this);
                }
                catch (InvalidSyntaxException e) {
                    throw new IllegalStateException("Invalid filter definition for dependency: " + this.m_trackedServiceFilter);
                }
            } else {
                this.m_tracker = this.m_trackedServiceReference != null ? new ServiceTracker(ctx, this.m_trackedServiceReference, (ServiceTrackerCustomizer)this) : new ServiceTracker(ctx, this.m_trackedServiceName.getName(), (ServiceTrackerCustomizer)this);
            }
        } else {
            throw new IllegalStateException("Could not create tracker for dependency, no service name specified.");
        }
        if (this.m_debug) {
            this.m_tracker.setDebug(this.m_debugKey);
        }
        this.m_tracker.open();
        super.start();
    }

    @Override
    public void stop() {
        this.m_tracker.close();
        this.m_tracker = null;
        super.stop();
    }

    @Override
    public Object addingService(ServiceReference reference) {
        try {
            return this.m_component.getBundleContext().getService(reference);
        }
        catch (IllegalStateException e) {
            if (this.m_component.isActive()) {
                this.m_component.getLogger().warn("could not handle service dependency for component %s", e, this.m_component.getComponentDeclaration().getClassName());
            }
            return null;
        }
    }

    @Override
    public void addedService(ServiceReference reference, Object service) {
        if (this.m_debug) {
            System.out.println(String.valueOf(this.m_debugKey) + " addedService: ref=" + reference + ", service=" + service);
        }
        this.m_component.handleEvent(this, EventType.ADDED, new ServiceEventImpl(this.m_component.getBundle(), this.m_component.getBundleContext(), reference, service));
    }

    @Override
    public void modifiedService(ServiceReference reference, Object service) {
        this.m_component.handleEvent(this, EventType.CHANGED, new ServiceEventImpl(this.m_component.getBundle(), this.m_component.getBundleContext(), reference, service));
    }

    @Override
    public void removedService(ServiceReference reference, Object service) {
        this.m_component.handleEvent(this, EventType.REMOVED, new ServiceEventImpl(this.m_component.getBundle(), this.m_component.getBundleContext(), reference, service));
    }

    @Override
    public void invokeCallback(EventType type, Event ... events) {
        switch (type) {
            case ADDED: {
                if (this.m_add == null) break;
                this.invoke(this.m_add, events[0], this.getInstances());
                break;
            }
            case CHANGED: {
                if (this.m_change == null) break;
                this.invoke(this.m_change, events[0], this.getInstances());
                break;
            }
            case REMOVED: {
                if (this.m_remove == null) break;
                this.invoke(this.m_remove, events[0], this.getInstances());
                break;
            }
            case SWAPPED: {
                if (this.m_swap == null) break;
                ServiceEventImpl oldE = (ServiceEventImpl)events[0];
                ServiceEventImpl newE = (ServiceEventImpl)events[1];
                this.invokeSwap(this.m_swap, oldE.getReference(), oldE.getEvent(), newE.getReference(), newE.getEvent(), this.getInstances());
            }
        }
    }

    @Override
    public Class<?> getAutoConfigType() {
        return this.m_trackedServiceName;
    }

    @Override
    public DependencyContext createCopy() {
        return new ServiceDependencyImpl(this);
    }

    @Override
    public String getName() {
        StringBuilder sb = new StringBuilder();
        if (this.m_trackedServiceName != null) {
            sb.append(this.m_trackedServiceName.getName());
            if (this.m_trackedServiceFilterUnmodified != null) {
                sb.append(' ');
                sb.append(this.m_trackedServiceFilterUnmodified);
            }
        }
        if (this.m_trackedServiceReference != null) {
            sb.append("{service.id=" + this.m_trackedServiceReference.getProperty("service.id") + "}");
        }
        return sb.toString();
    }

    @Override
    public String getSimpleName() {
        if (this.m_trackedServiceName != null) {
            return this.m_trackedServiceName.getName();
        }
        return null;
    }

    @Override
    public String getFilter() {
        if (this.m_trackedServiceFilterUnmodified != null) {
            return this.m_trackedServiceFilterUnmodified;
        }
        if (this.m_trackedServiceReference != null) {
            return "(" + "service.id" + "=" + String.valueOf(this.m_trackedServiceReferenceId) + ")";
        }
        return null;
    }

    @Override
    public String getType() {
        return "service";
    }

    @Override
    public Dictionary<String, Object> getProperties() {
        ServiceEventImpl se = (ServiceEventImpl)this.m_component.getDependencyEvent(this);
        if (se != null) {
            if (this.m_propagateCallbackInstance != null && this.m_propagateCallbackMethod != null) {
                try {
                    CallbackTypeDef callbackInfo = new CallbackTypeDef(new Class[][]{{ServiceReference.class, Object.class}, {ServiceReference.class}}, new Object[][]{{se.getReference(), se.getEvent()}, {se.getReference()}});
                    return (Dictionary)InvocationUtil.invokeCallbackMethod(this.m_propagateCallbackInstance, this.m_propagateCallbackMethod, callbackInfo.m_sigs, callbackInfo.m_args);
                }
                catch (InvocationTargetException e) {
                    this.m_component.getLogger().warn("Exception while invoking callback method", e.getCause(), new Object[0]);
                }
                catch (Throwable e) {
                    this.m_component.getLogger().warn("Exception while trying to invoke callback method", e, new Object[0]);
                }
                throw new IllegalStateException("Could not invoke callback");
            }
            Hashtable<String, Object> props = new Hashtable<String, Object>();
            String[] keys = se.getReference().getPropertyKeys();
            int i = 0;
            while (i < keys.length) {
                if (!keys[i].equals("service.id") && !keys[i].equals("service.pid")) {
                    props.put(keys[i], se.getReference().getProperty(keys[i]));
                }
                ++i;
            }
            return props;
        }
        throw new IllegalStateException("cannot find service reference");
    }

    private void setService(Class<?> serviceName, ServiceReference serviceReference, String serviceFilter) {
        this.ensureNotActive();
        this.m_trackedServiceName = serviceName == null ? Object.class : serviceName;
        if (serviceFilter != null) {
            this.m_trackedServiceFilterUnmodified = serviceFilter;
            this.m_trackedServiceFilter = serviceName == null ? serviceFilter : "(&(objectClass=" + serviceName.getName() + ")" + serviceFilter + ")";
        } else {
            this.m_trackedServiceFilterUnmodified = null;
            this.m_trackedServiceFilter = null;
        }
        if (serviceReference != null) {
            this.m_trackedServiceReference = serviceReference;
            if (serviceFilter != null) {
                throw new IllegalArgumentException("Cannot specify both a filter and a service reference.");
            }
            this.m_trackedServiceReferenceId = (Long)this.m_trackedServiceReference.getProperty("service.id");
        } else {
            this.m_trackedServiceReference = null;
        }
    }

    @Override
    public Object getDefaultService(boolean nullObject) {
        Object service = null;
        if (this.isAutoConfig() && (service = this.getDefaultImplementation()) == null && nullObject) {
            service = this.getNullObject();
        }
        return service;
    }

    private Object getNullObject() {
        if (this.m_nullObject == null) {
            Class<?> trackedServiceName = this.m_trackedServiceName;
            try {
                this.m_nullObject = Proxy.newProxyInstance(trackedServiceName.getClassLoader(), new Class[]{trackedServiceName}, (InvocationHandler)new DefaultNullObject());
            }
            catch (Throwable err) {
                this.m_component.getLogger().err("Could not create null object for %s.", err, trackedServiceName);
            }
        }
        return this.m_nullObject;
    }

    private Object getDefaultImplementation() {
        if (this.m_defaultImplementation != null) {
            if (this.m_defaultImplementation instanceof Class) {
                try {
                    this.m_defaultImplementationInstance = ((Class)this.m_defaultImplementation).newInstance();
                }
                catch (Throwable e) {
                    this.m_component.getLogger().err("Could not create default implementation instance of class %s.", e, this.m_defaultImplementation);
                }
            } else {
                this.m_defaultImplementationInstance = this.m_defaultImplementation;
            }
        }
        return this.m_defaultImplementationInstance;
    }

    public void invoke(String method, Event e, Object[] instances) {
        ServiceEventImpl se = (ServiceEventImpl)e;
        ServicePropertiesMap propertiesMap = new ServicePropertiesMap(se.getReference());
        Dictionary<String, Object> properties = se.getProperties();
        this.m_component.invokeCallbackMethod(instances, method, new Class[][]{{Component.class, ServiceReference.class, this.m_trackedServiceName}, {Component.class, ServiceReference.class, Object.class}, {Component.class, ServiceReference.class}, {Component.class, this.m_trackedServiceName}, {Component.class, Object.class}, {Component.class}, {Component.class, Map.class, this.m_trackedServiceName}, {ServiceReference.class, this.m_trackedServiceName}, {ServiceReference.class, Object.class}, {ServiceReference.class}, {this.m_trackedServiceName}, {this.m_trackedServiceName, Map.class}, {Map.class, this.m_trackedServiceName}, {this.m_trackedServiceName, Dictionary.class}, {Dictionary.class, this.m_trackedServiceName}, {Object.class}, new Class[0]}, new Object[][]{{this.m_component, se.getReference(), se.getEvent()}, {this.m_component, se.getReference(), se.getEvent()}, {this.m_component, se.getReference()}, {this.m_component, se.getEvent()}, {this.m_component, se.getEvent()}, {this.m_component}, {this.m_component, propertiesMap, se.getEvent()}, {se.getReference(), se.getEvent()}, {se.getReference(), se.getEvent()}, {se.getReference()}, {se.getEvent()}, {se.getEvent(), propertiesMap}, {propertiesMap, se.getEvent()}, {se.getEvent(), properties}, {properties, se.getEvent()}, {se.getEvent()}, new Object[0]});
    }

    public void invokeSwap(String swapMethod, ServiceReference previousReference, Object previous, ServiceReference currentReference, Object current, Object[] instances) {
        if (this.m_debug) {
            System.out.println("invoke swap: " + swapMethod + " on component " + this.m_component + ", instances: " + Arrays.toString(instances) + " - " + ((ComponentDeclaration)((Object)this.m_component)).getState());
        }
        try {
            this.m_component.invokeCallbackMethod(instances, swapMethod, new Class[][]{{this.m_trackedServiceName, this.m_trackedServiceName}, {Object.class, Object.class}, {ServiceReference.class, this.m_trackedServiceName, ServiceReference.class, this.m_trackedServiceName}, {ServiceReference.class, Object.class, ServiceReference.class, Object.class}, {Component.class, this.m_trackedServiceName, this.m_trackedServiceName}, {Component.class, Object.class, Object.class}, {Component.class, ServiceReference.class, this.m_trackedServiceName, ServiceReference.class, this.m_trackedServiceName}, {Component.class, ServiceReference.class, Object.class, ServiceReference.class, Object.class}}, new Object[][]{{previous, current}, {previous, current}, {previousReference, previous, currentReference, current}, {previousReference, previous, currentReference, current}, {this.m_component, previous, current}, {this.m_component, previous, current}, {this.m_component, previousReference, previous, currentReference, current}, {this.m_component, previousReference, previous, currentReference, current}});
        }
        catch (Throwable e) {
            this.m_component.getLogger().err("Could not invoke swap callback", e, new Object[0]);
        }
    }

    @Override
    public void swappedService(ServiceReference reference, Object service, ServiceReference newReference, Object newService) {
        if (this.m_swap != null) {
            this.m_component.handleEvent(this, EventType.SWAPPED, new ServiceEventImpl(this.m_component.getBundle(), this.m_component.getBundleContext(), reference, service), new ServiceEventImpl(this.m_component.getBundle(), this.m_component.getBundleContext(), newReference, newService));
        } else {
            this.addedService(newReference, newService);
            this.removedService(reference, service);
        }
    }

    private static final class ServicePropertiesMap
    extends AbstractMap<String, Object> {
        private final ServiceReference m_ref;

        public ServicePropertiesMap(ServiceReference ref) {
            this.m_ref = ref;
        }

        @Override
        public Object get(Object key) {
            return this.m_ref.getProperty(key.toString());
        }

        @Override
        public int size() {
            return this.m_ref.getPropertyKeys().length;
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            HashSet<Map.Entry<String, Object>> set = new HashSet<Map.Entry<String, Object>>();
            String[] keys = this.m_ref.getPropertyKeys();
            int i = 0;
            while (i < keys.length) {
                set.add(new ServicePropertiesMapEntry(keys[i], this.m_ref.getProperty(keys[i])));
                ++i;
            }
            return set;
        }
    }

    private static final class ServicePropertiesMapEntry
    implements Map.Entry<String, Object> {
        private final String m_key;
        private Object m_value;

        public ServicePropertiesMapEntry(String key, Object value) {
            this.m_key = key;
            this.m_value = value;
        }

        @Override
        public String getKey() {
            return this.m_key;
        }

        @Override
        public Object getValue() {
            return this.m_value;
        }

        public String toString() {
            return String.valueOf(this.m_key) + "=" + this.m_value;
        }

        @Override
        public Object setValue(Object value) {
            Object oldValue = this.m_value;
            this.m_value = value;
            return oldValue;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return ServicePropertiesMapEntry.eq(this.m_key, e.getKey()) && ServicePropertiesMapEntry.eq(this.m_value, e.getValue());
        }

        @Override
        public int hashCode() {
            return (this.m_key == null ? 0 : this.m_key.hashCode()) ^ (this.m_value == null ? 0 : this.m_value.hashCode());
        }

        private static final boolean eq(Object o1, Object o2) {
            return o1 == null ? o2 == null : o1.equals(o2);
        }
    }
}

