/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.impl;

import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import org.apache.felix.dm.Component;
import org.apache.felix.dm.ComponentStateListener;
import org.apache.felix.dm.DependencyManager;
import org.apache.felix.dm.ResourceDependency;
import org.apache.felix.dm.context.DependencyContext;
import org.apache.felix.dm.impl.AbstractDecorator;
import org.apache.felix.dm.impl.FilterComponent;

public class ResourceAdapterImpl
extends FilterComponent {
    private final Object m_callbackInstance;
    private final String m_callbackChanged;
    private final String m_callbackAdded;
    private final String m_resourceFilter;

    public ResourceAdapterImpl(DependencyManager dm, String resourceFilter, boolean propagate, Object callbackInstance, String callbackSet, String callbackChanged) {
        super(dm.createComponent());
        this.m_callbackInstance = callbackInstance;
        this.m_callbackAdded = callbackSet;
        this.m_callbackChanged = callbackChanged;
        this.m_resourceFilter = resourceFilter;
        this.m_component.setImplementation(new ResourceAdapterDecorator(propagate)).add(dm.createResourceDependency().setFilter(resourceFilter).setAutoConfig(false).setCallbacks("added", "removed")).setCallbacks("init", null, "stop", null);
    }

    public ResourceAdapterImpl(DependencyManager dm, String resourceFilter, Object propagateCallbackInstance, String propagateCallbackMethod, Object callbackInstance, String callbackSet, String callbackChanged) {
        super(dm.createComponent());
        this.m_callbackInstance = callbackInstance;
        this.m_callbackAdded = callbackSet;
        this.m_callbackChanged = callbackChanged;
        this.m_resourceFilter = resourceFilter;
        this.m_component.setImplementation(new ResourceAdapterDecorator(propagateCallbackInstance, propagateCallbackMethod)).add(dm.createResourceDependency().setFilter(resourceFilter).setAutoConfig(false).setCallbacks("added", "removed")).setCallbacks("init", null, "stop", null);
    }

    @Override
    public String getName() {
        return "Resource Adapter" + (this.m_resourceFilter != null ? " with filter " + this.m_resourceFilter : "");
    }

    public class ResourceAdapterDecorator
    extends AbstractDecorator {
        private final boolean m_propagate;
        private final Object m_propagateCallbackInstance;
        private final String m_propagateCallbackMethod;

        public ResourceAdapterDecorator(boolean propagate) {
            this(propagate, null, null);
        }

        public ResourceAdapterDecorator(Object propagateCallbackInstance, String propagateCallbackMethod) {
            this(true, propagateCallbackInstance, propagateCallbackMethod);
        }

        private ResourceAdapterDecorator(boolean propagate, Object propagateCallbackInstance, String propagateCallbackMethod) {
            this.m_propagate = propagate;
            this.m_propagateCallbackInstance = propagateCallbackInstance;
            this.m_propagateCallbackMethod = propagateCallbackMethod;
        }

        @Override
        public Component createService(Object[] properties) {
            URL resource = (URL)properties[0];
            Hashtable props = new Hashtable();
            if (ResourceAdapterImpl.this.m_serviceProperties != null) {
                Enumeration e = ResourceAdapterImpl.this.m_serviceProperties.keys();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    props.put(key, ResourceAdapterImpl.this.m_serviceProperties.get(key));
                }
            }
            List<DependencyContext> dependencies = ResourceAdapterImpl.this.m_component.getDependencies();
            dependencies.remove(0);
            ResourceDependency resourceDependency = this.m_manager.createResourceDependency().setResource(resource).setCallbacks(ResourceAdapterImpl.this.m_callbackInstance, ResourceAdapterImpl.this.m_callbackAdded, ResourceAdapterImpl.this.m_callbackChanged, null).setAutoConfig(ResourceAdapterImpl.this.m_callbackAdded == null).setRequired(true);
            if (this.m_propagateCallbackInstance != null && this.m_propagateCallbackMethod != null) {
                resourceDependency.setPropagate(this.m_propagateCallbackInstance, this.m_propagateCallbackMethod);
            } else {
                resourceDependency.setPropagate(this.m_propagate);
            }
            Component service = this.m_manager.createComponent().setInterface(ResourceAdapterImpl.this.m_serviceInterfaces, props).setImplementation(ResourceAdapterImpl.this.m_serviceImpl).setFactory(ResourceAdapterImpl.this.m_factory, ResourceAdapterImpl.this.m_factoryCreateMethod).setComposition(ResourceAdapterImpl.this.m_compositionInstance, ResourceAdapterImpl.this.m_compositionMethod).setCallbacks(ResourceAdapterImpl.this.m_callbackObject, ResourceAdapterImpl.this.m_init, ResourceAdapterImpl.this.m_start, ResourceAdapterImpl.this.m_stop, ResourceAdapterImpl.this.m_destroy).add(resourceDependency);
            this.configureAutoConfigState(service, ResourceAdapterImpl.this.m_component);
            ResourceAdapterImpl.this.copyDependencies(dependencies, service);
            for (ComponentStateListener stateListener : ResourceAdapterImpl.this.m_stateListeners) {
                service.add(stateListener);
            }
            return service;
        }
    }
}

