/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.context;

import java.util.Collection;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.apache.felix.dm.ComponentDependencyDeclaration;
import org.apache.felix.dm.Dependency;
import org.apache.felix.dm.context.ComponentContext;
import org.apache.felix.dm.context.DependencyContext;
import org.apache.felix.dm.context.Event;
import org.apache.felix.dm.context.EventType;

public abstract class AbstractDependency<T extends Dependency>
implements Dependency,
DependencyContext,
ComponentDependencyDeclaration {
    protected ComponentContext m_component;
    protected volatile boolean m_available;
    protected boolean m_instanceBound;
    protected volatile boolean m_required;
    protected volatile String m_add;
    protected volatile String m_change;
    protected volatile String m_remove;
    protected volatile boolean m_autoConfig = true;
    protected volatile String m_autoConfigInstance;
    protected volatile boolean m_autoConfigInvoked;
    protected volatile boolean m_isStarted;
    protected volatile Object m_callbackInstance;
    protected volatile boolean m_propagate;
    protected volatile Object m_propagateCallbackInstance;
    protected volatile String m_propagateCallbackMethod;
    protected static final Dictionary<Object, Object> EMPTY_PROPERTIES = new Hashtable<Object, Object>(0);

    public AbstractDependency() {
    }

    public AbstractDependency(AbstractDependency<T> prototype) {
        this.m_instanceBound = prototype.m_instanceBound;
        this.m_required = prototype.m_required;
        this.m_add = prototype.m_add;
        this.m_change = prototype.m_change;
        this.m_remove = prototype.m_remove;
        this.m_autoConfig = prototype.m_autoConfig;
        this.m_autoConfigInstance = prototype.m_autoConfigInstance;
        this.m_autoConfigInvoked = prototype.m_autoConfigInvoked;
        this.m_callbackInstance = prototype.m_callbackInstance;
        this.m_propagate = prototype.m_propagate;
        this.m_propagateCallbackInstance = prototype.m_propagateCallbackInstance;
        this.m_propagateCallbackMethod = prototype.m_propagateCallbackMethod;
    }

    public String toString() {
        return this.getType() + " dependency [" + this.getName() + "]";
    }

    @Override
    public boolean isRequired() {
        return this.m_required;
    }

    @Override
    public boolean isAvailable() {
        return this.m_available;
    }

    @Override
    public boolean isAutoConfig() {
        return this.m_autoConfig;
    }

    @Override
    public String getAutoConfigName() {
        return this.m_autoConfigInstance;
    }

    @Override
    public boolean isPropagated() {
        return this.m_propagate;
    }

    @Override
    public <K, V> Dictionary<K, V> getProperties() {
        return EMPTY_PROPERTIES;
    }

    @Override
    public void setComponentContext(ComponentContext component) {
        this.m_component = component;
    }

    @Override
    public void invokeCallback(EventType type, Event ... events) {
    }

    @Override
    public void start() {
        this.m_isStarted = true;
    }

    @Override
    public void stop() {
        this.m_isStarted = false;
    }

    @Override
    public boolean isStarted() {
        return this.m_isStarted;
    }

    @Override
    public void setAvailable(boolean available) {
        this.m_available = available;
    }

    @Override
    public boolean isInstanceBound() {
        return this.m_instanceBound;
    }

    @Override
    public void setInstanceBound(boolean instanceBound) {
        this.m_instanceBound = instanceBound;
    }

    @Override
    public boolean needsInstance() {
        return false;
    }

    @Override
    public abstract Class<?> getAutoConfigType();

    @Override
    public Event getService() {
        Object defaultService;
        Event event = this.m_component.getDependencyEvent(this);
        if (event == null && (defaultService = this.getDefaultService(true)) != null) {
            event = new Event(defaultService);
        }
        return event;
    }

    @Override
    public void copyToCollection(Collection<Object> services) {
        Set<Event> events = this.m_component.getDependencyEvents(this);
        if (events.size() > 0) {
            for (Event e : events) {
                services.add(e.getEvent());
            }
        } else {
            Object defaultService = this.getDefaultService(false);
            if (defaultService != null) {
                services.add(defaultService);
            }
        }
    }

    @Override
    public void copyToMap(Map<Object, Dictionary<?, ?>> map) {
        Set<Event> events = this.m_component.getDependencyEvents(this);
        if (events.size() > 0) {
            for (Event e : events) {
                map.put(e.getEvent(), e.getProperties());
            }
        } else {
            Object defaultService = this.getDefaultService(false);
            if (defaultService != null) {
                map.put(defaultService, EMPTY_PROPERTIES);
            }
        }
    }

    @Override
    public abstract DependencyContext createCopy();

    @Override
    public String getName() {
        return this.getSimpleName();
    }

    @Override
    public abstract String getSimpleName();

    @Override
    public abstract String getType();

    @Override
    public String getFilter() {
        return null;
    }

    @Override
    public int getState() {
        if (this.m_isStarted) {
            return (this.isAvailable() ? 1 : 0) + (this.isRequired() ? 2 : 0);
        }
        return this.isRequired() ? 5 : 4;
    }

    public T setPropagate(boolean propagate) {
        this.ensureNotActive();
        this.m_propagate = propagate;
        return (T)this;
    }

    public T setPropagate(Object instance, String method) {
        this.setPropagate(instance != null && method != null);
        this.m_propagateCallbackInstance = instance;
        this.m_propagateCallbackMethod = method;
        return (T)this;
    }

    public T setCallbacks(String add, String remove) {
        return this.setCallbacks(add, null, remove);
    }

    public T setCallbacks(String add, String change, String remove) {
        return this.setCallbacks(null, add, change, remove);
    }

    public T setCallbacks(Object instance, String add, String remove) {
        return this.setCallbacks(instance, add, null, remove);
    }

    public T setCallbacks(Object instance, String add, String change, String remove) {
        if (!(add == null && change == null && remove == null || this.m_autoConfigInvoked)) {
            this.setAutoConfig(false);
        }
        this.m_callbackInstance = instance;
        this.m_add = add;
        this.m_change = change;
        this.m_remove = remove;
        return (T)this;
    }

    public Object[] getInstances() {
        if (this.m_callbackInstance == null) {
            return this.m_component.getInstances();
        }
        return new Object[]{this.m_callbackInstance};
    }

    public T setRequired(boolean required) {
        this.m_required = required;
        return (T)this;
    }

    public T setAutoConfig(boolean autoConfig) {
        if (autoConfig && this.getAutoConfigType() == null) {
            throw new IllegalStateException("Dependency does not support auto config mode");
        }
        this.m_autoConfig = autoConfig;
        this.m_autoConfigInvoked = true;
        return (T)this;
    }

    public T setAutoConfig(String instanceName) {
        if (instanceName != null && this.getAutoConfigType() == null) {
            throw new IllegalStateException("Dependency does not support auto config mode");
        }
        this.m_autoConfig = instanceName != null;
        this.m_autoConfigInstance = instanceName;
        this.m_autoConfigInvoked = true;
        return (T)this;
    }

    @Override
    public ComponentContext getComponentContext() {
        return this.m_component;
    }

    protected Object getDefaultService(boolean nullObject) {
        return null;
    }

    protected void ensureNotActive() {
        if (this.isStarted()) {
            throw new IllegalStateException("Cannot modify state while active.");
        }
    }
}

