/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.cm.impl.persistence;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.felix.cm.NotCachablePersistenceManager;
import org.apache.felix.cm.PersistenceManager;
import org.apache.felix.cm.impl.ConfigurationManager;
import org.apache.felix.cm.impl.Log;
import org.apache.felix.cm.impl.persistence.CachingPersistenceManagerProxy;
import org.apache.felix.cm.impl.persistence.ExtPersistenceManager;
import org.apache.felix.cm.impl.persistence.PersistenceManagerProxy;
import org.apache.felix.cm.impl.persistence.WorkerQueue;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class PersistenceManagerTracker
implements ServiceTrackerCustomizer<PersistenceManager, Holder> {
    private final ServiceTracker<PersistenceManager, Holder> persistenceManagerTracker;
    private final List<Holder> holders = new ArrayList<Holder>();
    private final WorkerQueue workerQueue;
    private final BundleContext bundleContext;
    private volatile ConfigurationManager configurationManager;
    private volatile ServiceTracker<Object, Object> coordinatorTracker;

    public PersistenceManagerTracker(BundleContext bundleContext, PersistenceManager defaultPM, String pmName) throws InvalidSyntaxException {
        this.bundleContext = bundleContext;
        if (pmName != null) {
            Log.logger.log(4, "Using persistence manager {0}", new Object[]{pmName});
            this.workerQueue = new WorkerQueue();
            this.persistenceManagerTracker = new ServiceTracker(bundleContext, bundleContext.createFilter("(&(objectClass=" + PersistenceManager.class.getName() + ")(name=" + pmName + "))"), (ServiceTrackerCustomizer)this);
            this.persistenceManagerTracker.open();
        } else {
            Log.logger.log(4, "Using default persistence manager", (Object[])null);
            this.workerQueue = null;
            this.persistenceManagerTracker = null;
            this.activate(this.createPersistenceManagerProxy(defaultPM));
        }
    }

    public void stop() {
        if (this.persistenceManagerTracker != null) {
            this.workerQueue.stop();
            this.deactivate();
            this.persistenceManagerTracker.close();
        } else {
            this.deactivate();
        }
    }

    private void activate(ExtPersistenceManager pm) {
        try {
            this.configurationManager = new ConfigurationManager(pm, this.bundleContext);
            this.startCoordinatorTracker();
            ServiceReference<ConfigurationAdmin> ref = this.configurationManager.start();
            Log.logger.set(ref);
        }
        catch (IOException ioe) {
            Log.logger.log(1, "Failure setting up dynamic configuration bindings", ioe);
        }
    }

    private void deactivate() {
        this.stopCoordinatorTracker();
        if (this.configurationManager != null) {
            this.configurationManager.stop();
            this.configurationManager = null;
        }
        Log.logger.set(null);
    }

    private ExtPersistenceManager createPersistenceManagerProxy(PersistenceManager pm) {
        ExtPersistenceManager extPM = pm instanceof NotCachablePersistenceManager ? new PersistenceManagerProxy(pm) : new CachingPersistenceManagerProxy(pm);
        return extPM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Holder addingService(ServiceReference<PersistenceManager> reference) {
        PersistenceManager pm = (PersistenceManager)this.bundleContext.getService(reference);
        if (pm != null) {
            ExtPersistenceManager extPM = this.createPersistenceManagerProxy(pm);
            final Holder holder = new Holder(reference, extPM);
            List<Holder> list = this.holders;
            synchronized (list) {
                final Holder oldHolder = this.holders.isEmpty() ? null : this.holders.get(0);
                this.holders.add(holder);
                Collections.sort(this.holders);
                if (this.holders.get(0) == holder) {
                    this.workerQueue.enqueue(new Runnable(){

                        @Override
                        public void run() {
                            if (oldHolder != null) {
                                PersistenceManagerTracker.this.deactivate();
                            }
                            if (!holder.isActivated()) {
                                PersistenceManagerTracker.this.activate(holder.getPersistenceManager());
                                holder.activate();
                            }
                        }
                    });
                }
            }
            return holder;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifiedService(ServiceReference<PersistenceManager> reference, final Holder holder) {
        List<Holder> list = this.holders;
        synchronized (list) {
            Holder oldHolder = this.holders.isEmpty() ? null : this.holders.get(0);
            this.holders.remove(holder);
            this.holders.add(new Holder(reference, holder.getPersistenceManager()));
            Collections.sort(this.holders);
            if (this.holders.get(0) == holder && oldHolder != null && oldHolder.compareTo(holder) != 0) {
                this.workerQueue.enqueue(new Runnable(){

                    @Override
                    public void run() {
                        PersistenceManagerTracker.this.deactivate();
                        if (!holder.isActivated()) {
                            PersistenceManagerTracker.this.activate(holder.getPersistenceManager());
                            holder.activate();
                        }
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removedService(ServiceReference<PersistenceManager> reference, Holder holder) {
        List<Holder> list = this.holders;
        synchronized (list) {
            boolean deactivate = this.holders.get(0) == holder;
            this.holders.remove(holder);
            if (deactivate) {
                this.workerQueue.enqueue(new Runnable(){

                    @Override
                    public void run() {
                        Holder h;
                        PersistenceManagerTracker.this.deactivate();
                        if (!PersistenceManagerTracker.this.holders.isEmpty() && !(h = (Holder)PersistenceManagerTracker.this.holders.get(0)).isActivated()) {
                            PersistenceManagerTracker.this.activate(h.getPersistenceManager());
                            h.activate();
                        }
                    }
                });
            }
        }
    }

    private void startCoordinatorTracker() {
        this.coordinatorTracker = new ServiceTracker(this.bundleContext, "org.osgi.service.coordinator.Coordinator", (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<Object, Object>(){
            private final SortedMap<ServiceReference<Object>, Object> sortedServices = new TreeMap<ServiceReference<Object>, Object>();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object addingService(ServiceReference<Object> reference) {
                Object srv = PersistenceManagerTracker.this.bundleContext.getService(reference);
                if (srv != null) {
                    SortedMap<ServiceReference<Object>, Object> sortedMap = this.sortedServices;
                    synchronized (sortedMap) {
                        this.sortedServices.put(reference, srv);
                        PersistenceManagerTracker.this.configurationManager.setCoordinator(this.sortedServices.get(this.sortedServices.lastKey()));
                    }
                }
                return srv;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void modifiedService(ServiceReference<Object> reference, Object srv) {
                SortedMap<ServiceReference<Object>, Object> sortedMap = this.sortedServices;
                synchronized (sortedMap) {
                    this.sortedServices.remove(reference);
                    this.sortedServices.put(reference, srv);
                    PersistenceManagerTracker.this.configurationManager.setCoordinator(this.sortedServices.get(this.sortedServices.lastKey()));
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void removedService(ServiceReference<Object> reference, Object service) {
                SortedMap<ServiceReference<Object>, Object> sortedMap = this.sortedServices;
                synchronized (sortedMap) {
                    this.sortedServices.remove(reference);
                    if (this.sortedServices.isEmpty()) {
                        PersistenceManagerTracker.this.configurationManager.setCoordinator(null);
                    } else {
                        PersistenceManagerTracker.this.configurationManager.setCoordinator(this.sortedServices.get(this.sortedServices.lastKey()));
                    }
                }
                PersistenceManagerTracker.this.bundleContext.ungetService(reference);
            }
        });
        this.coordinatorTracker.open();
    }

    private void stopCoordinatorTracker() {
        if (this.coordinatorTracker != null) {
            this.coordinatorTracker.close();
            this.coordinatorTracker = null;
        }
    }

    public static final class Holder
    implements Comparable<Holder> {
        private final ServiceReference<PersistenceManager> reference;
        private final ExtPersistenceManager manager;
        private boolean activated;

        public Holder(ServiceReference<PersistenceManager> ref, ExtPersistenceManager epm) {
            this.reference = ref;
            this.manager = epm;
        }

        public ExtPersistenceManager getPersistenceManager() {
            return this.manager;
        }

        @Override
        public int compareTo(Holder o) {
            return -this.reference.compareTo(o.reference);
        }

        public boolean isActivated() {
            return this.activated;
        }

        public void activate() {
            this.activated = true;
        }

        public int hashCode() {
            return this.reference.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Holder other = (Holder)obj;
            return this.reference.equals(other.reference);
        }
    }
}

