/*
 * Decompiled with CFR 0.152.
 */
package org.apache.edgent.window;

import java.util.HashMap;
import java.util.Map;
import org.apache.edgent.function.Supplier;

public abstract class PartitionedState<K, S> {
    private final Supplier<S> initialState;
    private final Map<K, S> states = new HashMap<K, S>();

    protected PartitionedState(Supplier<S> initialState) {
        this.initialState = initialState;
    }

    protected synchronized S getState(K key) {
        Object state = this.states.get(key);
        if (state == null) {
            state = this.initialState.get();
            this.states.put(key, state);
        }
        return state;
    }

    protected synchronized S setState(K key, S state) {
        return this.states.put(key, state);
    }

    protected synchronized S removeState(K key) {
        return this.states.remove(key);
    }
}

