/*
 * Decompiled with CFR 0.152.
 */
package org.apache.edgent.oplet.core;

import java.util.Collections;
import java.util.List;
import org.apache.edgent.function.Consumer;
import org.apache.edgent.function.Functions;
import org.apache.edgent.function.ToIntFunction;
import org.apache.edgent.oplet.OpletContext;
import org.apache.edgent.oplet.core.AbstractOplet;

public class Split<T>
extends AbstractOplet<T, T>
implements Consumer<T> {
    private static final long serialVersionUID = 1L;
    private final ToIntFunction<T> splitter;
    private List<? extends Consumer<T>> destinations;
    private int n;

    public Split(ToIntFunction<T> splitter) {
        this.splitter = splitter;
    }

    @Override
    public void initialize(OpletContext<T, T> context) {
        super.initialize(context);
        this.destinations = context.getOutputs();
        this.n = this.destinations.size();
    }

    @Override
    public void start() {
    }

    @Override
    public List<Consumer<T>> getInputs() {
        return Collections.singletonList(this);
    }

    public void accept(T tuple) {
        int s = this.splitter.applyAsInt(tuple);
        if (s >= 0) {
            this.destinations.get(s % this.n).accept(tuple);
        }
    }

    @Override
    public void close() throws Exception {
        Functions.closeFunction(this.splitter);
    }
}

