/*
 * Decompiled with CFR 0.152.
 */
package org.apache.edgent.oplet.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.edgent.function.BiFunction;
import org.apache.edgent.function.Consumer;
import org.apache.edgent.oplet.OpletContext;
import org.apache.edgent.oplet.core.AbstractOplet;

public class FanIn<T, U>
extends AbstractOplet<T, U> {
    private BiFunction<T, Integer, U> receiver;
    private List<Consumer<T>> iportConsumers;
    private Consumer<U> destination;

    public FanIn() {
    }

    public FanIn(BiFunction<T, Integer, U> receiver) {
        this.receiver = receiver;
    }

    @Override
    public void initialize(OpletContext<T, U> context) {
        super.initialize(context);
        this.destination = context.getOutputs().get(0);
        int numIports = this.getOpletContext().getInputCount();
        if (this.iportConsumers == null) {
            this.iportConsumers = new ArrayList<Consumer<T>>(numIports);
            for (int i = 0; i < numIports; ++i) {
                this.iportConsumers.add(this.consumer(i));
            }
            this.iportConsumers = Collections.unmodifiableList(this.iportConsumers);
        }
    }

    protected void setReceiver(BiFunction<T, Integer, U> receiver) {
        this.receiver = receiver;
    }

    @Override
    public void start() {
    }

    @Override
    public List<? extends Consumer<T>> getInputs() {
        return this.iportConsumers;
    }

    protected Consumer<T> consumer(int iportIndex) {
        return (Consumer & Serializable)tuple -> {
            Object result = this.receiver.apply(tuple, (Object)iportIndex);
            if (result != null) {
                this.submit(result);
            }
        };
    }

    protected Consumer<U> getDestination() {
        return this.destination;
    }

    protected void submit(U tuple) {
        this.getDestination().accept(tuple);
    }

    @Override
    public void close() {
    }
}

