/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.profiler.Profiler;
import org.apache.dubbo.common.profiler.ProfilerEntry;
import org.apache.dubbo.common.profiler.ProfilerSwitch;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.RpcInvocation;
import org.apache.dubbo.rpc.RpcServiceContext;
import org.apache.dubbo.rpc.model.ConsumerModel;
import org.apache.dubbo.rpc.model.ServiceModel;

public class InvokerInvocationHandler
implements InvocationHandler {
    private static final Logger logger = LoggerFactory.getLogger(InvokerInvocationHandler.class);
    private final Invoker<?> invoker;
    private ServiceModel serviceModel;
    private URL url;
    private String protocolServiceKey;

    public InvokerInvocationHandler(Invoker<?> handler) {
        this.invoker = handler;
        this.url = this.invoker.getUrl();
        this.protocolServiceKey = this.url.getProtocolServiceKey();
        this.serviceModel = this.url.getServiceModel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getDeclaringClass() == Object.class) {
            return method.invoke(this.invoker, args);
        }
        String methodName = method.getName();
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length == 0) {
            if ("toString".equals(methodName)) {
                return this.invoker.toString();
            }
            if ("$destroy".equals(methodName)) {
                this.invoker.destroy();
                return null;
            }
            if ("hashCode".equals(methodName)) {
                return this.invoker.hashCode();
            }
        } else if (parameterTypes.length == 1 && "equals".equals(methodName)) {
            return this.invoker.equals(args[0]);
        }
        RpcInvocation rpcInvocation = new RpcInvocation(this.serviceModel, method, this.invoker.getInterface().getName(), this.protocolServiceKey, args);
        String serviceKey = this.url.getServiceKey();
        rpcInvocation.setTargetServiceUniqueName(serviceKey);
        RpcServiceContext.getServiceContext().setConsumerUrl(this.url);
        if (this.serviceModel instanceof ConsumerModel) {
            rpcInvocation.put("consumerModel", this.serviceModel);
            rpcInvocation.put("methodModel", ((ConsumerModel)this.serviceModel).getMethodModel(method));
        }
        if (ProfilerSwitch.isEnableSimpleProfiler()) {
            Object object;
            ProfilerEntry parentProfiler = Profiler.getBizProfiler();
            ProfilerEntry bizProfiler = parentProfiler != null ? Profiler.enter((ProfilerEntry)parentProfiler, (String)("Receive request. Client invoke begin. ServiceKey: " + serviceKey + " MethodName:" + methodName)) : Profiler.start((String)("Receive request. Client invoke begin. ServiceKey: " + serviceKey + " MethodName:" + methodName));
            rpcInvocation.put("DUBBO_INVOKE_PROFILER", bizProfiler);
            try {
                object = this.invoker.invoke(rpcInvocation).recreate();
            }
            catch (Throwable throwable) {
                Profiler.release((ProfilerEntry)bizProfiler);
                Object timeoutKey = rpcInvocation.getObjectAttachmentWithoutConvert("timeout");
                int timeout = timeoutKey instanceof Integer ? ((Integer)timeoutKey).intValue() : this.url.getMethodPositiveParameter(methodName, "timeout", 1000);
                long usage = bizProfiler.getEndTime() - bizProfiler.getStartTime();
                if ((double)usage / (1000000.0 * ProfilerSwitch.getWarnPercent()) > (double)timeout) {
                    StringBuilder attachment = new StringBuilder();
                    for (Map.Entry<String, Object> entry : rpcInvocation.getObjectAttachments().entrySet()) {
                        attachment.append(entry.getKey()).append("=").append(entry.getValue()).append(";\n");
                    }
                    logger.warn(String.format("[Dubbo-Consumer] execute service %s#%s cost %d.%06d ms, this invocation almost (maybe already) timeout. Timeout: %dms\ninvocation context:\n%sthread info: \n%s", this.protocolServiceKey, methodName, usage / 1000000L, usage % 1000000L, timeout, attachment, Profiler.buildDetail((ProfilerEntry)bizProfiler)));
                }
                throw throwable;
            }
            Profiler.release((ProfilerEntry)bizProfiler);
            Object timeoutKey = rpcInvocation.getObjectAttachmentWithoutConvert("timeout");
            int timeout = timeoutKey instanceof Integer ? ((Integer)timeoutKey).intValue() : this.url.getMethodPositiveParameter(methodName, "timeout", 1000);
            long usage = bizProfiler.getEndTime() - bizProfiler.getStartTime();
            if ((double)usage / (1000000.0 * ProfilerSwitch.getWarnPercent()) > (double)timeout) {
                StringBuilder attachment = new StringBuilder();
                for (Map.Entry<String, Object> entry : rpcInvocation.getObjectAttachments().entrySet()) {
                    attachment.append(entry.getKey()).append("=").append(entry.getValue()).append(";\n");
                }
                logger.warn(String.format("[Dubbo-Consumer] execute service %s#%s cost %d.%06d ms, this invocation almost (maybe already) timeout. Timeout: %dms\ninvocation context:\n%sthread info: \n%s", this.protocolServiceKey, methodName, usage / 1000000L, usage % 1000000L, timeout, attachment, Profiler.buildDetail((ProfilerEntry)bizProfiler)));
            }
            return object;
        }
        return this.invoker.invoke(rpcInvocation).recreate();
    }
}

