/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.support;

import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.StringUtils;

public class ProtocolUtils {
    private ProtocolUtils() {
    }

    public static String serviceKey(URL url) {
        return ProtocolUtils.serviceKey(url.getPort(), url.getPath(), url.getParameter("version"), url.getParameter("group"));
    }

    public static String serviceKey(int port, String serviceName, String serviceVersion, String serviceGroup) {
        StringBuilder buf = new StringBuilder();
        if (StringUtils.isNotEmpty((String)serviceGroup)) {
            buf.append(serviceGroup);
            buf.append("/");
        }
        buf.append(serviceName);
        if (serviceVersion != null && serviceVersion.length() > 0 && !"0.0.0".equals(serviceVersion)) {
            buf.append(":");
            buf.append(serviceVersion);
        }
        buf.append(":");
        buf.append(port);
        return buf.toString();
    }

    public static boolean isGeneric(String generic) {
        return generic != null && !"".equals(generic) && ("true".equalsIgnoreCase(generic) || "nativejava".equalsIgnoreCase(generic) || "bean".equalsIgnoreCase(generic) || "protobuf-json".equalsIgnoreCase(generic));
    }

    public static boolean isDefaultGenericSerialization(String generic) {
        return ProtocolUtils.isGeneric(generic) && "true".equalsIgnoreCase(generic);
    }

    public static boolean isJavaGenericSerialization(String generic) {
        return ProtocolUtils.isGeneric(generic) && "nativejava".equalsIgnoreCase(generic);
    }

    public static boolean isBeanGenericSerialization(String generic) {
        return ProtocolUtils.isGeneric(generic) && "bean".equals(generic);
    }

    public static boolean isProtobufGenericSerialization(String generic) {
        return ProtocolUtils.isGeneric(generic) && "protobuf-json".equals(generic);
    }
}

