/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol;

import java.util.List;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.rpc.Exporter;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.ListenableFilter;
import org.apache.dubbo.rpc.Protocol;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;

public class ProtocolFilterWrapper
implements Protocol {
    private final Protocol protocol;

    public ProtocolFilterWrapper(Protocol protocol) {
        if (protocol == null) {
            throw new IllegalArgumentException("protocol == null");
        }
        this.protocol = protocol;
    }

    private static <T> Invoker<T> buildInvokerChain(final Invoker<T> invoker, String key, String group) {
        Invoker last = invoker;
        List filters = ExtensionLoader.getExtensionLoader(Filter.class).getActivateExtension(invoker.getUrl(), key, group);
        if (!filters.isEmpty()) {
            for (int i = filters.size() - 1; i >= 0; --i) {
                final Filter filter = (Filter)filters.get(i);
                final Invoker next = last;
                last = new Invoker<T>(){

                    @Override
                    public Class<T> getInterface() {
                        return invoker.getInterface();
                    }

                    public URL getUrl() {
                        return invoker.getUrl();
                    }

                    public boolean isAvailable() {
                        return invoker.isAvailable();
                    }

                    @Override
                    public Result invoke(Invocation invocation) throws RpcException {
                        Result asyncResult;
                        try {
                            asyncResult = filter.invoke(next, invocation);
                        }
                        catch (Exception e) {
                            Filter.Listener listener;
                            if (filter instanceof ListenableFilter && (listener = ((ListenableFilter)filter).listener()) != null) {
                                listener.onError(e, invoker, invocation);
                            }
                            throw e;
                        }
                        return asyncResult;
                    }

                    public void destroy() {
                        invoker.destroy();
                    }

                    public String toString() {
                        return invoker.toString();
                    }
                };
            }
        }
        return new CallbackRegistrationInvoker<T>(last, filters);
    }

    @Override
    public int getDefaultPort() {
        return this.protocol.getDefaultPort();
    }

    @Override
    public <T> Exporter<T> export(Invoker<T> invoker) throws RpcException {
        if ("registry".equals(invoker.getUrl().getProtocol())) {
            return this.protocol.export(invoker);
        }
        return this.protocol.export(ProtocolFilterWrapper.buildInvokerChain(invoker, "service.filter", "provider"));
    }

    @Override
    public <T> Invoker<T> refer(Class<T> type, URL url) throws RpcException {
        if ("registry".equals(url.getProtocol())) {
            return this.protocol.refer(type, url);
        }
        return ProtocolFilterWrapper.buildInvokerChain(this.protocol.refer(type, url), "reference.filter", "consumer");
    }

    @Override
    public void destroy() {
        this.protocol.destroy();
    }

    static class CallbackRegistrationInvoker<T>
    implements Invoker<T> {
        private final Invoker<T> filterInvoker;
        private final List<Filter> filters;

        public CallbackRegistrationInvoker(Invoker<T> filterInvoker, List<Filter> filters) {
            this.filterInvoker = filterInvoker;
            this.filters = filters;
        }

        @Override
        public Result invoke(Invocation invocation) throws RpcException {
            Result asyncResult = this.filterInvoker.invoke(invocation);
            asyncResult = asyncResult.whenCompleteWithContext((r, t) -> {
                for (int i = this.filters.size() - 1; i >= 0; --i) {
                    Filter filter = this.filters.get(i);
                    if (filter instanceof ListenableFilter) {
                        Filter.Listener listener = ((ListenableFilter)filter).listener();
                        if (listener == null) continue;
                        if (t == null) {
                            listener.onResponse((Result)r, this.filterInvoker, invocation);
                            continue;
                        }
                        listener.onError((Throwable)t, this.filterInvoker, invocation);
                        continue;
                    }
                    filter.onResponse((Result)r, this.filterInvoker, invocation);
                }
            });
            return asyncResult;
        }

        @Override
        public Class<T> getInterface() {
            return this.filterInvoker.getInterface();
        }

        public URL getUrl() {
            return this.filterInvoker.getUrl();
        }

        public boolean isAvailable() {
            return this.filterInvoker.isAvailable();
        }

        public void destroy() {
            this.filterInvoker.destroy();
        }
    }
}

