/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.openapi.model;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.Context;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.Header;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.MediaType;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.Node;

public final class ApiResponse
extends Node<ApiResponse> {
    private String ref;
    private String description;
    private Map<String, Header> headers;
    private Map<String, MediaType> contents;

    public String getRef() {
        return this.ref;
    }

    public ApiResponse setRef(String ref) {
        this.ref = ref;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public ApiResponse setDescription(String description) {
        this.description = description;
        return this;
    }

    public Map<String, Header> getHeaders() {
        return this.headers;
    }

    public Header getHeader(String name) {
        return this.headers == null ? null : this.headers.get(name);
    }

    public ApiResponse setHeaders(Map<String, Header> headers) {
        this.headers = headers;
        return this;
    }

    public ApiResponse addHeader(String name, Header header) {
        if (this.headers == null) {
            this.headers = new LinkedHashMap<String, Header>();
        }
        this.headers.put(name, header);
        return this;
    }

    public ApiResponse removeHeader(String name) {
        if (this.headers != null) {
            this.headers.remove(name);
        }
        return this;
    }

    public Map<String, MediaType> getContents() {
        return this.contents;
    }

    public MediaType getContent(String name) {
        return this.contents == null ? null : this.contents.get(name);
    }

    public MediaType getOrAddContent(String name) {
        if (this.contents == null) {
            this.contents = new LinkedHashMap<String, MediaType>();
        }
        return this.contents.computeIfAbsent(name, k -> new MediaType());
    }

    public ApiResponse setContents(Map<String, MediaType> contents) {
        this.contents = contents;
        return this;
    }

    public ApiResponse addContent(String name, MediaType content) {
        if (this.contents == null) {
            this.contents = new LinkedHashMap<String, MediaType>();
        }
        this.contents.put(name, content);
        return this;
    }

    public ApiResponse removeContent(String name) {
        if (this.contents != null) {
            this.contents.remove(name);
        }
        return this;
    }

    @Override
    public ApiResponse clone() {
        ApiResponse clone = (ApiResponse)super.clone();
        clone.contents = ApiResponse.clone(this.contents);
        return clone;
    }

    @Override
    public Map<String, Object> writeTo(Map<String, Object> node, Context context) {
        ApiResponse.write(node, "description", this.description);
        ApiResponse.write(node, "content", this.contents, context);
        this.writeExtensions(node);
        return node;
    }
}

