/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.openapi.model;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.Context;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.Discriminator;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.ExternalDocs;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.Node;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.XML;

public final class Schema
extends Node<Schema> {
    private String ref;
    private String format;
    private String name;
    private String title;
    private String description;
    private Object defaultValue;
    private BigDecimal multipleOf;
    private BigDecimal maximum;
    private Boolean exclusiveMaximum;
    private BigDecimal minimum;
    private Boolean exclusiveMinimum;
    private Integer maxLength;
    private Integer minLength;
    private String pattern;
    private Integer maxItems;
    private Integer minItems;
    private Boolean uniqueItems;
    private Integer maxProperties;
    private Integer minProperties;
    private Boolean required;
    private List<Object> enumeration;
    private Type type;
    private Schema items;
    private Map<String, Schema> properties;
    private Schema additionalPropertiesSchema;
    private Boolean additionalPropertiesBoolean;
    private Boolean readOnly;
    private XML xml;
    private ExternalDocs externalDocs;
    private Object example;
    private List<Schema> allOf;
    private List<Schema> oneOf;
    private List<Schema> anyOf;
    private Schema not;
    private Discriminator discriminator;
    private Boolean nullable;
    private Boolean writeOnly;
    private Boolean deprecated;
    private String group;
    private String version;
    private Class<?> javaType;
    private transient Schema targetSchema;
    private transient List<Schema> sourceSchemas;

    public String getRef() {
        return this.ref;
    }

    public Schema setRef(String ref) {
        this.ref = ref;
        return this;
    }

    public String getFormat() {
        return this.format;
    }

    public Schema setFormat(String format) {
        this.format = format;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Schema setName(String name) {
        this.name = name;
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public Schema setTitle(String title) {
        this.title = title;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public Schema setDescription(String description) {
        this.description = description;
        return this;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public Schema setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public BigDecimal getMultipleOf() {
        return this.multipleOf;
    }

    public Schema setMultipleOf(BigDecimal multipleOf) {
        this.multipleOf = multipleOf;
        return this;
    }

    public BigDecimal getMaximum() {
        return this.maximum;
    }

    public Schema setMaximum(BigDecimal maximum) {
        this.maximum = maximum;
        return this;
    }

    public Boolean getExclusiveMaximum() {
        return this.exclusiveMaximum;
    }

    public Schema setExclusiveMaximum(Boolean exclusiveMaximum) {
        this.exclusiveMaximum = exclusiveMaximum;
        return this;
    }

    public BigDecimal getMinimum() {
        return this.minimum;
    }

    public Schema setMinimum(BigDecimal minimum) {
        this.minimum = minimum;
        return this;
    }

    public Boolean getExclusiveMinimum() {
        return this.exclusiveMinimum;
    }

    public Schema setExclusiveMinimum(Boolean exclusiveMinimum) {
        this.exclusiveMinimum = exclusiveMinimum;
        return this;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public Schema setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
        return this;
    }

    public Integer getMinLength() {
        return this.minLength;
    }

    public Schema setMinLength(Integer minLength) {
        this.minLength = minLength;
        return this;
    }

    public String getPattern() {
        return this.pattern;
    }

    public Schema setPattern(String pattern) {
        this.pattern = pattern;
        return this;
    }

    public Integer getMaxItems() {
        return this.maxItems;
    }

    public Schema setMaxItems(Integer maxItems) {
        this.maxItems = maxItems;
        return this;
    }

    public Integer getMinItems() {
        return this.minItems;
    }

    public Schema setMinItems(Integer minItems) {
        this.minItems = minItems;
        return this;
    }

    public Boolean getUniqueItems() {
        return this.uniqueItems;
    }

    public Schema setUniqueItems(Boolean uniqueItems) {
        this.uniqueItems = uniqueItems;
        return this;
    }

    public Integer getMaxProperties() {
        return this.maxProperties;
    }

    public Schema setMaxProperties(Integer maxProperties) {
        this.maxProperties = maxProperties;
        return this;
    }

    public Integer getMinProperties() {
        return this.minProperties;
    }

    public Schema setMinProperties(Integer minProperties) {
        this.minProperties = minProperties;
        return this;
    }

    public Boolean getRequired() {
        return this.required;
    }

    public Schema setRequired(Boolean required) {
        this.required = required;
        return this;
    }

    public List<Object> getEnumeration() {
        return this.enumeration;
    }

    public Schema setEnumeration(List<Object> enumeration) {
        this.enumeration = enumeration;
        return this;
    }

    public Schema addEnumeration(Object enumeration) {
        if (this.enumeration == null) {
            this.enumeration = new ArrayList<Object>();
        }
        this.enumeration.add(enumeration);
        return this;
    }

    public Schema removeEnumeration(Object enumeration) {
        if (this.enumeration != null) {
            this.enumeration.remove(enumeration);
        }
        return this;
    }

    public Type getType() {
        return this.type;
    }

    public Schema setType(Type type) {
        this.type = type;
        return this;
    }

    public Schema getItems() {
        return this.items;
    }

    public Schema setItems(Schema items) {
        this.items = items;
        return this;
    }

    public Map<String, Schema> getProperties() {
        return this.properties;
    }

    public Schema getProperty(String name) {
        return this.properties == null ? null : this.properties.get(name);
    }

    public Schema setProperties(Map<String, Schema> properties) {
        this.properties = properties;
        return this;
    }

    public Schema addProperty(String name, Schema schema) {
        if (schema == null) {
            return this;
        }
        if (this.properties == null) {
            this.properties = new LinkedHashMap<String, Schema>();
        }
        this.properties.put(name, schema);
        return this;
    }

    public Schema removeProperty(String name) {
        if (this.properties != null) {
            this.properties.remove(name);
        }
        return this;
    }

    public Schema getAdditionalPropertiesSchema() {
        return this.additionalPropertiesSchema;
    }

    public Schema setAdditionalPropertiesSchema(Schema additionalPropertiesSchema) {
        this.additionalPropertiesSchema = additionalPropertiesSchema;
        return this;
    }

    public Boolean getAdditionalPropertiesBoolean() {
        return this.additionalPropertiesBoolean;
    }

    public Schema setAdditionalPropertiesBoolean(Boolean additionalPropertiesBoolean) {
        this.additionalPropertiesBoolean = additionalPropertiesBoolean;
        return this;
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public Schema setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    public XML getXml() {
        return this.xml;
    }

    public Schema setXml(XML xml) {
        this.xml = xml;
        return this;
    }

    public ExternalDocs getExternalDocs() {
        return this.externalDocs;
    }

    public Schema setExternalDocs(ExternalDocs externalDocs) {
        this.externalDocs = externalDocs;
        return this;
    }

    public Object getExample() {
        return this.example;
    }

    public Schema setExample(Object example) {
        this.example = example;
        return this;
    }

    public List<Schema> getAllOf() {
        return this.allOf;
    }

    public Schema setAllOf(List<Schema> allOf) {
        this.allOf = allOf;
        return this;
    }

    public Schema addAllOf(Schema schema) {
        if (this.allOf == null) {
            this.allOf = new ArrayList<Schema>();
        }
        this.allOf.add(schema);
        return this;
    }

    public List<Schema> getOneOf() {
        return this.oneOf;
    }

    public Schema setOneOf(List<Schema> oneOf) {
        this.oneOf = oneOf;
        return this;
    }

    public Schema addOneOf(Schema schema) {
        if (this.oneOf == null) {
            this.oneOf = new ArrayList<Schema>();
        }
        this.oneOf.add(schema);
        return this;
    }

    public List<Schema> getAnyOf() {
        return this.anyOf;
    }

    public Schema setAnyOf(List<Schema> anyOf) {
        this.anyOf = anyOf;
        return this;
    }

    public Schema addAnyOf(Schema schema) {
        if (this.anyOf == null) {
            this.anyOf = new ArrayList<Schema>();
        }
        this.anyOf.add(schema);
        return this;
    }

    public Schema getNot() {
        return this.not;
    }

    public Schema setNot(Schema not) {
        this.not = not;
        return this;
    }

    public Discriminator getDiscriminator() {
        return this.discriminator;
    }

    public Schema setDiscriminator(Discriminator discriminator) {
        this.discriminator = discriminator;
        return this;
    }

    public Boolean getNullable() {
        return this.nullable;
    }

    public Schema setNullable(Boolean nullable) {
        this.nullable = nullable;
        return this;
    }

    public Boolean getWriteOnly() {
        return this.writeOnly;
    }

    public Schema setWriteOnly(Boolean writeOnly) {
        this.writeOnly = writeOnly;
        return this;
    }

    public Boolean getDeprecated() {
        return this.deprecated;
    }

    public Schema setDeprecated(Boolean deprecated) {
        this.deprecated = deprecated;
        return this;
    }

    public String getGroup() {
        return this.group;
    }

    public Schema setGroup(String group) {
        this.group = group;
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public Schema setVersion(String version) {
        this.version = version;
        return this;
    }

    public Class<?> getJavaType() {
        return this.javaType;
    }

    public Schema setJavaType(Class<?> javaType) {
        this.javaType = javaType;
        return this;
    }

    public Schema getTargetSchema() {
        return this.targetSchema;
    }

    public Schema setTargetSchema(Schema targetSchema) {
        this.targetSchema = targetSchema;
        return this;
    }

    public List<Schema> getSourceSchemas() {
        return this.sourceSchemas;
    }

    public Schema setSourceSchemas(List<Schema> sourceSchemas) {
        this.sourceSchemas = sourceSchemas;
        return this;
    }

    public void addSourceSchema(Schema sourceSchema) {
        if (this.sourceSchemas == null) {
            this.sourceSchemas = new LinkedList<Schema>();
        }
        this.sourceSchemas.add(sourceSchema);
    }

    @Override
    public Schema clone() {
        Schema clone = (Schema)super.clone();
        if (this.enumeration != null) {
            clone.enumeration = new ArrayList<Object>(this.enumeration);
        }
        clone.items = Schema.clone(this.items);
        clone.properties = Schema.clone(this.properties);
        clone.additionalPropertiesSchema = Schema.clone(this.additionalPropertiesSchema);
        clone.xml = Schema.clone(this.xml);
        clone.externalDocs = Schema.clone(this.externalDocs);
        clone.allOf = Schema.clone(this.allOf);
        clone.oneOf = Schema.clone(this.oneOf);
        clone.anyOf = Schema.clone(this.anyOf);
        clone.not = Schema.clone(this.not);
        clone.discriminator = Schema.clone(this.discriminator);
        return clone;
    }

    @Override
    public Map<String, Object> writeTo(Map<String, Object> schema, Context context) {
        if (this.ref != null) {
            schema.put("$ref", this.ref);
        }
        Schema.write(schema, "format", this.format);
        Schema.write(schema, "title", this.title);
        Schema.write(schema, "description", this.description);
        Schema.write(schema, "default", this.defaultValue);
        Schema.write(schema, "multipleOf", this.multipleOf);
        Schema.write(schema, "maximum", this.maximum);
        Schema.write(schema, "exclusiveMaximum", this.exclusiveMaximum);
        Schema.write(schema, "minimum", this.minimum);
        Schema.write(schema, "exclusiveMinimum", this.exclusiveMinimum);
        Schema.write(schema, "maxLength", this.maxLength);
        Schema.write(schema, "minLength", this.minLength);
        Schema.write(schema, "pattern", this.pattern);
        Schema.write(schema, "maxItems", this.maxItems);
        Schema.write(schema, "minItems", this.minItems);
        Schema.write(schema, "uniqueItems", this.uniqueItems);
        Schema.write(schema, "maxProperties", this.maxProperties);
        Schema.write(schema, "minProperties", this.minProperties);
        Schema.write(schema, "required", this.required);
        Schema.write(schema, "enum", this.enumeration);
        if (this.type != null) {
            if (context.isOpenAPI31()) {
                if (this.nullable == null || !this.nullable.booleanValue()) {
                    Schema.write(schema, "type", this.type.toString());
                } else {
                    Schema.write(schema, "type", new String[]{this.type.toString(), "null"});
                }
            } else {
                Schema.write(schema, "type", this.type.toString());
                Schema.write(schema, "nullable", this.nullable);
            }
        }
        Schema.write(schema, "items", this.items, context);
        Schema.write(schema, "properties", this.properties, context);
        if (this.additionalPropertiesBoolean == null) {
            Schema.write(schema, "additionalProperties", this.additionalPropertiesSchema, context);
        } else {
            schema.put("additionalProperties", this.additionalPropertiesBoolean);
        }
        Schema.write(schema, "readOnly", this.readOnly);
        Schema.write(schema, "xml", this.xml, context);
        Schema.write(schema, "externalDocs", this.externalDocs, context);
        Schema.write(schema, "example", this.example);
        Schema.write(schema, "allOf", this.allOf, context);
        Schema.write(schema, "oneOf", this.oneOf, context);
        Schema.write(schema, "anyOf", this.anyOf, context);
        Schema.write(schema, "not", this.not, context);
        Schema.write(schema, "discriminator", this.discriminator, context);
        Schema.write(schema, "writeOnly", this.writeOnly);
        Schema.write(schema, "deprecated", this.deprecated);
        this.writeExtensions(schema);
        if (this.javaType != null) {
            schema.put("x-java-class", this.javaType.getName());
        }
        return schema;
    }

    public static enum Type {
        STRING("string"),
        INTEGER("integer"),
        NUMBER("number"),
        BOOLEAN("boolean"),
        OBJECT("object"),
        ARRAY("array");

        private final String value;

        private Type(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public Type of(String value) {
            for (Type type : Type.values()) {
                if (!type.value.equals(value)) continue;
                return type;
            }
            return STRING;
        }
    }
}

