/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.api;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.ssl.SslContext;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.util.List;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.remoting.api.ProtocolDetector;
import org.apache.dubbo.remoting.api.WireProtocol;

public class PortUnificationServerHandler
extends ByteToMessageDecoder {
    private final SslContext sslCtx;
    private final URL url;
    private final List<WireProtocol> protocols;
    private final DefaultChannelGroup channels = new DefaultChannelGroup((EventExecutor)GlobalEventExecutor.INSTANCE);

    public PortUnificationServerHandler(URL url, List<WireProtocol> protocols) {
        this(url, null, protocols);
    }

    public PortUnificationServerHandler(URL url, SslContext sslCtx, List<WireProtocol> protocols) {
        this.url = url;
        this.sslCtx = sslCtx;
        this.protocols = protocols;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        super.exceptionCaught(ctx, cause);
    }

    public DefaultChannelGroup getChannels() {
        return this.channels;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
        this.channels.add(ctx.channel());
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        this.channels.remove((Object)ctx.channel());
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if (in.readableBytes() < 5) {
            return;
        }
        block5: for (WireProtocol protocol : this.protocols) {
            in.markReaderIndex();
            ProtocolDetector.Result result = protocol.detector().detect(ctx, in);
            in.resetReaderIndex();
            switch (result) {
                case UNRECOGNIZED: {
                    continue block5;
                }
                case RECOGNIZED: {
                    protocol.configServerPipeline(this.url, ctx.pipeline(), this.sslCtx);
                    ctx.pipeline().remove((ChannelHandler)this);
                }
                case NEED_MORE_DATA: {
                    return;
                }
            }
            return;
        }
        in.clear();
        ctx.close();
    }
}

