/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.api;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.Http2CodecUtil;
import org.apache.dubbo.remoting.api.ProtocolDetector;

public class Http2ProtocolDetector
implements ProtocolDetector {
    private final ByteBuf clientPrefaceString = Http2CodecUtil.connectionPrefaceBuf();

    @Override
    public ProtocolDetector.Result detect(ChannelHandlerContext ctx, ByteBuf in) {
        int prefaceLen = this.clientPrefaceString.readableBytes();
        int bytesRead = Math.min(in.readableBytes(), prefaceLen);
        if (bytesRead == 0 || !ByteBufUtil.equals((ByteBuf)in, (int)0, (ByteBuf)this.clientPrefaceString, (int)0, (int)bytesRead)) {
            return ProtocolDetector.Result.UNRECOGNIZED;
        }
        if (bytesRead == prefaceLen) {
            return ProtocolDetector.Result.RECOGNIZED;
        }
        return ProtocolDetector.Result.NEED_MORE_DATA;
    }
}

