/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.annotation.processing.util;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import org.apache.dubbo.common.function.Predicates;
import org.apache.dubbo.common.function.Streams;
import org.apache.dubbo.metadata.annotation.processing.util.MemberUtils;
import org.apache.dubbo.metadata.annotation.processing.util.TypeUtils;

public interface MethodUtils {
    public static List<ExecutableElement> getDeclaredMethods(TypeElement type, Predicate<ExecutableElement> ... methodFilters) {
        return type == null ? Collections.emptyList() : MethodUtils.getDeclaredMethods(type.asType(), methodFilters);
    }

    public static List<ExecutableElement> getDeclaredMethods(TypeMirror type, Predicate<ExecutableElement> ... methodFilters) {
        return (List)Streams.filterAll(ElementFilter.methodsIn(MemberUtils.getDeclaredMembers(type)), (Predicate[])methodFilters);
    }

    public static List<ExecutableElement> getAllDeclaredMethods(TypeElement type, Predicate<ExecutableElement> ... methodFilters) {
        return type == null ? Collections.emptyList() : MethodUtils.getAllDeclaredMethods(type.asType(), methodFilters);
    }

    public static List<ExecutableElement> getAllDeclaredMethods(TypeElement type) {
        return MethodUtils.getAllDeclaredMethods(type, Predicates.EMPTY_ARRAY);
    }

    public static List<ExecutableElement> getAllDeclaredMethods(TypeMirror type, Predicate<ExecutableElement> ... methodFilters) {
        return TypeUtils.getHierarchicalTypes(type).stream().map(t -> MethodUtils.getDeclaredMethods(t, methodFilters)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public static List<ExecutableElement> getAllDeclaredMethods(TypeMirror type) {
        return MethodUtils.getAllDeclaredMethods(type, Predicates.EMPTY_ARRAY);
    }

    public static List<ExecutableElement> getAllDeclaredMethods(TypeElement type, Type ... excludedTypes) {
        return type == null ? Collections.emptyList() : MethodUtils.getAllDeclaredMethods(type.asType(), excludedTypes);
    }

    public static List<ExecutableElement> getAllDeclaredMethods(TypeMirror type, Type ... excludedTypes) {
        return TypeUtils.getHierarchicalTypes(type, excludedTypes).stream().map(t -> MethodUtils.getDeclaredMethods(t, new Predicate[0])).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public static List<ExecutableElement> getPublicNonStaticMethods(TypeElement type, Type ... excludedTypes) {
        return MethodUtils.getPublicNonStaticMethods(TypeUtils.ofDeclaredType(type), excludedTypes);
    }

    public static List<ExecutableElement> getPublicNonStaticMethods(TypeMirror type, Type ... excludedTypes) {
        return (List)Streams.filter(MethodUtils.getAllDeclaredMethods(type, excludedTypes), MethodUtils::isPublicNonStaticMethod);
    }

    public static boolean isMethod(ExecutableElement method) {
        return method != null && ElementKind.METHOD.equals((Object)method.getKind());
    }

    public static boolean isPublicNonStaticMethod(ExecutableElement method) {
        return MethodUtils.isMethod(method) && MemberUtils.isPublicNonStatic(method);
    }

    public static ExecutableElement findMethod(TypeElement type, String methodName, Type oneParameterType, Type ... otherParameterTypes) {
        return type == null ? null : MethodUtils.findMethod(type.asType(), methodName, oneParameterType, otherParameterTypes);
    }

    public static ExecutableElement findMethod(TypeMirror type, String methodName, Type oneParameterType, Type ... otherParameterTypes) {
        LinkedList<Type> parameterTypes = new LinkedList<Type>();
        parameterTypes.add(oneParameterType);
        parameterTypes.addAll(Arrays.asList(otherParameterTypes));
        return MethodUtils.findMethod(type, methodName, (CharSequence[])parameterTypes.stream().map(Type::getTypeName).toArray(String[]::new));
    }

    public static ExecutableElement findMethod(TypeElement type, String methodName, CharSequence ... parameterTypes) {
        return type == null ? null : MethodUtils.findMethod(type.asType(), methodName, parameterTypes);
    }

    public static ExecutableElement findMethod(TypeMirror type, String methodName, CharSequence ... parameterTypes) {
        return (ExecutableElement)Streams.filterFirst(MethodUtils.getAllDeclaredMethods(type), (Predicate[])new Predicate[]{method -> methodName.equals(method.getSimpleName().toString()), method -> MemberUtils.matchParameterTypes(method.getParameters(), parameterTypes)});
    }

    public static ExecutableElement getOverrideMethod(ProcessingEnvironment processingEnv, TypeElement type, ExecutableElement declaringMethod) {
        Elements elements = processingEnv.getElementUtils();
        return (ExecutableElement)Streams.filterFirst(MethodUtils.getAllDeclaredMethods(type), (Predicate[])new Predicate[]{method -> elements.overrides((ExecutableElement)method, declaringMethod, type)});
    }

    public static String getMethodName(ExecutableElement method) {
        return method == null ? null : method.getSimpleName().toString();
    }

    public static String getReturnType(ExecutableElement method) {
        return method == null ? null : TypeUtils.toString(method.getReturnType());
    }

    public static String[] getMethodParameterTypes(ExecutableElement method) {
        return method == null ? new String[]{} : (String[])method.getParameters().stream().map(Element::asType).map(TypeUtils::toString).toArray(String[]::new);
    }
}

