/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.annotation.processing;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import org.apache.dubbo.metadata.annotation.processing.util.ServiceAnnotationUtils;

public abstract class AbstractServiceAnnotationProcessor
extends AbstractProcessor {
    protected Elements elements;
    private List<? extends Element> objectMembers;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.elements = processingEnv.getElementUtils();
        this.objectMembers = this.elements.getAllMembers(this.elements.getTypeElement(Object.class.getName()));
    }

    protected List<? extends Element> getActualMembers(TypeElement type) {
        LinkedList<? extends Element> members = new LinkedList<Element>(this.elements.getAllMembers(type));
        members.removeAll(this.objectMembers);
        return members;
    }

    protected List<? extends ExecutableElement> getActualMethods(TypeElement type) {
        return ElementFilter.methodsIn(this.getActualMembers(type));
    }

    protected Map<String, ExecutableElement> getActualMethodsMap(TypeElement type) {
        HashMap<String, ExecutableElement> methodsMap = new HashMap<String, ExecutableElement>();
        this.getActualMethods(type).forEach(method -> methodsMap.put(method.toString(), (ExecutableElement)method));
        return methodsMap;
    }

    public static String getMethodSignature(ExecutableElement method) {
        if (!ElementKind.METHOD.equals((Object)method.getKind())) {
            throw new IllegalArgumentException("The argument must be Method Kind");
        }
        StringBuilder methodSignatureBuilder = new StringBuilder();
        method.getModifiers().forEach(member -> methodSignatureBuilder.append(member).append(' '));
        methodSignatureBuilder.append(method.getReturnType()).append(" ").append(method.toString());
        return methodSignatureBuilder.toString();
    }

    protected TypeElement getTypeElement(CharSequence className) {
        return this.elements.getTypeElement(className);
    }

    protected PackageElement getPackageElement(Element type) {
        return this.elements.getPackageOf(type);
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public final Set<String> getSupportedAnnotationTypes() {
        return ServiceAnnotationUtils.SUPPORTED_ANNOTATION_TYPES;
    }
}

