/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.store;

import java.util.SortedSet;
import java.util.function.BiFunction;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.metadata.WritableMetadataService;
import org.apache.dubbo.metadata.store.InMemoryWritableMetadataService;
import org.apache.dubbo.metadata.store.RemoteWritableMetadataService;

public class RemoteWritableMetadataServiceDelegate
implements WritableMetadataService {
    InMemoryWritableMetadataService defaultWritableMetadataService = (InMemoryWritableMetadataService)WritableMetadataService.getExtension("local");
    RemoteWritableMetadataService remoteWritableMetadataService = new RemoteWritableMetadataService(this.defaultWritableMetadataService);

    private WritableMetadataService getDefaultWritableMetadataService() {
        return this.defaultWritableMetadataService;
    }

    @Override
    public boolean exportURL(URL url) {
        return this.doFunction(WritableMetadataService::exportURL, url);
    }

    @Override
    public boolean unexportURL(URL url) {
        return this.doFunction(WritableMetadataService::unexportURL, url);
    }

    @Override
    public boolean subscribeURL(URL url) {
        return this.doFunction(WritableMetadataService::subscribeURL, url);
    }

    @Override
    public boolean unsubscribeURL(URL url) {
        return this.doFunction(WritableMetadataService::unsubscribeURL, url);
    }

    @Override
    public boolean refreshMetadata(String exportedRevision, String subscribedRevision) {
        boolean result = true;
        result &= this.defaultWritableMetadataService.refreshMetadata(exportedRevision, subscribedRevision);
        return result &= this.remoteWritableMetadataService.refreshMetadata(exportedRevision, subscribedRevision);
    }

    @Override
    public void publishServiceDefinition(URL providerUrl) {
        this.defaultWritableMetadataService.publishServiceDefinition(providerUrl);
        this.remoteWritableMetadataService.publishServiceDefinition(providerUrl);
    }

    @Override
    public SortedSet<String> getExportedURLs(String serviceInterface, String group, String version, String protocol) {
        return this.getDefaultWritableMetadataService().getExportedURLs(serviceInterface, group, version, protocol);
    }

    @Override
    public SortedSet<String> getSubscribedURLs() {
        return this.getDefaultWritableMetadataService().getSubscribedURLs();
    }

    @Override
    public String getServiceDefinition(String interfaceName, String version, String group) {
        return this.getDefaultWritableMetadataService().getServiceDefinition(interfaceName, version, group);
    }

    @Override
    public String getServiceDefinition(String serviceKey) {
        return this.getDefaultWritableMetadataService().getServiceDefinition(serviceKey);
    }

    private boolean doFunction(BiFunction<WritableMetadataService, URL, Boolean> func, URL url) {
        return func.apply(this.defaultWritableMetadataService, url) != false && func.apply(this.remoteWritableMetadataService, url) != false;
    }
}

