/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.report.identifier;

import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.metadata.report.identifier.KeyTypeEnum;

public class BaseServiceMetadataIdentifier {
    String serviceInterface;
    String version;
    String group;
    String side;

    String getUniqueKey(KeyTypeEnum keyType, String ... params) {
        if (keyType == KeyTypeEnum.PATH) {
            return this.getFilePathKey(params);
        }
        return this.getIdentifierKey(params);
    }

    String getIdentifierKey(String ... params) {
        return this.serviceInterface + ":" + (this.version == null ? "" : this.version) + ":" + (this.group == null ? "" : this.group) + ":" + (this.side == null ? "" : this.side) + this.joinParams(":", params);
    }

    private String joinParams(String joinChar, String ... params) {
        if (params == null || params.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String param : params) {
            if (param == null) continue;
            sb.append(joinChar);
            sb.append(param);
        }
        return sb.toString();
    }

    private String getFilePathKey(String ... params) {
        return this.getFilePathKey("metadata", params);
    }

    private String getFilePathKey(String pathTag, String ... params) {
        return pathTag + (StringUtils.isEmpty((String)this.toServicePath()) ? "" : "/" + this.toServicePath()) + (this.version == null ? "" : "/" + this.version) + (this.group == null ? "" : "/" + this.group) + (this.side == null ? "" : "/" + this.side) + this.joinParams("/", params);
    }

    private String toServicePath() {
        if ("*".equals(this.serviceInterface)) {
            return "";
        }
        return URL.encode((String)this.serviceInterface);
    }
}

