/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.report.identifier;

import org.apache.dubbo.common.URL;
import org.apache.dubbo.metadata.report.identifier.BaseMetadataIdentifier;
import org.apache.dubbo.metadata.report.identifier.BaseServiceMetadataIdentifier;
import org.apache.dubbo.metadata.report.identifier.KeyTypeEnum;

public class ServiceMetadataIdentifier
extends BaseServiceMetadataIdentifier
implements BaseMetadataIdentifier {
    private String revision;
    private String protocol;

    public ServiceMetadataIdentifier() {
    }

    public ServiceMetadataIdentifier(String serviceInterface, String version, String group, String side, String revision, String protocol) {
        this.serviceInterface = serviceInterface;
        this.version = version;
        this.group = group;
        this.side = side;
        this.revision = revision;
        this.protocol = protocol;
    }

    public ServiceMetadataIdentifier(URL url) {
        this.serviceInterface = url.getServiceInterface();
        this.version = url.getParameter("version");
        this.group = url.getParameter("group");
        this.side = url.getParameter("side");
        this.protocol = url.getProtocol();
    }

    @Override
    public String getUniqueKey(KeyTypeEnum keyType) {
        return super.getUniqueKey(keyType, this.protocol, "revision" + this.revision);
    }

    @Override
    public String getIdentifierKey() {
        return super.getIdentifierKey(this.protocol, "revision" + this.revision);
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String toString() {
        return "ServiceMetadataIdentifier{revision='" + this.revision + '\'' + ", protocol='" + this.protocol + '\'' + ", serviceInterface='" + this.serviceInterface + '\'' + ", version='" + this.version + '\'' + ", group='" + this.group + '\'' + ", side='" + this.side + '\'' + "} " + super.toString();
    }
}

