/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.deploy;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.rpc.Protocol;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.model.ScopeModelDestroyListener;

public class FrameworkModelCleaner
implements ScopeModelDestroyListener<FrameworkModel> {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(FrameworkModelCleaner.class);
    private final AtomicBoolean protocolDestroyed = new AtomicBoolean(false);

    public boolean isProtocol() {
        return true;
    }

    public void onDestroy(FrameworkModel frameworkModel) {
        this.destroyFrameworkResources(frameworkModel);
    }

    private void destroyFrameworkResources(FrameworkModel frameworkModel) {
        this.destroyProtocols(frameworkModel);
    }

    private void destroyProtocols(FrameworkModel frameworkModel) {
        if (this.protocolDestroyed.compareAndSet(false, true)) {
            ExtensionLoader loader = frameworkModel.getExtensionLoader(Protocol.class);
            for (String protocolName : loader.getLoadedExtensions()) {
                try {
                    Protocol protocol = (Protocol)loader.getLoadedExtension(protocolName);
                    if (protocol == null) continue;
                    protocol.destroy();
                }
                catch (Throwable t) {
                    logger.warn("5-25", "", "", t.getMessage(), t);
                }
            }
        }
    }
}

