/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config;

import java.beans.Transient;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.Version;
import org.apache.dubbo.common.constants.CommonConstants;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.url.component.ServiceConfigURL;
import org.apache.dubbo.common.utils.ArrayUtils;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.ConfigUtils;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.common.utils.UrlUtils;
import org.apache.dubbo.config.AbstractConfig;
import org.apache.dubbo.config.AbstractInterfaceConfig;
import org.apache.dubbo.config.ConfigInitializer;
import org.apache.dubbo.config.ConfigPostProcessor;
import org.apache.dubbo.config.MethodConfig;
import org.apache.dubbo.config.ReferenceConfigBase;
import org.apache.dubbo.config.annotation.Reference;
import org.apache.dubbo.config.support.Parameter;
import org.apache.dubbo.config.utils.ConfigValidationUtils;
import org.apache.dubbo.registry.client.metadata.MetadataUtils;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Protocol;
import org.apache.dubbo.rpc.ProxyFactory;
import org.apache.dubbo.rpc.cluster.Cluster;
import org.apache.dubbo.rpc.cluster.Directory;
import org.apache.dubbo.rpc.cluster.directory.StaticDirectory;
import org.apache.dubbo.rpc.cluster.support.ClusterUtils;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.AsyncMethodInfo;
import org.apache.dubbo.rpc.model.ConsumerModel;
import org.apache.dubbo.rpc.model.DubboStub;
import org.apache.dubbo.rpc.model.ModuleModel;
import org.apache.dubbo.rpc.model.ModuleServiceRepository;
import org.apache.dubbo.rpc.model.ScopeModel;
import org.apache.dubbo.rpc.model.ServiceDescriptor;
import org.apache.dubbo.rpc.model.ServiceModel;
import org.apache.dubbo.rpc.protocol.injvm.InjvmProtocol;
import org.apache.dubbo.rpc.service.GenericService;
import org.apache.dubbo.rpc.stub.StubSuppliers;
import org.apache.dubbo.rpc.support.ProtocolUtils;

public class ReferenceConfig<T>
extends ReferenceConfigBase<T> {
    public static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(ReferenceConfig.class);
    private Protocol protocolSPI;
    private ProxyFactory proxyFactory;
    private ConsumerModel consumerModel;
    private volatile transient T ref;
    private volatile transient Invoker<?> invoker;
    private volatile transient boolean initialized;
    private volatile transient boolean destroyed;
    private String services;
    protected final transient ReentrantLock lock = new ReentrantLock();

    public ReferenceConfig() {
    }

    public ReferenceConfig(ModuleModel moduleModel) {
        super(moduleModel);
    }

    public ReferenceConfig(Reference reference) {
        super(reference);
    }

    public ReferenceConfig(ModuleModel moduleModel, Reference reference) {
        super(moduleModel, reference);
    }

    protected void postProcessAfterScopeModelChanged(ScopeModel oldScopeModel, ScopeModel newScopeModel) {
        super.postProcessAfterScopeModelChanged(oldScopeModel, newScopeModel);
        this.protocolSPI = (Protocol)this.getExtensionLoader(Protocol.class).getAdaptiveExtension();
        this.proxyFactory = (ProxyFactory)this.getExtensionLoader(ProxyFactory.class).getAdaptiveExtension();
    }

    @Deprecated
    @Parameter(key="subscribed-services")
    public String getServices() {
        return this.services;
    }

    @Deprecated
    @Parameter(excluded=true)
    public Set<String> getSubscribedServices() {
        return StringUtils.splitToSet((String)this.getServices(), (char)',');
    }

    public void setServices(String services) {
        this.services = services;
    }

    @Transient
    public T get(boolean check) {
        if (this.destroyed) {
            throw new IllegalStateException("The invoker of ReferenceConfig(" + this.url + ") has already destroyed!");
        }
        if (this.ref == null) {
            if (this.getScopeModel().isLifeCycleManagedExternally()) {
                this.getScopeModel().getDeployer().prepare();
            } else {
                this.getScopeModel().getDeployer().start();
            }
            this.init(check);
        }
        return this.ref;
    }

    public void checkOrDestroy(long timeout) {
        if (!this.initialized || this.ref == null) {
            return;
        }
        try {
            this.checkInvokerAvailable(timeout);
        }
        catch (Throwable t) {
            this.logAndCleanup(t);
            throw t;
        }
    }

    private void logAndCleanup(Throwable t) {
        try {
            if (this.invoker != null) {
                this.invoker.destroy();
            }
        }
        catch (Throwable destroy) {
            logger.warn("5-3", "", "", "Unexpected error occurred when destroy invoker of ReferenceConfig(" + this.url + ").", t);
        }
        if (this.consumerModel != null) {
            ModuleServiceRepository repository = this.getScopeModel().getServiceRepository();
            repository.unregisterConsumer(this.consumerModel);
        }
        this.initialized = false;
        this.invoker = null;
        this.ref = null;
        this.consumerModel = null;
        this.serviceMetadata.setTarget(null);
        this.serviceMetadata.getAttributeMap().remove("refClass");
        if (t.getClass() == IllegalStateException.class && t.getMessage().contains("No provider available for the service")) {
            logger.error("2-2", "server crashed", "", "No provider available.", t);
        }
    }

    public void destroy() {
        this.lock.lock();
        try {
            super.destroy();
            if (this.destroyed) {
                return;
            }
            this.destroyed = true;
            try {
                if (this.invoker != null) {
                    this.invoker.destroy();
                }
            }
            catch (Throwable t) {
                logger.warn("5-3", "", "", "Unexpected error occurred when destroy invoker of ReferenceConfig(" + this.url + ").", t);
            }
            this.invoker = null;
            this.ref = null;
            if (this.consumerModel != null) {
                ModuleServiceRepository repository = this.getScopeModel().getServiceRepository();
                repository.unregisterConsumer(this.consumerModel);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void init() {
        this.init(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init(boolean check) {
        this.lock.lock();
        try {
            if (this.initialized && this.ref != null) {
                return;
            }
            try {
                ServiceDescriptor serviceDescriptor;
                String proxyType;
                if (!this.isRefreshed()) {
                    this.refresh();
                }
                if (StringUtils.isBlank((CharSequence)(proxyType = this.getProxy())) && DubboStub.class.isAssignableFrom(this.interfaceClass)) {
                    this.setProxy("nativestub");
                }
                this.initServiceMetadata((AbstractInterfaceConfig)this.consumer);
                this.serviceMetadata.setServiceType(this.getServiceInterfaceClass());
                this.serviceMetadata.generateServiceKey();
                Map<String, String> referenceParameters = this.appendConfig();
                ModuleServiceRepository repository = this.getScopeModel().getServiceRepository();
                if ("nativestub".equals(this.getProxy())) {
                    serviceDescriptor = StubSuppliers.getServiceDescriptor((String)this.interfaceName);
                    repository.registerService(serviceDescriptor);
                    this.setInterface(serviceDescriptor.getInterfaceName());
                } else {
                    serviceDescriptor = repository.registerService(this.interfaceClass);
                }
                this.consumerModel = new ConsumerModel(this.serviceMetadata.getServiceKey(), (Object)this.proxy, serviceDescriptor, this.getScopeModel(), this.serviceMetadata, this.createAsyncMethodInfo(), this.interfaceClassLoader);
                this.consumerModel.setConfig((AbstractInterfaceConfig)this);
                repository.registerConsumer(this.consumerModel);
                this.serviceMetadata.getAttachments().putAll(referenceParameters);
                this.ref = this.createProxy(referenceParameters);
                this.serviceMetadata.setTarget(this.ref);
                this.serviceMetadata.addAttribute("refClass", this.ref);
                this.consumerModel.setDestroyRunner(this.getDestroyRunner());
                this.consumerModel.setProxyObject(this.ref);
                this.consumerModel.initMethodModels();
                if (check) {
                    this.checkInvokerAvailable(0L);
                }
            }
            catch (Throwable t) {
                this.logAndCleanup(t);
                throw t;
            }
            this.initialized = true;
        }
        finally {
            this.lock.unlock();
        }
    }

    private Map<String, AsyncMethodInfo> createAsyncMethodInfo() {
        HashMap<String, AsyncMethodInfo> attributes = null;
        if (CollectionUtils.isNotEmpty((Collection)this.getMethods())) {
            attributes = new HashMap<String, AsyncMethodInfo>(16);
            for (MethodConfig methodConfig : this.getMethods()) {
                AsyncMethodInfo asyncMethodInfo = methodConfig.convertMethodConfig2AsyncInfo();
                if (asyncMethodInfo == null) continue;
                attributes.put(methodConfig.getName(), asyncMethodInfo);
            }
        }
        return attributes;
    }

    private Map<String, String> appendConfig() {
        HashMap<String, String> map = new HashMap<String, String>(16);
        map.put("interface", this.interfaceName);
        map.put("side", "consumer");
        ReferenceConfigBase.appendRuntimeParameters(map);
        if (!ProtocolUtils.isGeneric((String)this.generic)) {
            String[] methods;
            String revision = Version.getVersion((Class)this.interfaceClass, (String)this.version);
            if (StringUtils.isNotEmpty((String)revision)) {
                map.put("revision", revision);
            }
            if ((methods = this.methods(this.interfaceClass)).length == 0) {
                logger.warn("5-4", "", "", "No method found in service interface: " + this.interfaceClass.getName());
                map.put("methods", "*");
            } else {
                map.put("methods", StringUtils.join(new TreeSet<String>(Arrays.asList(methods)), (String)","));
            }
        }
        AbstractConfig.appendParameters(map, (Object)this.getApplication());
        AbstractConfig.appendParameters(map, (Object)this.getModule());
        AbstractConfig.appendParameters(map, (Object)this.consumer);
        AbstractConfig.appendParameters(map, (Object)((Object)this));
        String hostToRegistry = ConfigUtils.getSystemProperty((String)"DUBBO_IP_TO_REGISTRY");
        if (StringUtils.isEmpty((String)hostToRegistry)) {
            hostToRegistry = NetUtils.getLocalHost();
        } else if (NetUtils.isInvalidLocalHost((String)hostToRegistry)) {
            throw new IllegalArgumentException("Specified invalid registry ip from property:DUBBO_IP_TO_REGISTRY, value:" + hostToRegistry);
        }
        map.put("register.ip", hostToRegistry);
        if (CollectionUtils.isNotEmpty((Collection)this.getMethods())) {
            for (MethodConfig methodConfig : this.getMethods()) {
                String retryValue;
                AbstractConfig.appendParameters(map, (Object)methodConfig, (String)methodConfig.getName());
                String retryKey = methodConfig.getName() + ".retry";
                if (!map.containsKey(retryKey) || !"false".equals(retryValue = (String)map.remove(retryKey))) continue;
                map.put(methodConfig.getName() + ".retries", "0");
            }
        }
        return map;
    }

    private T createProxy(Map<String, String> referenceParameters) {
        this.urls.clear();
        this.meshModeHandleUrl(referenceParameters);
        if (StringUtils.isNotEmpty((String)this.url)) {
            this.parseUrl(referenceParameters);
        } else {
            this.aggregateUrlFromRegistry(referenceParameters);
        }
        this.createInvoker();
        if (logger.isInfoEnabled()) {
            logger.info("Referred dubbo service: [" + referenceParameters.get("interface") + "]." + (ProtocolUtils.isGeneric((String)referenceParameters.get("generic")) ? " it's GenericService reference" : " it's not GenericService reference"));
        }
        ServiceConfigURL consumerUrl = new ServiceConfigURL("consumer", referenceParameters.get("register.ip"), 0, referenceParameters.get("interface"), referenceParameters);
        consumerUrl = consumerUrl.setScopeModel((ScopeModel)this.getScopeModel());
        consumerUrl = consumerUrl.setServiceModel((ServiceModel)this.consumerModel);
        MetadataUtils.publishServiceDefinition((URL)consumerUrl, (ServiceDescriptor)this.consumerModel.getServiceModel(), (ApplicationModel)this.getApplicationModel());
        return (T)this.proxyFactory.getProxy(this.invoker, ProtocolUtils.isGeneric((String)this.generic));
    }

    private void meshModeHandleUrl(Map<String, String> referenceParameters) {
        if (!this.checkMeshConfig(referenceParameters)) {
            return;
        }
        if (StringUtils.isNotEmpty((String)this.url)) {
            if (logger.isInfoEnabled()) {
                logger.info("The url already exists, mesh no longer processes url: " + this.url);
            }
            return;
        }
        String podNamespace = referenceParameters.get("provider-namespace");
        if (StringUtils.isEmpty((String)podNamespace)) {
            if (StringUtils.isEmpty((String)System.getenv("POD_NAMESPACE"))) {
                if (logger.isWarnEnabled()) {
                    logger.warn("5-5", "", "", "Can not get env variable: POD_NAMESPACE, it may not be running in the K8S environment , finally use 'default' replace.");
                }
                podNamespace = "default";
            } else {
                podNamespace = System.getenv("POD_NAMESPACE");
            }
        }
        String providedBy = referenceParameters.get("provided-by");
        String clusterDomain = Optional.ofNullable(System.getenv("CLUSTER_DOMAIN")).orElse("cluster.local");
        Integer meshPort = Optional.ofNullable(this.getProviderPort()).orElse(CommonConstants.DEFAULT_MESH_PORT);
        meshPort = meshPort > -1 ? meshPort : CommonConstants.DEFAULT_MESH_PORT;
        this.url = "tri://" + providedBy + "." + podNamespace + ".svc." + clusterDomain + ":" + meshPort;
    }

    private boolean checkMeshConfig(Map<String, String> referenceParameters) {
        if (!"true".equals(referenceParameters.getOrDefault("mesh-enable", "false"))) {
            referenceParameters.put("unloadClusterRelated", "false");
            return false;
        }
        this.getScopeModel().getConfigManager().getProtocol("tri").orElseThrow(() -> new IllegalStateException("In mesh mode, a triple protocol must be specified"));
        String providedBy = referenceParameters.get("provided-by");
        if (StringUtils.isEmpty((String)providedBy)) {
            throw new IllegalStateException("In mesh mode, the providedBy of ReferenceConfig is must be set");
        }
        return true;
    }

    private void parseUrl(Map<String, String> referenceParameters) {
        Object[] us = CommonConstants.SEMICOLON_SPLIT_PATTERN.split(this.url);
        if (ArrayUtils.isNotEmpty((Object[])us)) {
            for (Object u : us) {
                URL url = URL.valueOf((String)u);
                if (StringUtils.isEmpty((String)url.getPath())) {
                    url = url.setPath(this.interfaceName);
                }
                url = url.setScopeModel((ScopeModel)this.getScopeModel());
                if (UrlUtils.isRegistry((URL)(url = url.setServiceModel((ServiceModel)this.consumerModel)))) {
                    this.urls.add(url.putAttribute("refer", referenceParameters));
                    continue;
                }
                URL peerUrl = ((ClusterUtils)this.getScopeModel().getApplicationModel().getBeanFactory().getBean(ClusterUtils.class)).mergeUrl(url, referenceParameters);
                peerUrl = peerUrl.putAttribute("peer", (Object)true);
                this.urls.add(peerUrl);
            }
        }
    }

    private void aggregateUrlFromRegistry(Map<String, String> referenceParameters) {
        this.checkRegistry();
        List<URL> us = ConfigValidationUtils.loadRegistries((AbstractInterfaceConfig)this, false);
        if (CollectionUtils.isNotEmpty(us)) {
            for (URL u : us) {
                URL monitorUrl = ConfigValidationUtils.loadMonitor((AbstractInterfaceConfig)this, u);
                if (monitorUrl != null) {
                    u = u.putAttribute("monitor", (Object)monitorUrl);
                }
                u = u.setScopeModel((ScopeModel)this.getScopeModel());
                u = u.setServiceModel((ServiceModel)this.consumerModel);
                if (this.isInjvm() != null && this.isInjvm().booleanValue()) {
                    u = u.addParameter("injvm", true);
                }
                this.urls.add(u.putAttribute("refer", referenceParameters));
            }
        }
        if (this.urls.isEmpty() && this.shouldJvmRefer(referenceParameters)) {
            URL injvmUrl = new URL("injvm", "127.0.0.1", 0, this.interfaceClass.getName()).addParameters(referenceParameters);
            injvmUrl = injvmUrl.setScopeModel((ScopeModel)this.getScopeModel());
            injvmUrl = injvmUrl.setServiceModel((ServiceModel)this.consumerModel);
            this.urls.add(injvmUrl.putAttribute("refer", referenceParameters));
        }
        if (this.urls.isEmpty()) {
            throw new IllegalStateException("No such any registry to reference " + this.interfaceName + " on the consumer " + NetUtils.getLocalHost() + " use dubbo version " + Version.getVersion() + ", please config <dubbo:registry address=\"...\" /> to your spring config.");
        }
    }

    private void createInvoker() {
        if (this.urls.size() == 1) {
            URL curUrl = (URL)this.urls.get(0);
            this.invoker = this.protocolSPI.refer(this.interfaceClass, curUrl);
            if (!UrlUtils.isRegistry((URL)curUrl) && !curUrl.getParameter("unloadClusterRelated", false)) {
                ArrayList invokers = new ArrayList();
                invokers.add(this.invoker);
                this.invoker = Cluster.getCluster((ScopeModel)this.getScopeModel(), (String)"failover").join((Directory)new StaticDirectory(curUrl, invokers), true);
            }
        } else {
            ArrayList<Invoker> invokers = new ArrayList<Invoker>();
            URL registryUrl = null;
            for (URL url : this.urls) {
                invokers.add(this.protocolSPI.refer(this.interfaceClass, url));
                if (!UrlUtils.isRegistry((URL)url)) continue;
                registryUrl = url;
            }
            if (registryUrl != null) {
                String cluster = registryUrl.getParameter("cluster", "zone-aware");
                this.invoker = Cluster.getCluster((ScopeModel)registryUrl.getScopeModel(), (String)cluster, (boolean)false).join((Directory)new StaticDirectory(registryUrl, invokers), false);
            } else {
                if (CollectionUtils.isEmpty(invokers)) {
                    throw new IllegalArgumentException("invokers == null");
                }
                URL curUrl = ((Invoker)invokers.get(0)).getUrl();
                String cluster = curUrl.getParameter("cluster", "failover");
                this.invoker = Cluster.getCluster((ScopeModel)this.getScopeModel(), (String)cluster).join((Directory)new StaticDirectory(curUrl, invokers), true);
            }
        }
    }

    private void checkInvokerAvailable(long timeout) throws IllegalStateException {
        if (!this.shouldCheck()) {
            return;
        }
        boolean available = this.invoker.isAvailable();
        if (available) {
            return;
        }
        long startTime = System.currentTimeMillis();
        long checkDeadline = startTime + timeout;
        do {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        } while (!(available = this.invoker.isAvailable()) && checkDeadline > System.currentTimeMillis());
        logger.warn("1-4", "", "", "Check reference of [" + this.getUniqueServiceName() + "] failed very beginning. After " + (System.currentTimeMillis() - startTime) + "ms reties, finally " + (available ? "succeed" : "failed") + ".");
        if (!available) {
            IllegalStateException illegalStateException = new IllegalStateException("Failed to check the status of the service " + this.interfaceName + ". No provider available for the service " + (this.group == null ? "" : this.group + "/") + this.interfaceName + (this.version == null ? "" : ":" + this.version) + " from the url " + this.invoker.getUrl() + " to the consumer " + NetUtils.getLocalHost() + " use dubbo version " + Version.getVersion());
            logger.error("2-2", "provider not started", "", "No provider available.", (Throwable)illegalStateException);
            throw illegalStateException;
        }
    }

    protected void checkAndUpdateSubConfigs() {
        if (StringUtils.isEmpty((String)this.interfaceName)) {
            throw new IllegalStateException("<dubbo:reference interface=\"\" /> interface not allow null!");
        }
        this.completeCompoundConfigs();
        List configInitializers = this.getExtensionLoader(ConfigInitializer.class).getActivateExtension(URL.valueOf((String)"configInitializer://"), (String[])null);
        configInitializers.forEach(e -> e.initReferConfig(this));
        if (this.getGeneric() == null && this.getConsumer() != null) {
            this.setGeneric(this.getConsumer().getGeneric());
        }
        if (ProtocolUtils.isGeneric((String)this.generic)) {
            if (this.interfaceClass != null && !this.interfaceClass.equals(GenericService.class)) {
                logger.warn("5-6", "", "", String.format("Found conflicting attributes for interface type: [interfaceClass=%s] and [generic=%s], because the 'generic' attribute has higher priority than 'interfaceClass', so change 'interfaceClass' to '%s'. Note: it will make this reference bean as a candidate bean of type '%s' instead of '%s' when resolving dependency in Spring.", this.interfaceClass.getName(), this.generic, GenericService.class.getName(), GenericService.class.getName(), this.interfaceClass.getName()));
            }
            this.interfaceClass = GenericService.class;
        } else {
            try {
                if (this.getInterfaceClassLoader() != null && (this.interfaceClass == null || this.interfaceClass.getClassLoader() != this.getInterfaceClassLoader())) {
                    this.interfaceClass = Class.forName(this.interfaceName, true, this.getInterfaceClassLoader());
                } else if (this.interfaceClass == null) {
                    this.interfaceClass = Class.forName(this.interfaceName, true, Thread.currentThread().getContextClassLoader());
                }
            }
            catch (ClassNotFoundException e2) {
                throw new IllegalStateException(e2.getMessage(), e2);
            }
        }
        this.checkStubAndLocal(this.interfaceClass);
        if (StringUtils.isEmpty((String)this.url)) {
            this.checkRegistry();
        }
        this.resolveFile();
        ConfigValidationUtils.validateReferenceConfig(this);
        this.postProcessConfig();
    }

    protected void postProcessRefresh() {
        super.postProcessRefresh();
        this.checkAndUpdateSubConfigs();
    }

    protected void completeCompoundConfigs() {
        super.completeCompoundConfigs((AbstractInterfaceConfig)this.consumer);
        if (this.consumer != null && StringUtils.isEmpty((String)this.registryIds)) {
            this.setRegistryIds(this.consumer.getRegistryIds());
        }
    }

    protected boolean shouldJvmRefer(Map<String, String> map) {
        boolean isJvmRefer;
        if (this.isInjvm() == null) {
            if (StringUtils.isNotEmpty((String)this.url)) {
                isJvmRefer = false;
            } else {
                ServiceConfigURL tmpUrl = new ServiceConfigURL("temp", "localhost", 0, map);
                isJvmRefer = InjvmProtocol.getInjvmProtocol((ScopeModel)this.getScopeModel()).isInjvmRefer((URL)tmpUrl);
            }
        } else {
            isJvmRefer = this.isInjvm();
        }
        return isJvmRefer;
    }

    private void postProcessConfig() {
        List configPostProcessors = this.getExtensionLoader(ConfigPostProcessor.class).getActivateExtension(URL.valueOf((String)"configPostProcessor://"), (String[])null);
        HashSet allConfigPostProcessor = new HashSet();
        allConfigPostProcessor.addAll(configPostProcessors);
        allConfigPostProcessor.addAll(configPostProcessors);
        allConfigPostProcessor.forEach(component -> component.postProcessReferConfig(this));
    }

    @Transient
    public boolean configInitialized() {
        return this.initialized;
    }

    @Deprecated
    @Transient
    public Invoker<?> getInvoker() {
        return this.invoker;
    }

    @Transient
    public Runnable getDestroyRunner() {
        return this::destroy;
    }
}

