/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.utils;

import java.util.ArrayList;
import java.util.List;
import org.apache.dubbo.common.config.ReferenceCache;
import org.apache.dubbo.config.ReferenceConfigBase;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.ModuleModel;

public class CompositeReferenceCache
implements ReferenceCache {
    private ApplicationModel applicationModel;

    public CompositeReferenceCache(ApplicationModel applicationModel) {
        this.applicationModel = applicationModel;
    }

    public <T> T get(ReferenceConfigBase<T> referenceConfig) {
        return (T)referenceConfig.get();
    }

    public <T> T get(String key, Class<T> type) {
        for (ModuleModel moduleModel : this.applicationModel.getModuleModels()) {
            Object proxy = moduleModel.getDeployer().getReferenceCache().get(key, type);
            if (proxy == null) continue;
            return (T)proxy;
        }
        return null;
    }

    public <T> T get(String key) {
        for (ModuleModel moduleModel : this.applicationModel.getModuleModels()) {
            Object proxy = moduleModel.getDeployer().getReferenceCache().get(key);
            if (proxy == null) continue;
            return (T)proxy;
        }
        return null;
    }

    public <T> List<T> getAll(Class<T> type) {
        ArrayList proxies = new ArrayList();
        for (ModuleModel moduleModel : this.applicationModel.getModuleModels()) {
            proxies.addAll(moduleModel.getDeployer().getReferenceCache().getAll(type));
        }
        return proxies;
    }

    public <T> T get(Class<T> type) {
        for (ModuleModel moduleModel : this.applicationModel.getModuleModels()) {
            Object proxy = moduleModel.getDeployer().getReferenceCache().get(type);
            if (proxy == null) continue;
            return (T)proxy;
        }
        return null;
    }

    public void destroy(String key, Class<?> type) {
        for (ModuleModel moduleModel : this.applicationModel.getModuleModels()) {
            moduleModel.getDeployer().getReferenceCache().destroy(key, type);
        }
    }

    public void destroy(Class<?> type) {
        for (ModuleModel moduleModel : this.applicationModel.getModuleModels()) {
            moduleModel.getDeployer().getReferenceCache().destroy(type);
        }
    }

    public <T> void destroy(ReferenceConfigBase<T> referenceConfig) {
        referenceConfig.getScopeModel().getDeployer().getReferenceCache().destroy(referenceConfig);
    }

    public void destroyAll() {
        for (ModuleModel moduleModel : this.applicationModel.getModuleModels()) {
            moduleModel.getDeployer().getReferenceCache().destroyAll();
        }
    }
}

