/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.schema;

import java.util.Set;
import javax.inject.Inject;
import org.apache.calcite.schema.Table;
import org.apache.druid.sql.calcite.planner.CatalogResolver;
import org.apache.druid.sql.calcite.schema.AbstractTableSchema;
import org.apache.druid.sql.calcite.schema.BrokerSegmentMetadataCache;
import org.apache.druid.sql.calcite.schema.DruidSchemaManager;
import org.apache.druid.sql.calcite.schema.NoopDruidSchemaManager;
import org.apache.druid.sql.calcite.table.DatasourceTable;
import org.apache.druid.sql.calcite.table.DruidTable;

public class DruidSchema
extends AbstractTableSchema {
    private final BrokerSegmentMetadataCache segmentMetadataCache;
    private final DruidSchemaManager druidSchemaManager;
    private final CatalogResolver catalogResolver;

    @Inject
    public DruidSchema(BrokerSegmentMetadataCache segmentMetadataCache, DruidSchemaManager druidSchemaManager, CatalogResolver catalogResolver) {
        this.segmentMetadataCache = segmentMetadataCache;
        this.catalogResolver = catalogResolver;
        this.druidSchemaManager = druidSchemaManager != null && !(druidSchemaManager instanceof NoopDruidSchemaManager) ? druidSchemaManager : null;
    }

    protected BrokerSegmentMetadataCache cache() {
        return this.segmentMetadataCache;
    }

    public Table getTable(String name) {
        DruidTable schemaMgrTable = null;
        DruidTable catalogTable = this.catalogResolver.resolveDatasource(name, null);
        if (catalogTable == null && this.druidSchemaManager != null) {
            schemaMgrTable = this.druidSchemaManager.getTable(name, this.segmentMetadataCache);
        }
        if (schemaMgrTable == null) {
            DatasourceTable.PhysicalDatasourceMetadata dsMetadata = (DatasourceTable.PhysicalDatasourceMetadata)this.segmentMetadataCache.getDatasource(name);
            return this.catalogResolver.resolveDatasource(name, dsMetadata);
        }
        return schemaMgrTable;
    }

    public Set<String> getTableNames() {
        if (this.druidSchemaManager != null) {
            return this.druidSchemaManager.getTableNames(this.segmentMetadataCache);
        }
        return this.catalogResolver.getTableNames(this.segmentMetadataCache.getDatasourceNames());
    }
}

