/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.sun.jersey.api.core.HttpContext;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.druid.common.exception.SanitizableException;
import org.apache.druid.error.DruidException;
import org.apache.druid.guice.annotations.Self;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.QueryContext;
import org.apache.druid.server.DruidNode;
import org.apache.druid.server.QueryLifecycle;
import org.apache.druid.server.QueryResource;
import org.apache.druid.server.QueryResponse;
import org.apache.druid.server.QueryResultPusher;
import org.apache.druid.server.ResponseContextConfig;
import org.apache.druid.server.initialization.ServerConfig;
import org.apache.druid.server.security.Action;
import org.apache.druid.server.security.AuthenticationResult;
import org.apache.druid.server.security.AuthorizationResult;
import org.apache.druid.server.security.AuthorizationUtils;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.server.security.Resource;
import org.apache.druid.server.security.ResourceAction;
import org.apache.druid.sql.DirectStatement;
import org.apache.druid.sql.HttpStatement;
import org.apache.druid.sql.SqlLifecycleManager;
import org.apache.druid.sql.SqlQueryPlus;
import org.apache.druid.sql.SqlRowTransformer;
import org.apache.druid.sql.calcite.run.SqlEngine;
import org.apache.druid.sql.http.EngineInfo;
import org.apache.druid.sql.http.GetQueriesResponse;
import org.apache.druid.sql.http.QueryInfo;
import org.apache.druid.sql.http.ResultFormat;
import org.apache.druid.sql.http.SqlEngineRegistry;
import org.apache.druid.sql.http.SqlQuery;
import org.apache.druid.sql.http.SupportedEnginesResponse;

@Path(value="/druid/v2/sql/")
public class SqlResource {
    public static final String PATH = "/druid/v2/sql/";
    public static final String SQL_QUERY_ID_RESPONSE_HEADER = "X-Druid-SQL-Query-Id";
    public static final String SQL_HEADER_RESPONSE_HEADER = "X-Druid-SQL-Header-Included";
    public static final String SQL_HEADER_VALUE = "yes";
    private static final Logger log = new Logger(SqlResource.class);
    private static final SqlResourceQueryMetricCounter QUERY_METRIC_COUNTER = new SqlResourceQueryMetricCounter();
    private final ObjectMapper jsonMapper;
    private final AuthorizerMapper authorizerMapper;
    private final ServerConfig serverConfig;
    private final ResponseContextConfig responseContextConfig;
    private final DruidNode selfNode;
    private final SqlLifecycleManager sqlLifecycleManager;
    private final SqlEngineRegistry sqlEngineRegistry;

    @Inject
    @VisibleForTesting
    public SqlResource(ObjectMapper jsonMapper, AuthorizerMapper authorizerMapper, ServerConfig serverConfig, SqlLifecycleManager sqlLifecycleManager, SqlEngineRegistry sqlEngineRegistry, ResponseContextConfig responseContextConfig, @Self DruidNode selfNode) {
        this.sqlEngineRegistry = (SqlEngineRegistry)Preconditions.checkNotNull((Object)sqlEngineRegistry, (Object)"sqlEngineRegistry");
        this.jsonMapper = (ObjectMapper)Preconditions.checkNotNull((Object)jsonMapper, (Object)"jsonMapper");
        this.authorizerMapper = (AuthorizerMapper)Preconditions.checkNotNull((Object)authorizerMapper, (Object)"authorizerMapper");
        this.serverConfig = (ServerConfig)Preconditions.checkNotNull((Object)serverConfig, (Object)"serverConfig");
        this.responseContextConfig = responseContextConfig;
        this.selfNode = selfNode;
        this.sqlLifecycleManager = (SqlLifecycleManager)Preconditions.checkNotNull((Object)sqlLifecycleManager, (Object)"sqlLifecycleManager");
    }

    @GET
    @Path(value="/engines")
    @Produces(value={"application/json"})
    public Response getSupportedEngines(@Context HttpServletRequest request) {
        AuthorizationUtils.setRequestAuthorizationAttributeIfNeeded((HttpServletRequest)request);
        Set<EngineInfo> engines = this.sqlEngineRegistry.getSupportedEngines().stream().map(EngineInfo::new).collect(Collectors.toSet());
        return Response.ok((Object)new SupportedEnginesResponse(engines)).build();
    }

    @GET
    @Path(value="/queries")
    @Produces(value={"application/json"})
    public Response doGetRunningQueries(@QueryParam(value="selfOnly") String selfOnly, @Context HttpServletRequest request) {
        AuthenticationResult authenticationResult = AuthorizationUtils.authenticationResultFromRequest((HttpServletRequest)request);
        AuthorizationResult stateReadAccess = AuthorizationUtils.authorizeAllResourceActions((AuthenticationResult)authenticationResult, Collections.singletonList(new ResourceAction(Resource.STATE_RESOURCE, Action.READ)), (AuthorizerMapper)this.authorizerMapper);
        Collection<SqlEngine> engines = this.sqlEngineRegistry.getAllEngines();
        ArrayList<QueryInfo> queries = new ArrayList<QueryInfo>();
        for (SqlEngine sqlEngine : engines) {
            queries.addAll(sqlEngine.getRunningQueries(selfOnly != null, authenticationResult, stateReadAccess));
        }
        AuthorizationUtils.setRequestAuthorizationAttributeIfNeeded((HttpServletRequest)request);
        return Response.ok().entity((Object)new GetQueriesResponse(queries)).build();
    }

    @POST
    @Produces(value={"application/json"})
    @Nullable
    public Response doPost(@Context HttpServletRequest req, @Context HttpContext httpContext) {
        return this.doPost(SqlQuery.from(httpContext), req);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response doPost(SqlQuery sqlQuery, HttpServletRequest req) {
        HttpStatement stmt;
        QueryContext queryContext;
        try {
            SqlQueryPlus sqlQueryPlus = SqlResource.makeSqlQueryPlus(sqlQuery, req);
            queryContext = new QueryContext(sqlQueryPlus.context());
            String engineName = queryContext.getEngine();
            SqlEngine engine = this.sqlEngineRegistry.getEngine(engineName);
            stmt = engine.getSqlStatementFactory().httpStatement(sqlQueryPlus, req);
        }
        catch (Exception e) {
            return SqlResource.handleExceptionBeforeStatementCreated(e, sqlQuery.queryContext());
        }
        String currThreadName = Thread.currentThread().getName();
        try {
            Thread.currentThread().setName(StringUtils.format((String)"sql[%s]", (Object[])new Object[]{stmt.sqlQueryId()}));
            Response response = this.makePusher(req, stmt, sqlQuery, queryContext).push();
            return response;
        }
        finally {
            Thread.currentThread().setName(currThreadName);
        }
    }

    @DELETE
    @Path(value="{id}")
    @Produces(value={"application/json"})
    public Response cancelQuery(@PathParam(value="id") String sqlQueryId, @Context HttpServletRequest req) {
        log.debug("Received cancel request for query [%s]", new Object[]{sqlQueryId});
        List<SqlLifecycleManager.Cancelable> lifecycles = this.sqlLifecycleManager.getAll(sqlQueryId);
        if (lifecycles.isEmpty()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        AuthorizationResult authResult = this.authorizeCancellation(req, lifecycles);
        if (authResult.allowAccessWithNoRestriction()) {
            this.sqlLifecycleManager.removeAll(sqlQueryId, lifecycles);
            lifecycles.forEach(SqlLifecycleManager.Cancelable::cancel);
            return Response.status((Response.Status)Response.Status.ACCEPTED).build();
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
    }

    private SqlResourceQueryResultPusher makePusher(HttpServletRequest req, HttpStatement stmt, SqlQuery sqlQuery, QueryContext queryContext) {
        String sqlQueryId = stmt.sqlQueryId();
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
        headers.put(SQL_QUERY_ID_RESPONSE_HEADER, sqlQueryId);
        if (sqlQuery.includeHeader()) {
            headers.put(SQL_HEADER_RESPONSE_HEADER, SQL_HEADER_VALUE);
        }
        return new SqlResourceQueryResultPusher(req, sqlQueryId, stmt, sqlQuery, queryContext, headers);
    }

    public AuthorizationResult authorizeCancellation(HttpServletRequest req, List<SqlLifecycleManager.Cancelable> cancelables) {
        Set resources = cancelables.stream().flatMap(lifecycle -> lifecycle.resources().stream()).collect(Collectors.toSet());
        return AuthorizationUtils.authorizeAllResourceActions((HttpServletRequest)req, resources, (AuthorizerMapper)this.authorizerMapper);
    }

    public static SqlQueryPlus makeSqlQueryPlus(SqlQuery sqlQuery, HttpServletRequest req) {
        return SqlQueryPlus.builder().sql(sqlQuery.getQuery()).context(sqlQuery.getContext()).parameters(sqlQuery.getParameterList()).auth(AuthorizationUtils.authenticationResultFromRequest((HttpServletRequest)req)).build();
    }

    public static Response handleExceptionBeforeStatementCreated(Exception e, QueryContext queryContext) {
        if (e instanceof DruidException) {
            String sqlQueryId = queryContext.getString("sqlQueryId");
            return QueryResultPusher.handleDruidExceptionBeforeResponseStarted((DruidException)((DruidException)((Object)e)), (MediaType)MediaType.APPLICATION_JSON_TYPE, sqlQueryId != null ? ImmutableMap.builder().put((Object)"X-Druid-Query-Id", (Object)sqlQueryId).put((Object)SQL_QUERY_ID_RESPONSE_HEADER, (Object)sqlQueryId).build() : Collections.emptyMap());
        }
        return QueryResultPusher.handleDruidExceptionBeforeResponseStarted((DruidException)DruidException.forPersona((DruidException.Persona)DruidException.Persona.OPERATOR).ofCategory(DruidException.Category.RUNTIME_FAILURE).build((Throwable)e, "Cannot handle query", new Object[0]), (MediaType)MediaType.APPLICATION_JSON_TYPE, Collections.emptyMap());
    }

    private class SqlResourceQueryResultPusher
    extends QueryResultPusher {
        private final String sqlQueryId;
        private final HttpStatement stmt;
        private final SqlQuery sqlQuery;
        private final QueryContext queryContext;

        public SqlResourceQueryResultPusher(HttpServletRequest req, String sqlQueryId, HttpStatement stmt, SqlQuery sqlQuery, QueryContext queryContext, Map<String, String> headers) {
            super(req, SqlResource.this.jsonMapper, SqlResource.this.responseContextConfig, SqlResource.this.selfNode, (QueryResource.QueryMetricCounter)QUERY_METRIC_COUNTER, sqlQueryId, MediaType.APPLICATION_JSON_TYPE, headers);
            this.sqlQueryId = sqlQueryId;
            this.stmt = stmt;
            this.queryContext = queryContext;
            this.sqlQuery = sqlQuery;
        }

        public QueryResultPusher.ResultsWriter start() {
            return new QueryResultPusher.ResultsWriter(){
                private QueryResponse<Object[]> queryResponse;
                private DirectStatement.ResultSet thePlan;

                @Nullable
                public Response.ResponseBuilder start() {
                    this.thePlan = SqlResourceQueryResultPusher.this.stmt.plan();
                    this.queryResponse = this.thePlan.run();
                    return null;
                }

                public QueryResponse<Object> getQueryResponse() {
                    return this.queryResponse;
                }

                public QueryResultPusher.Writer makeWriter(OutputStream out) throws IOException {
                    final ResultFormat.Writer writer = SqlResourceQueryResultPusher.this.sqlQuery.getResultFormat().createFormatter(out, SqlResource.this.jsonMapper);
                    final SqlRowTransformer rowTransformer = this.thePlan.createRowTransformer();
                    return new QueryResultPusher.Writer(){

                        public void writeResponseStart() throws IOException {
                            writer.writeResponseStart();
                            if (SqlResourceQueryResultPusher.this.sqlQuery.includeHeader()) {
                                writer.writeHeader(rowTransformer.getRowType(), SqlResourceQueryResultPusher.this.sqlQuery.includeTypesHeader(), SqlResourceQueryResultPusher.this.sqlQuery.includeSqlTypesHeader());
                            }
                        }

                        public void writeRow(Object obj) throws IOException {
                            Object[] row = (Object[])obj;
                            writer.writeRowStart();
                            for (int i = 0; i < rowTransformer.getFieldList().size(); ++i) {
                                Object value = rowTransformer.transform(row, i);
                                writer.writeRowField(rowTransformer.getFieldList().get(i), value);
                            }
                            writer.writeRowEnd();
                        }

                        public void writeResponseEnd() throws IOException {
                            writer.writeResponseEnd();
                        }

                        public void close() throws IOException {
                            writer.close();
                        }
                    };
                }

                public void recordSuccess(long numBytes) {
                    SqlResourceQueryResultPusher.this.stmt.reporter().succeeded(numBytes);
                }

                public void recordFailure(Exception e) {
                    if (QueryLifecycle.shouldLogStackTrace((Throwable)e, (QueryContext)SqlResourceQueryResultPusher.this.queryContext)) {
                        log.warn((Throwable)e, "Exception while processing sqlQueryId[%s]", new Object[]{SqlResourceQueryResultPusher.this.sqlQueryId});
                    } else {
                        log.noStackTrace().warn((Throwable)e, "Exception while processing sqlQueryId[%s]", new Object[]{SqlResourceQueryResultPusher.this.sqlQueryId});
                    }
                    SqlResourceQueryResultPusher.this.stmt.reporter().failed(e);
                }

                public void close() {
                    SqlResourceQueryResultPusher.this.stmt.close();
                }
            };
        }

        public void writeException(Exception ex, OutputStream out) throws IOException {
            if (ex instanceof SanitizableException) {
                ex = SqlResource.this.serverConfig.getErrorResponseTransformStrategy().transformIfNeeded((SanitizableException)ex);
            }
            out.write(SqlResource.this.jsonMapper.writeValueAsBytes((Object)ex));
        }
    }

    private static class SqlResourceQueryMetricCounter
    implements QueryResource.QueryMetricCounter {
        private SqlResourceQueryMetricCounter() {
        }

        public void incrementSuccess() {
        }

        public void incrementFailed() {
        }

        public void incrementInterrupted() {
        }

        public void incrementTimedOut() {
        }
    }
}

