/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.http;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.sql.Date;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.calcite.avatica.ColumnMetaData;
import org.apache.calcite.avatica.SqlType;
import org.apache.calcite.avatica.remote.TypedValue;
import org.apache.calcite.runtime.SqlFunctions;
import org.apache.calcite.util.TimestampString;
import org.apache.druid.java.util.common.DateTimes;

public class SqlParameter {
    private final SqlType type;
    private final Object value;

    @JsonCreator
    public SqlParameter(@JsonProperty(value="type") SqlType type, @JsonProperty(value="value") @Nullable Object value) {
        this.type = (SqlType)Preconditions.checkNotNull((Object)type);
        this.value = value;
    }

    @JsonProperty
    public Object getValue() {
        return this.value;
    }

    @JsonProperty
    public SqlType getType() {
        return this.type;
    }

    @JsonIgnore
    public TypedValue getTypedValue() {
        Object adjustedValue = this.value;
        if (this.type == SqlType.TIMESTAMP) {
            if (this.value instanceof String) {
                try {
                    adjustedValue = DateTimes.of((String)((String)this.value)).getMillis();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                try {
                    adjustedValue = new TimestampString((String)this.value).getMillisSinceEpoch();
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        } else if (this.type == SqlType.DATE && this.value instanceof String) {
            try {
                adjustedValue = SqlFunctions.toInt((Date)Date.valueOf((String)this.value));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return TypedValue.create((String)ColumnMetaData.Rep.nonPrimitiveRepOf((SqlType)this.type).name(), (Object)adjustedValue);
    }

    public String toString() {
        return "SqlParameter{, value={" + this.type.name() + "," + String.valueOf(this.value) + "}}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqlParameter that = (SqlParameter)o;
        return Objects.equals(this.type, that.type) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.value);
    }
}

